"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityNotificationEmails = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails okta_security_notification_emails}
*/
class SecurityNotificationEmails extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails okta_security_notification_emails} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityNotificationEmailsConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_security_notification_emails',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._id = config.id;
        this._reportSuspiciousActivityEnabled = config.reportSuspiciousActivityEnabled;
        this._sendEmailForFactorEnrollmentEnabled = config.sendEmailForFactorEnrollmentEnabled;
        this._sendEmailForFactorResetEnabled = config.sendEmailForFactorResetEnabled;
        this._sendEmailForNewDeviceEnabled = config.sendEmailForNewDeviceEnabled;
        this._sendEmailForPasswordChangedEnabled = config.sendEmailForPasswordChangedEnabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get reportSuspiciousActivityEnabled() {
        return this.getBooleanAttribute('report_suspicious_activity_enabled');
    }
    set reportSuspiciousActivityEnabled(value) {
        this._reportSuspiciousActivityEnabled = value;
    }
    resetReportSuspiciousActivityEnabled() {
        this._reportSuspiciousActivityEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get reportSuspiciousActivityEnabledInput() {
        return this._reportSuspiciousActivityEnabled;
    }
    get sendEmailForFactorEnrollmentEnabled() {
        return this.getBooleanAttribute('send_email_for_factor_enrollment_enabled');
    }
    set sendEmailForFactorEnrollmentEnabled(value) {
        this._sendEmailForFactorEnrollmentEnabled = value;
    }
    resetSendEmailForFactorEnrollmentEnabled() {
        this._sendEmailForFactorEnrollmentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendEmailForFactorEnrollmentEnabledInput() {
        return this._sendEmailForFactorEnrollmentEnabled;
    }
    get sendEmailForFactorResetEnabled() {
        return this.getBooleanAttribute('send_email_for_factor_reset_enabled');
    }
    set sendEmailForFactorResetEnabled(value) {
        this._sendEmailForFactorResetEnabled = value;
    }
    resetSendEmailForFactorResetEnabled() {
        this._sendEmailForFactorResetEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendEmailForFactorResetEnabledInput() {
        return this._sendEmailForFactorResetEnabled;
    }
    get sendEmailForNewDeviceEnabled() {
        return this.getBooleanAttribute('send_email_for_new_device_enabled');
    }
    set sendEmailForNewDeviceEnabled(value) {
        this._sendEmailForNewDeviceEnabled = value;
    }
    resetSendEmailForNewDeviceEnabled() {
        this._sendEmailForNewDeviceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendEmailForNewDeviceEnabledInput() {
        return this._sendEmailForNewDeviceEnabled;
    }
    get sendEmailForPasswordChangedEnabled() {
        return this.getBooleanAttribute('send_email_for_password_changed_enabled');
    }
    set sendEmailForPasswordChangedEnabled(value) {
        this._sendEmailForPasswordChangedEnabled = value;
    }
    resetSendEmailForPasswordChangedEnabled() {
        this._sendEmailForPasswordChangedEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendEmailForPasswordChangedEnabledInput() {
        return this._sendEmailForPasswordChangedEnabled;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            report_suspicious_activity_enabled: cdktf.booleanToTerraform(this._reportSuspiciousActivityEnabled),
            send_email_for_factor_enrollment_enabled: cdktf.booleanToTerraform(this._sendEmailForFactorEnrollmentEnabled),
            send_email_for_factor_reset_enabled: cdktf.booleanToTerraform(this._sendEmailForFactorResetEnabled),
            send_email_for_new_device_enabled: cdktf.booleanToTerraform(this._sendEmailForNewDeviceEnabled),
            send_email_for_password_changed_enabled: cdktf.booleanToTerraform(this._sendEmailForPasswordChangedEnabled),
        };
    }
}
exports.SecurityNotificationEmails = SecurityNotificationEmails;
_a = JSII_RTTI_SYMBOL_1;
SecurityNotificationEmails[_a] = { fqn: "@cdktf/provider-okta.SecurityNotificationEmails", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
SecurityNotificationEmails.tfResourceType = "okta_security_notification_emails";
//# sourceMappingURL=data:application/json;base64,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