import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SignonPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy Description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#description SignonPolicy#description}
    */
    readonly description?: string;
    /**
    * List of Group IDs to Include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#groups_included SignonPolicy#groups_included}
    */
    readonly groupsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#id SignonPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#name SignonPolicy#name}
    */
    readonly name: string;
    /**
    * Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#priority SignonPolicy#priority}
    */
    readonly priority?: number;
    /**
    * Policy Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy#status SignonPolicy#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/signon_policy okta_signon_policy}
*/
export declare class SignonPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_signon_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/signon_policy okta_signon_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignonPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SignonPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _groupsIncluded?;
    get groupsIncluded(): string[];
    set groupsIncluded(value: string[]);
    resetGroupsIncluded(): void;
    get groupsIncludedInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
