import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SocialIdpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#account_link_action SocialIdp#account_link_action}
    */
    readonly accountLinkAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#account_link_group_include SocialIdp#account_link_group_include}
    */
    readonly accountLinkGroupInclude?: string[];
    /**
    * The Key ID that you obtained from Apple when you created the private key for the client
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#apple_kid SocialIdp#apple_kid}
    */
    readonly appleKid?: string;
    /**
    * The PKCS #8 encoded private key that you created for the client and downloaded from Apple
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#apple_private_key SocialIdp#apple_private_key}
    */
    readonly applePrivateKey?: string;
    /**
    * The Team ID associated with your Apple developer account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#apple_team_id SocialIdp#apple_team_id}
    */
    readonly appleTeamId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#client_id SocialIdp#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#client_secret SocialIdp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#deprovisioned_action SocialIdp#deprovisioned_action}
    */
    readonly deprovisionedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#groups_action SocialIdp#groups_action}
    */
    readonly groupsAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#groups_assignment SocialIdp#groups_assignment}
    */
    readonly groupsAssignment?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#groups_attribute SocialIdp#groups_attribute}
    */
    readonly groupsAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#groups_filter SocialIdp#groups_filter}
    */
    readonly groupsFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#id SocialIdp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#issuer_mode SocialIdp#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#match_attribute SocialIdp#match_attribute}
    */
    readonly matchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#match_type SocialIdp#match_type}
    */
    readonly matchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#max_clock_skew SocialIdp#max_clock_skew}
    */
    readonly maxClockSkew?: number;
    /**
    * Name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#name SocialIdp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#profile_master SocialIdp#profile_master}
    */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#protocol_type SocialIdp#protocol_type}
    */
    readonly protocolType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#provisioning_action SocialIdp#provisioning_action}
    */
    readonly provisioningAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#scopes SocialIdp#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#status SocialIdp#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#subject_match_attribute SocialIdp#subject_match_attribute}
    */
    readonly subjectMatchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#subject_match_type SocialIdp#subject_match_type}
    */
    readonly subjectMatchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#suspended_action SocialIdp#suspended_action}
    */
    readonly suspendedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#type SocialIdp#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp#username_template SocialIdp#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/social_idp okta_social_idp}
*/
export declare class SocialIdp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_social_idp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/social_idp okta_social_idp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SocialIdpConfig
    */
    constructor(scope: Construct, id: string, config: SocialIdpConfig);
    private _accountLinkAction?;
    get accountLinkAction(): string;
    set accountLinkAction(value: string);
    resetAccountLinkAction(): void;
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    get accountLinkGroupInclude(): string[];
    set accountLinkGroupInclude(value: string[]);
    resetAccountLinkGroupInclude(): void;
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _appleKid?;
    get appleKid(): string;
    set appleKid(value: string);
    resetAppleKid(): void;
    get appleKidInput(): string | undefined;
    private _applePrivateKey?;
    get applePrivateKey(): string;
    set applePrivateKey(value: string);
    resetApplePrivateKey(): void;
    get applePrivateKeyInput(): string | undefined;
    private _appleTeamId?;
    get appleTeamId(): string;
    set appleTeamId(value: string);
    resetAppleTeamId(): void;
    get appleTeamIdInput(): string | undefined;
    get authorizationBinding(): string;
    get authorizationUrl(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    get deprovisionedAction(): string;
    set deprovisionedAction(value: string);
    resetDeprovisionedAction(): void;
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    get groupsAction(): string;
    set groupsAction(value: string);
    resetGroupsAction(): void;
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    get groupsAssignment(): string[];
    set groupsAssignment(value: string[]);
    resetGroupsAssignment(): void;
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    get groupsAttribute(): string;
    set groupsAttribute(value: string);
    resetGroupsAttribute(): void;
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    get groupsFilter(): string[];
    set groupsFilter(value: string[]);
    resetGroupsFilter(): void;
    get groupsFilterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _matchAttribute?;
    get matchAttribute(): string;
    set matchAttribute(value: string);
    resetMatchAttribute(): void;
    get matchAttributeInput(): string | undefined;
    private _matchType?;
    get matchType(): string;
    set matchType(value: string);
    resetMatchType(): void;
    get matchTypeInput(): string | undefined;
    private _maxClockSkew?;
    get maxClockSkew(): number;
    set maxClockSkew(value: number);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileMaster?;
    get profileMaster(): boolean | cdktf.IResolvable;
    set profileMaster(value: boolean | cdktf.IResolvable);
    resetProfileMaster(): void;
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    get protocolType(): string;
    set protocolType(value: string);
    resetProtocolType(): void;
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    get provisioningAction(): string;
    set provisioningAction(value: string);
    resetProvisioningAction(): void;
    get provisioningActionInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    get subjectMatchAttribute(): string;
    set subjectMatchAttribute(value: string);
    resetSubjectMatchAttribute(): void;
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    get subjectMatchType(): string;
    set subjectMatchType(value: string);
    resetSubjectMatchType(): void;
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    get suspendedAction(): string;
    set suspendedAction(value: string);
    resetSuspendedAction(): void;
    get suspendedActionInput(): string | undefined;
    get tokenBinding(): string;
    get tokenUrl(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
