import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TemplateEmailConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#default_language TemplateEmail#default_language}
    */
    readonly defaultLanguage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#id TemplateEmail#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Email template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#type TemplateEmail#type}
    */
    readonly type: string;
    /**
    * translations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#translations TemplateEmail#translations}
    */
    readonly translations: TemplateEmailTranslations[] | cdktf.IResolvable;
}
export interface TemplateEmailTranslations {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#language TemplateEmail#language}
    */
    readonly language: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#subject TemplateEmail#subject}
    */
    readonly subject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email#template TemplateEmail#template}
    */
    readonly template: string;
}
export declare function templateEmailTranslationsToTerraform(struct?: TemplateEmailTranslations | cdktf.IResolvable): any;
export declare class TemplateEmailTranslationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TemplateEmailTranslations | cdktf.IResolvable | undefined;
    set internalValue(value: TemplateEmailTranslations | cdktf.IResolvable | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    get languageInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
}
export declare class TemplateEmailTranslationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TemplateEmailTranslations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TemplateEmailTranslationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/template_email okta_template_email}
*/
export declare class TemplateEmail extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_template_email";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/template_email okta_template_email} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TemplateEmailConfig
    */
    constructor(scope: Construct, id: string, config: TemplateEmailConfig);
    private _defaultLanguage?;
    get defaultLanguage(): string;
    set defaultLanguage(value: string);
    resetDefaultLanguage(): void;
    get defaultLanguageInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _translations;
    get translations(): TemplateEmailTranslationsList;
    putTranslations(value: TemplateEmailTranslations[] | cdktf.IResolvable): void;
    get translationsInput(): cdktf.IResolvable | TemplateEmailTranslations[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
