import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TemplateSmsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#id TemplateSms#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * SMS default template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#template TemplateSms#template}
    */
    readonly template: string;
    /**
    * SMS template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#type TemplateSms#type}
    */
    readonly type: string;
    /**
    * translations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#translations TemplateSms#translations}
    */
    readonly translations?: TemplateSmsTranslations[] | cdktf.IResolvable;
}
export interface TemplateSmsTranslations {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#language TemplateSms#language}
    */
    readonly language: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms#template TemplateSms#template}
    */
    readonly template: string;
}
export declare function templateSmsTranslationsToTerraform(struct?: TemplateSmsTranslations | cdktf.IResolvable): any;
export declare class TemplateSmsTranslationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TemplateSmsTranslations | cdktf.IResolvable | undefined;
    set internalValue(value: TemplateSmsTranslations | cdktf.IResolvable | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    get languageInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
}
export declare class TemplateSmsTranslationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TemplateSmsTranslations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TemplateSmsTranslationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/template_sms okta_template_sms}
*/
export declare class TemplateSms extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_template_sms";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/template_sms okta_template_sms} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TemplateSmsConfig
    */
    constructor(scope: Construct, id: string, config: TemplateSmsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _translations;
    get translations(): TemplateSmsTranslationsList;
    putTranslations(value: TemplateSmsTranslations[] | cdktf.IResolvable): void;
    resetTranslations(): void;
    get translationsInput(): cdktf.IResolvable | TemplateSmsTranslations[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
