import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ThemeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path to local file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#background_image Theme#background_image}
    */
    readonly backgroundImage?: string;
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#brand_id Theme#brand_id}
    */
    readonly brandId: string;
    /**
    * Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#email_template_touch_point_variant Theme#email_template_touch_point_variant}
    */
    readonly emailTemplateTouchPointVariant?: string;
    /**
    * Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#end_user_dashboard_touch_point_variant Theme#end_user_dashboard_touch_point_variant}
    */
    readonly endUserDashboardTouchPointVariant?: string;
    /**
    * Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#error_page_touch_point_variant Theme#error_page_touch_point_variant}
    */
    readonly errorPageTouchPointVariant?: string;
    /**
    * Path to local file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#favicon Theme#favicon}
    */
    readonly favicon?: string;
    /**
    * Path to local file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#logo Theme#logo}
    */
    readonly logo?: string;
    /**
    * Primary color contrast hex code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#primary_color_contrast_hex Theme#primary_color_contrast_hex}
    */
    readonly primaryColorContrastHex?: string;
    /**
    * Primary color hex code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#primary_color_hex Theme#primary_color_hex}
    */
    readonly primaryColorHex?: string;
    /**
    * Secondary color contrast hex code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#secondary_color_contrast_hex Theme#secondary_color_contrast_hex}
    */
    readonly secondaryColorContrastHex?: string;
    /**
    * Secondary color hex code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#secondary_color_hex Theme#secondary_color_hex}
    */
    readonly secondaryColorHex?: string;
    /**
    * Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#sign_in_page_touch_point_variant Theme#sign_in_page_touch_point_variant}
    */
    readonly signInPageTouchPointVariant?: string;
    /**
    * Theme ID - Note: Okta API for theme only reads and updates therefore the okta_theme resource needs to act as a quasi data source. Do this by setting theme_id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/theme#theme_id Theme#theme_id}
    */
    readonly themeId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/theme okta_theme}
*/
export declare class Theme extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_theme";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/theme okta_theme} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ThemeConfig
    */
    constructor(scope: Construct, id: string, config: ThemeConfig);
    private _backgroundImage?;
    get backgroundImage(): string;
    set backgroundImage(value: string);
    resetBackgroundImage(): void;
    get backgroundImageInput(): string | undefined;
    get backgroundImageUrl(): string;
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    private _emailTemplateTouchPointVariant?;
    get emailTemplateTouchPointVariant(): string;
    set emailTemplateTouchPointVariant(value: string);
    resetEmailTemplateTouchPointVariant(): void;
    get emailTemplateTouchPointVariantInput(): string | undefined;
    private _endUserDashboardTouchPointVariant?;
    get endUserDashboardTouchPointVariant(): string;
    set endUserDashboardTouchPointVariant(value: string);
    resetEndUserDashboardTouchPointVariant(): void;
    get endUserDashboardTouchPointVariantInput(): string | undefined;
    private _errorPageTouchPointVariant?;
    get errorPageTouchPointVariant(): string;
    set errorPageTouchPointVariant(value: string);
    resetErrorPageTouchPointVariant(): void;
    get errorPageTouchPointVariantInput(): string | undefined;
    private _favicon?;
    get favicon(): string;
    set favicon(value: string);
    resetFavicon(): void;
    get faviconInput(): string | undefined;
    get faviconUrl(): string;
    get id(): string;
    get links(): string;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    private _primaryColorContrastHex?;
    get primaryColorContrastHex(): string;
    set primaryColorContrastHex(value: string);
    resetPrimaryColorContrastHex(): void;
    get primaryColorContrastHexInput(): string | undefined;
    private _primaryColorHex?;
    get primaryColorHex(): string;
    set primaryColorHex(value: string);
    resetPrimaryColorHex(): void;
    get primaryColorHexInput(): string | undefined;
    private _secondaryColorContrastHex?;
    get secondaryColorContrastHex(): string;
    set secondaryColorContrastHex(value: string);
    resetSecondaryColorContrastHex(): void;
    get secondaryColorContrastHexInput(): string | undefined;
    private _secondaryColorHex?;
    get secondaryColorHex(): string;
    set secondaryColorHex(value: string);
    resetSecondaryColorHex(): void;
    get secondaryColorHexInput(): string | undefined;
    private _signInPageTouchPointVariant?;
    get signInPageTouchPointVariant(): string;
    set signInPageTouchPointVariant(value: string);
    resetSignInPageTouchPointVariant(): void;
    get signInPageTouchPointVariantInput(): string | undefined;
    private _themeId?;
    get themeId(): string;
    set themeId(value: string);
    resetThemeId(): void;
    get themeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
