"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Theme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/theme okta_theme}
*/
class Theme extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/theme okta_theme} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ThemeConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_theme',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._backgroundImage = config.backgroundImage;
        this._brandId = config.brandId;
        this._emailTemplateTouchPointVariant = config.emailTemplateTouchPointVariant;
        this._endUserDashboardTouchPointVariant = config.endUserDashboardTouchPointVariant;
        this._errorPageTouchPointVariant = config.errorPageTouchPointVariant;
        this._favicon = config.favicon;
        this._logo = config.logo;
        this._primaryColorContrastHex = config.primaryColorContrastHex;
        this._primaryColorHex = config.primaryColorHex;
        this._secondaryColorContrastHex = config.secondaryColorContrastHex;
        this._secondaryColorHex = config.secondaryColorHex;
        this._signInPageTouchPointVariant = config.signInPageTouchPointVariant;
        this._themeId = config.themeId;
    }
    get backgroundImage() {
        return this.getStringAttribute('background_image');
    }
    set backgroundImage(value) {
        this._backgroundImage = value;
    }
    resetBackgroundImage() {
        this._backgroundImage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backgroundImageInput() {
        return this._backgroundImage;
    }
    // background_image_url - computed: true, optional: false, required: false
    get backgroundImageUrl() {
        return this.getStringAttribute('background_image_url');
    }
    get brandId() {
        return this.getStringAttribute('brand_id');
    }
    set brandId(value) {
        this._brandId = value;
    }
    // Temporarily expose input value. Use with caution.
    get brandIdInput() {
        return this._brandId;
    }
    get emailTemplateTouchPointVariant() {
        return this.getStringAttribute('email_template_touch_point_variant');
    }
    set emailTemplateTouchPointVariant(value) {
        this._emailTemplateTouchPointVariant = value;
    }
    resetEmailTemplateTouchPointVariant() {
        this._emailTemplateTouchPointVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailTemplateTouchPointVariantInput() {
        return this._emailTemplateTouchPointVariant;
    }
    get endUserDashboardTouchPointVariant() {
        return this.getStringAttribute('end_user_dashboard_touch_point_variant');
    }
    set endUserDashboardTouchPointVariant(value) {
        this._endUserDashboardTouchPointVariant = value;
    }
    resetEndUserDashboardTouchPointVariant() {
        this._endUserDashboardTouchPointVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endUserDashboardTouchPointVariantInput() {
        return this._endUserDashboardTouchPointVariant;
    }
    get errorPageTouchPointVariant() {
        return this.getStringAttribute('error_page_touch_point_variant');
    }
    set errorPageTouchPointVariant(value) {
        this._errorPageTouchPointVariant = value;
    }
    resetErrorPageTouchPointVariant() {
        this._errorPageTouchPointVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorPageTouchPointVariantInput() {
        return this._errorPageTouchPointVariant;
    }
    get favicon() {
        return this.getStringAttribute('favicon');
    }
    set favicon(value) {
        this._favicon = value;
    }
    resetFavicon() {
        this._favicon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faviconInput() {
        return this._favicon;
    }
    // favicon_url - computed: true, optional: false, required: false
    get faviconUrl() {
        return this.getStringAttribute('favicon_url');
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // links - computed: true, optional: false, required: false
    get links() {
        return this.getStringAttribute('links');
    }
    get logo() {
        return this.getStringAttribute('logo');
    }
    set logo(value) {
        this._logo = value;
    }
    resetLogo() {
        this._logo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logoInput() {
        return this._logo;
    }
    // logo_url - computed: true, optional: false, required: false
    get logoUrl() {
        return this.getStringAttribute('logo_url');
    }
    get primaryColorContrastHex() {
        return this.getStringAttribute('primary_color_contrast_hex');
    }
    set primaryColorContrastHex(value) {
        this._primaryColorContrastHex = value;
    }
    resetPrimaryColorContrastHex() {
        this._primaryColorContrastHex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryColorContrastHexInput() {
        return this._primaryColorContrastHex;
    }
    get primaryColorHex() {
        return this.getStringAttribute('primary_color_hex');
    }
    set primaryColorHex(value) {
        this._primaryColorHex = value;
    }
    resetPrimaryColorHex() {
        this._primaryColorHex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryColorHexInput() {
        return this._primaryColorHex;
    }
    get secondaryColorContrastHex() {
        return this.getStringAttribute('secondary_color_contrast_hex');
    }
    set secondaryColorContrastHex(value) {
        this._secondaryColorContrastHex = value;
    }
    resetSecondaryColorContrastHex() {
        this._secondaryColorContrastHex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryColorContrastHexInput() {
        return this._secondaryColorContrastHex;
    }
    get secondaryColorHex() {
        return this.getStringAttribute('secondary_color_hex');
    }
    set secondaryColorHex(value) {
        this._secondaryColorHex = value;
    }
    resetSecondaryColorHex() {
        this._secondaryColorHex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryColorHexInput() {
        return this._secondaryColorHex;
    }
    get signInPageTouchPointVariant() {
        return this.getStringAttribute('sign_in_page_touch_point_variant');
    }
    set signInPageTouchPointVariant(value) {
        this._signInPageTouchPointVariant = value;
    }
    resetSignInPageTouchPointVariant() {
        this._signInPageTouchPointVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInPageTouchPointVariantInput() {
        return this._signInPageTouchPointVariant;
    }
    get themeId() {
        return this.getStringAttribute('theme_id');
    }
    set themeId(value) {
        this._themeId = value;
    }
    resetThemeId() {
        this._themeId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get themeIdInput() {
        return this._themeId;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            background_image: cdktf.stringToTerraform(this._backgroundImage),
            brand_id: cdktf.stringToTerraform(this._brandId),
            email_template_touch_point_variant: cdktf.stringToTerraform(this._emailTemplateTouchPointVariant),
            end_user_dashboard_touch_point_variant: cdktf.stringToTerraform(this._endUserDashboardTouchPointVariant),
            error_page_touch_point_variant: cdktf.stringToTerraform(this._errorPageTouchPointVariant),
            favicon: cdktf.stringToTerraform(this._favicon),
            logo: cdktf.stringToTerraform(this._logo),
            primary_color_contrast_hex: cdktf.stringToTerraform(this._primaryColorContrastHex),
            primary_color_hex: cdktf.stringToTerraform(this._primaryColorHex),
            secondary_color_contrast_hex: cdktf.stringToTerraform(this._secondaryColorContrastHex),
            secondary_color_hex: cdktf.stringToTerraform(this._secondaryColorHex),
            sign_in_page_touch_point_variant: cdktf.stringToTerraform(this._signInPageTouchPointVariant),
            theme_id: cdktf.stringToTerraform(this._themeId),
        };
    }
}
exports.Theme = Theme;
_a = JSII_RTTI_SYMBOL_1;
Theme[_a] = { fqn: "@cdktf/provider-okta.Theme", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
Theme.tfResourceType = "okta_theme";
//# sourceMappingURL=data:application/json;base64,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