import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ThreatInsightSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies how Okta responds to authentication requests from suspicious IPs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings#action ThreatInsightSettings#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings#id ThreatInsightSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of Network Zone IDs to exclude to be not logged or blocked by Okta ThreatInsight and proceed to Sign On rules evaluation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings#network_excludes ThreatInsightSettings#network_excludes}
    */
    readonly networkExcludes?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings okta_threat_insight_settings}
*/
export declare class ThreatInsightSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_threat_insight_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings okta_threat_insight_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ThreatInsightSettingsConfig
    */
    constructor(scope: Construct, id: string, config: ThreatInsightSettingsConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
