import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrustedOriginConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the Trusted Origin is active or not - can only be issued post-creation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin#active TrustedOrigin#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin#id TrustedOrigin#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this trusted origin
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin#name TrustedOrigin#name}
    */
    readonly name: string;
    /**
    * Unique origin URL for this trusted origin
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin#origin TrustedOrigin#origin}
    */
    readonly origin: string;
    /**
    * Scopes of the Trusted Origin - can either be CORS or REDIRECT only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin#scopes TrustedOrigin#scopes}
    */
    readonly scopes: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin okta_trusted_origin}
*/
export declare class TrustedOrigin extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_trusted_origin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin okta_trusted_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrustedOriginConfig
    */
    constructor(scope: Construct, id: string, config: TrustedOriginConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _origin?;
    get origin(): string;
    set origin(value: string);
    get originInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
