import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserAdminRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * User Okta admin roles - ie. ['APP_ADMIN', 'USER_ADMIN']
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles#admin_roles UserAdminRoles#admin_roles}
    */
    readonly adminRoles: string[];
    /**
    * When this setting is enabled, the admins won't receive any of the default Okta administrator emails
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles#disable_notifications UserAdminRoles#disable_notifications}
    */
    readonly disableNotifications?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles#id UserAdminRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of a Okta User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles#user_id UserAdminRoles#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles okta_user_admin_roles}
*/
export declare class UserAdminRoles extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_admin_roles";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles okta_user_admin_roles} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserAdminRolesConfig
    */
    constructor(scope: Construct, id: string, config: UserAdminRolesConfig);
    private _adminRoles?;
    get adminRoles(): string[];
    set adminRoles(value: string[]);
    get adminRolesInput(): string[] | undefined;
    private _disableNotifications?;
    get disableNotifications(): boolean | cdktf.IResolvable;
    set disableNotifications(value: boolean | cdktf.IResolvable);
    resetDisableNotifications(): void;
    get disableNotificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
