import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserBaseSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#id UserBaseSchema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#index UserBaseSchema#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#master UserBaseSchema#master}
    */
    readonly master?: string;
    /**
    * The validation pattern to use for the subschema. Must be in form of '.+', or '[<pattern>]+' if present.'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#pattern UserBaseSchema#pattern}
    */
    readonly pattern?: string;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#permissions UserBaseSchema#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#required UserBaseSchema#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#title UserBaseSchema#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#type UserBaseSchema#type}
    */
    readonly type: string;
    /**
    * Custom subschema user type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema#user_type UserBaseSchema#user_type}
    */
    readonly userType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema okta_user_base_schema}
*/
export declare class UserBaseSchema extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_base_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema okta_user_base_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserBaseSchemaConfig
    */
    constructor(scope: Construct, id: string, config: UserBaseSchemaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
