import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserFactorQuestionConfig extends cdktf.TerraformMetaArguments {
    /**
    * User password security answer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question#answer UserFactorQuestion#answer}
    */
    readonly answer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question#id UserFactorQuestion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique key for question
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question#key UserFactorQuestion#key}
    */
    readonly key: string;
    /**
    * ID of a Okta User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question#user_id UserFactorQuestion#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question okta_user_factor_question}
*/
export declare class UserFactorQuestion extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_factor_question";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question okta_user_factor_question} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserFactorQuestionConfig
    */
    constructor(scope: Construct, id: string, config: UserFactorQuestionConfig);
    private _answer?;
    get answer(): string;
    set answer(value: string);
    get answerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get status(): string;
    get text(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
