import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserGroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The list of Okta group IDs which the user should have membership managed for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships#groups UserGroupMemberships#groups}
    */
    readonly groups: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships#id UserGroupMemberships#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of a Okta User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships#user_id UserGroupMemberships#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships okta_user_group_memberships}
*/
export declare class UserGroupMemberships extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_group_memberships";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships okta_user_group_memberships} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserGroupMembershipsConfig
    */
    constructor(scope: Construct, id: string, config: UserGroupMembershipsConfig);
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    get groupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
