import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom Subschema enumerated value of a property of type array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#array_enum UserSchemaProperty#array_enum}
    */
    readonly arrayEnum?: string[];
    /**
    * Subschema array type: string, number, integer, reference. Type field must be an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#array_type UserSchemaProperty#array_type}
    */
    readonly arrayType?: string;
    /**
    * Custom Subschema description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#description UserSchemaProperty#description}
    */
    readonly description?: string;
    /**
    * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#enum UserSchemaProperty#enum}
    */
    readonly enum?: string[];
    /**
    * Subschema external name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#external_name UserSchemaProperty#external_name}
    */
    readonly externalName?: string;
    /**
    * Subschema external namespace
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#external_namespace UserSchemaProperty#external_namespace}
    */
    readonly externalNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#id UserSchemaProperty#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#index UserSchemaProperty#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#master UserSchemaProperty#master}
    */
    readonly master?: string;
    /**
    * Subschema of type string maximum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#max_length UserSchemaProperty#max_length}
    */
    readonly maxLength?: number;
    /**
    * Subschema of type string minimum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#min_length UserSchemaProperty#min_length}
    */
    readonly minLength?: number;
    /**
    * The validation pattern to use for the subschema. Must be in form of '.+', or '[<pattern>]+' if present.'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#pattern UserSchemaProperty#pattern}
    */
    readonly pattern?: string;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#permissions UserSchemaProperty#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#required UserSchemaProperty#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#scope UserSchemaProperty#scope}
    */
    readonly scope?: string;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#title UserSchemaProperty#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#type UserSchemaProperty#type}
    */
    readonly type: string;
    /**
    * Subschema unique restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#unique UserSchemaProperty#unique}
    */
    readonly unique?: string;
    /**
    * Custom subschema user type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#user_type UserSchemaProperty#user_type}
    */
    readonly userType?: string;
    /**
    * array_one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#array_one_of UserSchemaProperty#array_one_of}
    */
    readonly arrayOneOf?: UserSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * master_override_priority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#master_override_priority UserSchemaProperty#master_override_priority}
    */
    readonly masterOverridePriority?: UserSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#one_of UserSchemaProperty#one_of}
    */
    readonly oneOf?: UserSchemaPropertyOneOf[] | cdktf.IResolvable;
}
export interface UserSchemaPropertyArrayOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#const UserSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#title UserSchemaProperty#title}
    */
    readonly title: string;
}
export declare function userSchemaPropertyArrayOneOfToTerraform(struct?: UserSchemaPropertyArrayOneOf | cdktf.IResolvable): any;
export declare class UserSchemaPropertyArrayOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class UserSchemaPropertyArrayOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaPropertyArrayOneOfOutputReference;
}
export interface UserSchemaPropertyMasterOverridePriority {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#type UserSchemaProperty#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#value UserSchemaProperty#value}
    */
    readonly value: string;
}
export declare function userSchemaPropertyMasterOverridePriorityToTerraform(struct?: UserSchemaPropertyMasterOverridePriority | cdktf.IResolvable): any;
export declare class UserSchemaPropertyMasterOverridePriorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaPropertyMasterOverridePriority | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaPropertyMasterOverridePriority | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserSchemaPropertyMasterOverridePriorityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaPropertyMasterOverridePriorityOutputReference;
}
export interface UserSchemaPropertyOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#const UserSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property#title UserSchemaProperty#title}
    */
    readonly title: string;
}
export declare function userSchemaPropertyOneOfToTerraform(struct?: UserSchemaPropertyOneOf | cdktf.IResolvable): any;
export declare class UserSchemaPropertyOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaPropertyOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaPropertyOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class UserSchemaPropertyOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaPropertyOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaPropertyOneOfOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property okta_user_schema_property}
*/
export declare class UserSchemaProperty extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_schema_property";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_schema_property okta_user_schema_property} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserSchemaPropertyConfig
    */
    constructor(scope: Construct, id: string, config: UserSchemaPropertyConfig);
    private _arrayEnum?;
    get arrayEnum(): string[];
    set arrayEnum(value: string[]);
    resetArrayEnum(): void;
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    get arrayType(): string;
    set arrayType(value: string);
    resetArrayType(): void;
    get arrayTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enum?;
    get enum(): string[];
    set enum(value: string[]);
    resetEnum(): void;
    get enumInput(): string[] | undefined;
    private _externalName?;
    get externalName(): string;
    set externalName(value: string);
    resetExternalName(): void;
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    get externalNamespace(): string;
    set externalNamespace(value: string);
    resetExternalNamespace(): void;
    get externalNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unique?;
    get unique(): string;
    set unique(value: string);
    resetUnique(): void;
    get uniqueInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _arrayOneOf;
    get arrayOneOf(): UserSchemaPropertyArrayOneOfList;
    putArrayOneOf(value: UserSchemaPropertyArrayOneOf[] | cdktf.IResolvable): void;
    resetArrayOneOf(): void;
    get arrayOneOfInput(): cdktf.IResolvable | UserSchemaPropertyArrayOneOf[] | undefined;
    private _masterOverridePriority;
    get masterOverridePriority(): UserSchemaPropertyMasterOverridePriorityList;
    putMasterOverridePriority(value: UserSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable): void;
    resetMasterOverridePriority(): void;
    get masterOverridePriorityInput(): cdktf.IResolvable | UserSchemaPropertyMasterOverridePriority[] | undefined;
    private _oneOf;
    get oneOf(): UserSchemaPropertyOneOfList;
    putOneOf(value: UserSchemaPropertyOneOf[] | cdktf.IResolvable): void;
    resetOneOf(): void;
    get oneOfInput(): cdktf.IResolvable | UserSchemaPropertyOneOf[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
