import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom Subschema enumerated value of a property of type array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#array_enum UserSchema#array_enum}
    */
    readonly arrayEnum?: string[];
    /**
    * Subschema array type: string, number, integer, reference. Type field must be an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#array_type UserSchema#array_type}
    */
    readonly arrayType?: string;
    /**
    * Custom Subschema description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#description UserSchema#description}
    */
    readonly description?: string;
    /**
    * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#enum UserSchema#enum}
    */
    readonly enum?: string[];
    /**
    * Subschema external name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#external_name UserSchema#external_name}
    */
    readonly externalName?: string;
    /**
    * Subschema external namespace
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#external_namespace UserSchema#external_namespace}
    */
    readonly externalNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#id UserSchema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#index UserSchema#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#master UserSchema#master}
    */
    readonly master?: string;
    /**
    * Subschema of type string maximum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#max_length UserSchema#max_length}
    */
    readonly maxLength?: number;
    /**
    * Subschema of type string minimum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#min_length UserSchema#min_length}
    */
    readonly minLength?: number;
    /**
    * The validation pattern to use for the subschema. Must be in form of '.+', or '[<pattern>]+' if present.'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#pattern UserSchema#pattern}
    */
    readonly pattern?: string;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#permissions UserSchema#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#required UserSchema#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#scope UserSchema#scope}
    */
    readonly scope?: string;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#title UserSchema#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#type UserSchema#type}
    */
    readonly type: string;
    /**
    * Subschema unique restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#unique UserSchema#unique}
    */
    readonly unique?: string;
    /**
    * Custom subschema user type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#user_type UserSchema#user_type}
    */
    readonly userType?: string;
    /**
    * array_one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#array_one_of UserSchema#array_one_of}
    */
    readonly arrayOneOf?: UserSchemaArrayOneOf[] | cdktf.IResolvable;
    /**
    * master_override_priority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#master_override_priority UserSchema#master_override_priority}
    */
    readonly masterOverridePriority?: UserSchemaMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#one_of UserSchema#one_of}
    */
    readonly oneOf?: UserSchemaOneOf[] | cdktf.IResolvable;
}
export interface UserSchemaArrayOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#const UserSchema#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#title UserSchema#title}
    */
    readonly title: string;
}
export declare function userSchemaArrayOneOfToTerraform(struct?: UserSchemaArrayOneOf | cdktf.IResolvable): any;
export declare class UserSchemaArrayOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaArrayOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaArrayOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class UserSchemaArrayOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaArrayOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaArrayOneOfOutputReference;
}
export interface UserSchemaMasterOverridePriority {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#type UserSchema#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#value UserSchema#value}
    */
    readonly value: string;
}
export declare function userSchemaMasterOverridePriorityToTerraform(struct?: UserSchemaMasterOverridePriority | cdktf.IResolvable): any;
export declare class UserSchemaMasterOverridePriorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaMasterOverridePriority | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaMasterOverridePriority | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserSchemaMasterOverridePriorityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaMasterOverridePriorityOutputReference;
}
export interface UserSchemaOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#const UserSchema#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema#title UserSchema#title}
    */
    readonly title: string;
}
export declare function userSchemaOneOfToTerraform(struct?: UserSchemaOneOf | cdktf.IResolvable): any;
export declare class UserSchemaOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSchemaOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: UserSchemaOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class UserSchemaOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSchemaOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSchemaOneOfOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_schema okta_user_schema}
*/
export declare class UserSchema extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_schema okta_user_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserSchemaConfig
    */
    constructor(scope: Construct, id: string, config: UserSchemaConfig);
    private _arrayEnum?;
    get arrayEnum(): string[];
    set arrayEnum(value: string[]);
    resetArrayEnum(): void;
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    get arrayType(): string;
    set arrayType(value: string);
    resetArrayType(): void;
    get arrayTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enum?;
    get enum(): string[];
    set enum(value: string[]);
    resetEnum(): void;
    get enumInput(): string[] | undefined;
    private _externalName?;
    get externalName(): string;
    set externalName(value: string);
    resetExternalName(): void;
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    get externalNamespace(): string;
    set externalNamespace(value: string);
    resetExternalNamespace(): void;
    get externalNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unique?;
    get unique(): string;
    set unique(value: string);
    resetUnique(): void;
    get uniqueInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _arrayOneOf;
    get arrayOneOf(): UserSchemaArrayOneOfList;
    putArrayOneOf(value: UserSchemaArrayOneOf[] | cdktf.IResolvable): void;
    resetArrayOneOf(): void;
    get arrayOneOfInput(): cdktf.IResolvable | UserSchemaArrayOneOf[] | undefined;
    private _masterOverridePriority;
    get masterOverridePriority(): UserSchemaMasterOverridePriorityList;
    putMasterOverridePriority(value: UserSchemaMasterOverridePriority[] | cdktf.IResolvable): void;
    resetMasterOverridePriority(): void;
    get masterOverridePriorityInput(): cdktf.IResolvable | UserSchemaMasterOverridePriority[] | undefined;
    private _oneOf;
    get oneOf(): UserSchemaOneOfList;
    putOneOf(value: UserSchemaOneOf[] | cdktf.IResolvable): void;
    resetOneOf(): void;
    get oneOfInput(): cdktf.IResolvable | UserSchemaOneOf[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
