import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * User Okta admin roles - ie. ['APP_ADMIN', 'USER_ADMIN']
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#admin_roles User#admin_roles}
    */
    readonly adminRoles?: string[];
    /**
    * User city
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#city User#city}
    */
    readonly city?: string;
    /**
    * User cost center
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#cost_center User#cost_center}
    */
    readonly costCenter?: string;
    /**
    * User country code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#country_code User#country_code}
    */
    readonly countryCode?: string;
    /**
    * JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#custom_profile_attributes User#custom_profile_attributes}
    */
    readonly customProfileAttributes?: string;
    /**
    * User department
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#department User#department}
    */
    readonly department?: string;
    /**
    * User display name, suitable to show end users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#display_name User#display_name}
    */
    readonly displayName?: string;
    /**
    * User division
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#division User#division}
    */
    readonly division?: string;
    /**
    * User primary email address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#email User#email}
    */
    readonly email: string;
    /**
    * User employee number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#employee_number User#employee_number}
    */
    readonly employeeNumber?: string;
    /**
    * If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#expire_password_on_create User#expire_password_on_create}
    */
    readonly expirePasswordOnCreate?: boolean | cdktf.IResolvable;
    /**
    * User first name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#first_name User#first_name}
    */
    readonly firstName: string;
    /**
    * The groups that you want this user to be a part of. This can also be done via the group using the `users` property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#group_memberships User#group_memberships}
    */
    readonly groupMemberships?: string[];
    /**
    * User honorific prefix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#honorific_prefix User#honorific_prefix}
    */
    readonly honorificPrefix?: string;
    /**
    * User honorific suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#honorific_suffix User#honorific_suffix}
    */
    readonly honorificSuffix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User last name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#last_name User#last_name}
    */
    readonly lastName: string;
    /**
    * User default location
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#locale User#locale}
    */
    readonly locale?: string;
    /**
    * User Okta login
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#login User#login}
    */
    readonly login: string;
    /**
    * Manager of User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#manager User#manager}
    */
    readonly manager?: string;
    /**
    * Manager ID of User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#manager_id User#manager_id}
    */
    readonly managerId?: string;
    /**
    * User middle name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#middle_name User#middle_name}
    */
    readonly middleName?: string;
    /**
    * User mobile phone number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#mobile_phone User#mobile_phone}
    */
    readonly mobilePhone?: string;
    /**
    * User nickname
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#nick_name User#nick_name}
    */
    readonly nickName?: string;
    /**
    * Old User Password. Should be only set in case the password was not changed using the provider
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#old_password User#old_password}
    */
    readonly oldPassword?: string;
    /**
    * User organization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#organization User#organization}
    */
    readonly organization?: string;
    /**
    * User Password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#password User#password}
    */
    readonly password?: string;
    /**
    * When specified, the Password Inline Hook is triggered to handle verification of the end user's password the first time the user tries to sign in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#password_inline_hook User#password_inline_hook}
    */
    readonly passwordInlineHook?: string;
    /**
    * User mailing address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#postal_address User#postal_address}
    */
    readonly postalAddress?: string;
    /**
    * User preferred language
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#preferred_language User#preferred_language}
    */
    readonly preferredLanguage?: string;
    /**
    * User primary phone number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#primary_phone User#primary_phone}
    */
    readonly primaryPhone?: string;
    /**
    * User online profile (web page)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#profile_url User#profile_url}
    */
    readonly profileUrl?: string;
    /**
    * User Password Recovery Answer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#recovery_answer User#recovery_answer}
    */
    readonly recoveryAnswer?: string;
    /**
    * User Password Recovery Question
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#recovery_question User#recovery_question}
    */
    readonly recoveryQuestion?: string;
    /**
    * User secondary email address, used for account recovery
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#second_email User#second_email}
    */
    readonly secondEmail?: string;
    /**
    * User state or region
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#state User#state}
    */
    readonly state?: string;
    /**
    * The status of the User in Okta - remove to set user back to active/provisioned
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#status User#status}
    */
    readonly status?: string;
    /**
    * User street address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#street_address User#street_address}
    */
    readonly streetAddress?: string;
    /**
    * User default timezone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#timezone User#timezone}
    */
    readonly timezone?: string;
    /**
    * User title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#title User#title}
    */
    readonly title?: string;
    /**
    * User employee type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#user_type User#user_type}
    */
    readonly userType?: string;
    /**
    * User zipcode or postal code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#zip_code User#zip_code}
    */
    readonly zipCode?: string;
    /**
    * password_hash block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#password_hash User#password_hash}
    */
    readonly passwordHash?: UserPasswordHash;
}
export interface UserPasswordHash {
    /**
    * The algorithm used to generate the hash using the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#algorithm User#algorithm}
    */
    readonly algorithm: string;
    /**
    * Only required for salted hashes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#salt User#salt}
    */
    readonly salt?: string;
    /**
    * Specifies whether salt was pre- or postfixed to the password before hashing
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#salt_order User#salt_order}
    */
    readonly saltOrder?: string;
    /**
    * For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#value User#value}
    */
    readonly value: string;
    /**
    * Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user#work_factor User#work_factor}
    */
    readonly workFactor?: number;
}
export declare function userPasswordHashToTerraform(struct?: UserPasswordHashOutputReference | UserPasswordHash): any;
export declare class UserPasswordHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): UserPasswordHash | undefined;
    set internalValue(value: UserPasswordHash | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _salt?;
    get salt(): string;
    set salt(value: string);
    resetSalt(): void;
    get saltInput(): string | undefined;
    private _saltOrder?;
    get saltOrder(): string;
    set saltOrder(value: string);
    resetSaltOrder(): void;
    get saltOrderInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _workFactor?;
    get workFactor(): number;
    set workFactor(value: number);
    resetWorkFactor(): void;
    get workFactorInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user okta_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user okta_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _adminRoles?;
    get adminRoles(): string[];
    set adminRoles(value: string[]);
    resetAdminRoles(): void;
    get adminRolesInput(): string[] | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _costCenter?;
    get costCenter(): string;
    set costCenter(value: string);
    resetCostCenter(): void;
    get costCenterInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _customProfileAttributes?;
    get customProfileAttributes(): string;
    set customProfileAttributes(value: string);
    resetCustomProfileAttributes(): void;
    get customProfileAttributesInput(): string | undefined;
    private _department?;
    get department(): string;
    set department(value: string);
    resetDepartment(): void;
    get departmentInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _division?;
    get division(): string;
    set division(value: string);
    resetDivision(): void;
    get divisionInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _employeeNumber?;
    get employeeNumber(): string;
    set employeeNumber(value: string);
    resetEmployeeNumber(): void;
    get employeeNumberInput(): string | undefined;
    private _expirePasswordOnCreate?;
    get expirePasswordOnCreate(): boolean | cdktf.IResolvable;
    set expirePasswordOnCreate(value: boolean | cdktf.IResolvable);
    resetExpirePasswordOnCreate(): void;
    get expirePasswordOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    get firstNameInput(): string | undefined;
    private _groupMemberships?;
    get groupMemberships(): string[];
    set groupMemberships(value: string[]);
    resetGroupMemberships(): void;
    get groupMembershipsInput(): string[] | undefined;
    private _honorificPrefix?;
    get honorificPrefix(): string;
    set honorificPrefix(value: string);
    resetHonorificPrefix(): void;
    get honorificPrefixInput(): string | undefined;
    private _honorificSuffix?;
    get honorificSuffix(): string;
    set honorificSuffix(value: string);
    resetHonorificSuffix(): void;
    get honorificSuffixInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _locale?;
    get locale(): string;
    set locale(value: string);
    resetLocale(): void;
    get localeInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    get loginInput(): string | undefined;
    private _manager?;
    get manager(): string;
    set manager(value: string);
    resetManager(): void;
    get managerInput(): string | undefined;
    private _managerId?;
    get managerId(): string;
    set managerId(value: string);
    resetManagerId(): void;
    get managerIdInput(): string | undefined;
    private _middleName?;
    get middleName(): string;
    set middleName(value: string);
    resetMiddleName(): void;
    get middleNameInput(): string | undefined;
    private _mobilePhone?;
    get mobilePhone(): string;
    set mobilePhone(value: string);
    resetMobilePhone(): void;
    get mobilePhoneInput(): string | undefined;
    private _nickName?;
    get nickName(): string;
    set nickName(value: string);
    resetNickName(): void;
    get nickNameInput(): string | undefined;
    private _oldPassword?;
    get oldPassword(): string;
    set oldPassword(value: string);
    resetOldPassword(): void;
    get oldPasswordInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _passwordInlineHook?;
    get passwordInlineHook(): string;
    set passwordInlineHook(value: string);
    resetPasswordInlineHook(): void;
    get passwordInlineHookInput(): string | undefined;
    private _postalAddress?;
    get postalAddress(): string;
    set postalAddress(value: string);
    resetPostalAddress(): void;
    get postalAddressInput(): string | undefined;
    private _preferredLanguage?;
    get preferredLanguage(): string;
    set preferredLanguage(value: string);
    resetPreferredLanguage(): void;
    get preferredLanguageInput(): string | undefined;
    private _primaryPhone?;
    get primaryPhone(): string;
    set primaryPhone(value: string);
    resetPrimaryPhone(): void;
    get primaryPhoneInput(): string | undefined;
    private _profileUrl?;
    get profileUrl(): string;
    set profileUrl(value: string);
    resetProfileUrl(): void;
    get profileUrlInput(): string | undefined;
    get rawStatus(): string;
    private _recoveryAnswer?;
    get recoveryAnswer(): string;
    set recoveryAnswer(value: string);
    resetRecoveryAnswer(): void;
    get recoveryAnswerInput(): string | undefined;
    private _recoveryQuestion?;
    get recoveryQuestion(): string;
    set recoveryQuestion(value: string);
    resetRecoveryQuestion(): void;
    get recoveryQuestionInput(): string | undefined;
    private _secondEmail?;
    get secondEmail(): string;
    set secondEmail(value: string);
    resetSecondEmail(): void;
    get secondEmailInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _zipCode?;
    get zipCode(): string;
    set zipCode(value: string);
    resetZipCode(): void;
    get zipCodeInput(): string | undefined;
    private _passwordHash;
    get passwordHash(): UserPasswordHashOutputReference;
    putPasswordHash(value: UserPasswordHash): void;
    resetPasswordHash(): void;
    get passwordHashInput(): UserPasswordHash | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
