"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.UserPasswordHashOutputReference = exports.userPasswordHashToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function userPasswordHashToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        algorithm: cdktf.stringToTerraform(struct.algorithm),
        salt: cdktf.stringToTerraform(struct.salt),
        salt_order: cdktf.stringToTerraform(struct.saltOrder),
        value: cdktf.stringToTerraform(struct.value),
        work_factor: cdktf.numberToTerraform(struct.workFactor),
    };
}
exports.userPasswordHashToTerraform = userPasswordHashToTerraform;
class UserPasswordHashOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._algorithm !== undefined) {
            hasAnyValues = true;
            internalValueResult.algorithm = this._algorithm;
        }
        if (this._salt !== undefined) {
            hasAnyValues = true;
            internalValueResult.salt = this._salt;
        }
        if (this._saltOrder !== undefined) {
            hasAnyValues = true;
            internalValueResult.saltOrder = this._saltOrder;
        }
        if (this._value !== undefined) {
            hasAnyValues = true;
            internalValueResult.value = this._value;
        }
        if (this._workFactor !== undefined) {
            hasAnyValues = true;
            internalValueResult.workFactor = this._workFactor;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._algorithm = undefined;
            this._salt = undefined;
            this._saltOrder = undefined;
            this._value = undefined;
            this._workFactor = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._algorithm = value.algorithm;
            this._salt = value.salt;
            this._saltOrder = value.saltOrder;
            this._value = value.value;
            this._workFactor = value.workFactor;
        }
    }
    get algorithm() {
        return this.getStringAttribute('algorithm');
    }
    set algorithm(value) {
        this._algorithm = value;
    }
    // Temporarily expose input value. Use with caution.
    get algorithmInput() {
        return this._algorithm;
    }
    get salt() {
        return this.getStringAttribute('salt');
    }
    set salt(value) {
        this._salt = value;
    }
    resetSalt() {
        this._salt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saltInput() {
        return this._salt;
    }
    get saltOrder() {
        return this.getStringAttribute('salt_order');
    }
    set saltOrder(value) {
        this._saltOrder = value;
    }
    resetSaltOrder() {
        this._saltOrder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saltOrderInput() {
        return this._saltOrder;
    }
    get value() {
        return this.getStringAttribute('value');
    }
    set value(value) {
        this._value = value;
    }
    // Temporarily expose input value. Use with caution.
    get valueInput() {
        return this._value;
    }
    get workFactor() {
        return this.getNumberAttribute('work_factor');
    }
    set workFactor(value) {
        this._workFactor = value;
    }
    resetWorkFactor() {
        this._workFactor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workFactorInput() {
        return this._workFactor;
    }
}
exports.UserPasswordHashOutputReference = UserPasswordHashOutputReference;
_a = JSII_RTTI_SYMBOL_1;
UserPasswordHashOutputReference[_a] = { fqn: "@cdktf/provider-okta.UserPasswordHashOutputReference", version: "2.0.46" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/user okta_user}
*/
class User extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user okta_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_user',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // password_hash - computed: false, optional: true, required: false
        this._passwordHash = new UserPasswordHashOutputReference(this, "password_hash");
        this._adminRoles = config.adminRoles;
        this._city = config.city;
        this._costCenter = config.costCenter;
        this._countryCode = config.countryCode;
        this._customProfileAttributes = config.customProfileAttributes;
        this._department = config.department;
        this._displayName = config.displayName;
        this._division = config.division;
        this._email = config.email;
        this._employeeNumber = config.employeeNumber;
        this._expirePasswordOnCreate = config.expirePasswordOnCreate;
        this._firstName = config.firstName;
        this._groupMemberships = config.groupMemberships;
        this._honorificPrefix = config.honorificPrefix;
        this._honorificSuffix = config.honorificSuffix;
        this._id = config.id;
        this._lastName = config.lastName;
        this._locale = config.locale;
        this._login = config.login;
        this._manager = config.manager;
        this._managerId = config.managerId;
        this._middleName = config.middleName;
        this._mobilePhone = config.mobilePhone;
        this._nickName = config.nickName;
        this._oldPassword = config.oldPassword;
        this._organization = config.organization;
        this._password = config.password;
        this._passwordInlineHook = config.passwordInlineHook;
        this._postalAddress = config.postalAddress;
        this._preferredLanguage = config.preferredLanguage;
        this._primaryPhone = config.primaryPhone;
        this._profileUrl = config.profileUrl;
        this._recoveryAnswer = config.recoveryAnswer;
        this._recoveryQuestion = config.recoveryQuestion;
        this._secondEmail = config.secondEmail;
        this._state = config.state;
        this._status = config.status;
        this._streetAddress = config.streetAddress;
        this._timezone = config.timezone;
        this._title = config.title;
        this._userType = config.userType;
        this._zipCode = config.zipCode;
        this._passwordHash.internalValue = config.passwordHash;
    }
    get adminRoles() {
        return cdktf.Fn.tolist(this.getListAttribute('admin_roles'));
    }
    set adminRoles(value) {
        this._adminRoles = value;
    }
    resetAdminRoles() {
        this._adminRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminRolesInput() {
        return this._adminRoles;
    }
    get city() {
        return this.getStringAttribute('city');
    }
    set city(value) {
        this._city = value;
    }
    resetCity() {
        this._city = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cityInput() {
        return this._city;
    }
    get costCenter() {
        return this.getStringAttribute('cost_center');
    }
    set costCenter(value) {
        this._costCenter = value;
    }
    resetCostCenter() {
        this._costCenter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costCenterInput() {
        return this._costCenter;
    }
    get countryCode() {
        return this.getStringAttribute('country_code');
    }
    set countryCode(value) {
        this._countryCode = value;
    }
    resetCountryCode() {
        this._countryCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get countryCodeInput() {
        return this._countryCode;
    }
    get customProfileAttributes() {
        return this.getStringAttribute('custom_profile_attributes');
    }
    set customProfileAttributes(value) {
        this._customProfileAttributes = value;
    }
    resetCustomProfileAttributes() {
        this._customProfileAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customProfileAttributesInput() {
        return this._customProfileAttributes;
    }
    get department() {
        return this.getStringAttribute('department');
    }
    set department(value) {
        this._department = value;
    }
    resetDepartment() {
        this._department = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get departmentInput() {
        return this._department;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    resetDisplayName() {
        this._displayName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get division() {
        return this.getStringAttribute('division');
    }
    set division(value) {
        this._division = value;
    }
    resetDivision() {
        this._division = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get divisionInput() {
        return this._division;
    }
    get email() {
        return this.getStringAttribute('email');
    }
    set email(value) {
        this._email = value;
    }
    // Temporarily expose input value. Use with caution.
    get emailInput() {
        return this._email;
    }
    get employeeNumber() {
        return this.getStringAttribute('employee_number');
    }
    set employeeNumber(value) {
        this._employeeNumber = value;
    }
    resetEmployeeNumber() {
        this._employeeNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get employeeNumberInput() {
        return this._employeeNumber;
    }
    get expirePasswordOnCreate() {
        return this.getBooleanAttribute('expire_password_on_create');
    }
    set expirePasswordOnCreate(value) {
        this._expirePasswordOnCreate = value;
    }
    resetExpirePasswordOnCreate() {
        this._expirePasswordOnCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirePasswordOnCreateInput() {
        return this._expirePasswordOnCreate;
    }
    get firstName() {
        return this.getStringAttribute('first_name');
    }
    set firstName(value) {
        this._firstName = value;
    }
    // Temporarily expose input value. Use with caution.
    get firstNameInput() {
        return this._firstName;
    }
    get groupMemberships() {
        return cdktf.Fn.tolist(this.getListAttribute('group_memberships'));
    }
    set groupMemberships(value) {
        this._groupMemberships = value;
    }
    resetGroupMemberships() {
        this._groupMemberships = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupMembershipsInput() {
        return this._groupMemberships;
    }
    get honorificPrefix() {
        return this.getStringAttribute('honorific_prefix');
    }
    set honorificPrefix(value) {
        this._honorificPrefix = value;
    }
    resetHonorificPrefix() {
        this._honorificPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get honorificPrefixInput() {
        return this._honorificPrefix;
    }
    get honorificSuffix() {
        return this.getStringAttribute('honorific_suffix');
    }
    set honorificSuffix(value) {
        this._honorificSuffix = value;
    }
    resetHonorificSuffix() {
        this._honorificSuffix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get honorificSuffixInput() {
        return this._honorificSuffix;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lastName() {
        return this.getStringAttribute('last_name');
    }
    set lastName(value) {
        this._lastName = value;
    }
    // Temporarily expose input value. Use with caution.
    get lastNameInput() {
        return this._lastName;
    }
    get locale() {
        return this.getStringAttribute('locale');
    }
    set locale(value) {
        this._locale = value;
    }
    resetLocale() {
        this._locale = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localeInput() {
        return this._locale;
    }
    get login() {
        return this.getStringAttribute('login');
    }
    set login(value) {
        this._login = value;
    }
    // Temporarily expose input value. Use with caution.
    get loginInput() {
        return this._login;
    }
    get manager() {
        return this.getStringAttribute('manager');
    }
    set manager(value) {
        this._manager = value;
    }
    resetManager() {
        this._manager = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managerInput() {
        return this._manager;
    }
    get managerId() {
        return this.getStringAttribute('manager_id');
    }
    set managerId(value) {
        this._managerId = value;
    }
    resetManagerId() {
        this._managerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managerIdInput() {
        return this._managerId;
    }
    get middleName() {
        return this.getStringAttribute('middle_name');
    }
    set middleName(value) {
        this._middleName = value;
    }
    resetMiddleName() {
        this._middleName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get middleNameInput() {
        return this._middleName;
    }
    get mobilePhone() {
        return this.getStringAttribute('mobile_phone');
    }
    set mobilePhone(value) {
        this._mobilePhone = value;
    }
    resetMobilePhone() {
        this._mobilePhone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mobilePhoneInput() {
        return this._mobilePhone;
    }
    get nickName() {
        return this.getStringAttribute('nick_name');
    }
    set nickName(value) {
        this._nickName = value;
    }
    resetNickName() {
        this._nickName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nickNameInput() {
        return this._nickName;
    }
    get oldPassword() {
        return this.getStringAttribute('old_password');
    }
    set oldPassword(value) {
        this._oldPassword = value;
    }
    resetOldPassword() {
        this._oldPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oldPasswordInput() {
        return this._oldPassword;
    }
    get organization() {
        return this.getStringAttribute('organization');
    }
    set organization(value) {
        this._organization = value;
    }
    resetOrganization() {
        this._organization = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationInput() {
        return this._organization;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get passwordInlineHook() {
        return this.getStringAttribute('password_inline_hook');
    }
    set passwordInlineHook(value) {
        this._passwordInlineHook = value;
    }
    resetPasswordInlineHook() {
        this._passwordInlineHook = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInlineHookInput() {
        return this._passwordInlineHook;
    }
    get postalAddress() {
        return this.getStringAttribute('postal_address');
    }
    set postalAddress(value) {
        this._postalAddress = value;
    }
    resetPostalAddress() {
        this._postalAddress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get postalAddressInput() {
        return this._postalAddress;
    }
    get preferredLanguage() {
        return this.getStringAttribute('preferred_language');
    }
    set preferredLanguage(value) {
        this._preferredLanguage = value;
    }
    resetPreferredLanguage() {
        this._preferredLanguage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preferredLanguageInput() {
        return this._preferredLanguage;
    }
    get primaryPhone() {
        return this.getStringAttribute('primary_phone');
    }
    set primaryPhone(value) {
        this._primaryPhone = value;
    }
    resetPrimaryPhone() {
        this._primaryPhone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryPhoneInput() {
        return this._primaryPhone;
    }
    get profileUrl() {
        return this.getStringAttribute('profile_url');
    }
    set profileUrl(value) {
        this._profileUrl = value;
    }
    resetProfileUrl() {
        this._profileUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileUrlInput() {
        return this._profileUrl;
    }
    // raw_status - computed: true, optional: false, required: false
    get rawStatus() {
        return this.getStringAttribute('raw_status');
    }
    get recoveryAnswer() {
        return this.getStringAttribute('recovery_answer');
    }
    set recoveryAnswer(value) {
        this._recoveryAnswer = value;
    }
    resetRecoveryAnswer() {
        this._recoveryAnswer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryAnswerInput() {
        return this._recoveryAnswer;
    }
    get recoveryQuestion() {
        return this.getStringAttribute('recovery_question');
    }
    set recoveryQuestion(value) {
        this._recoveryQuestion = value;
    }
    resetRecoveryQuestion() {
        this._recoveryQuestion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryQuestionInput() {
        return this._recoveryQuestion;
    }
    get secondEmail() {
        return this.getStringAttribute('second_email');
    }
    set secondEmail(value) {
        this._secondEmail = value;
    }
    resetSecondEmail() {
        this._secondEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondEmailInput() {
        return this._secondEmail;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    get status() {
        return this.getStringAttribute('status');
    }
    set status(value) {
        this._status = value;
    }
    resetStatus() {
        this._status = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statusInput() {
        return this._status;
    }
    get streetAddress() {
        return this.getStringAttribute('street_address');
    }
    set streetAddress(value) {
        this._streetAddress = value;
    }
    resetStreetAddress() {
        this._streetAddress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streetAddressInput() {
        return this._streetAddress;
    }
    get timezone() {
        return this.getStringAttribute('timezone');
    }
    set timezone(value) {
        this._timezone = value;
    }
    resetTimezone() {
        this._timezone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timezoneInput() {
        return this._timezone;
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    resetTitle() {
        this._title = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    get userType() {
        return this.getStringAttribute('user_type');
    }
    set userType(value) {
        this._userType = value;
    }
    resetUserType() {
        this._userType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTypeInput() {
        return this._userType;
    }
    get zipCode() {
        return this.getStringAttribute('zip_code');
    }
    set zipCode(value) {
        this._zipCode = value;
    }
    resetZipCode() {
        this._zipCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zipCodeInput() {
        return this._zipCode;
    }
    get passwordHash() {
        return this._passwordHash;
    }
    putPasswordHash(value) {
        this._passwordHash.internalValue = value;
    }
    resetPasswordHash() {
        this._passwordHash.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordHashInput() {
        return this._passwordHash.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            admin_roles: cdktf.listMapper(cdktf.stringToTerraform, false)(this._adminRoles),
            city: cdktf.stringToTerraform(this._city),
            cost_center: cdktf.stringToTerraform(this._costCenter),
            country_code: cdktf.stringToTerraform(this._countryCode),
            custom_profile_attributes: cdktf.stringToTerraform(this._customProfileAttributes),
            department: cdktf.stringToTerraform(this._department),
            display_name: cdktf.stringToTerraform(this._displayName),
            division: cdktf.stringToTerraform(this._division),
            email: cdktf.stringToTerraform(this._email),
            employee_number: cdktf.stringToTerraform(this._employeeNumber),
            expire_password_on_create: cdktf.booleanToTerraform(this._expirePasswordOnCreate),
            first_name: cdktf.stringToTerraform(this._firstName),
            group_memberships: cdktf.listMapper(cdktf.stringToTerraform, false)(this._groupMemberships),
            honorific_prefix: cdktf.stringToTerraform(this._honorificPrefix),
            honorific_suffix: cdktf.stringToTerraform(this._honorificSuffix),
            id: cdktf.stringToTerraform(this._id),
            last_name: cdktf.stringToTerraform(this._lastName),
            locale: cdktf.stringToTerraform(this._locale),
            login: cdktf.stringToTerraform(this._login),
            manager: cdktf.stringToTerraform(this._manager),
            manager_id: cdktf.stringToTerraform(this._managerId),
            middle_name: cdktf.stringToTerraform(this._middleName),
            mobile_phone: cdktf.stringToTerraform(this._mobilePhone),
            nick_name: cdktf.stringToTerraform(this._nickName),
            old_password: cdktf.stringToTerraform(this._oldPassword),
            organization: cdktf.stringToTerraform(this._organization),
            password: cdktf.stringToTerraform(this._password),
            password_inline_hook: cdktf.stringToTerraform(this._passwordInlineHook),
            postal_address: cdktf.stringToTerraform(this._postalAddress),
            preferred_language: cdktf.stringToTerraform(this._preferredLanguage),
            primary_phone: cdktf.stringToTerraform(this._primaryPhone),
            profile_url: cdktf.stringToTerraform(this._profileUrl),
            recovery_answer: cdktf.stringToTerraform(this._recoveryAnswer),
            recovery_question: cdktf.stringToTerraform(this._recoveryQuestion),
            second_email: cdktf.stringToTerraform(this._secondEmail),
            state: cdktf.stringToTerraform(this._state),
            status: cdktf.stringToTerraform(this._status),
            street_address: cdktf.stringToTerraform(this._streetAddress),
            timezone: cdktf.stringToTerraform(this._timezone),
            title: cdktf.stringToTerraform(this._title),
            user_type: cdktf.stringToTerraform(this._userType),
            zip_code: cdktf.stringToTerraform(this._zipCode),
            password_hash: userPasswordHashToTerraform(this._passwordHash.internalValue),
        };
    }
}
exports.User = User;
_b = JSII_RTTI_SYMBOL_1;
User[_b] = { fqn: "@cdktf/provider-okta.User", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
User.tfResourceType = "okta_user";
//# sourceMappingURL=data:application/json;base64,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