# Generated by Django 4.2.7 on 2024-02-26 08:33

import apps.allocations.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Allocation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('requested', models.PositiveIntegerField(verbose_name='Requested Service Units')),
                ('awarded', models.PositiveIntegerField(blank=True, null=True, verbose_name='Awarded Service Units')),
                ('final', models.PositiveIntegerField(blank=True, null=True, verbose_name='Final Usage')),
            ],
            bases=(apps.allocations.models.TeamModelInterface, models.Model),
        ),
        migrations.CreateModel(
            name='AllocationRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250)),
                ('description', models.TextField(max_length=1600)),
                ('submitted', models.DateField(auto_now=True, verbose_name='Submission Date')),
                ('approved', models.DateField(blank=True, null=True, verbose_name='Approval Date')),
                ('active', models.DateField(blank=True, null=True, verbose_name='Active Date')),
                ('expire', models.DateField(blank=True, null=True, verbose_name='Expiration Date')),
            ],
            bases=(apps.allocations.models.TeamModelInterface, models.Model),
        ),
        migrations.CreateModel(
            name='Cluster',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True, max_length=150, null=True)),
                ('enabled', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_data', models.FileField(upload_to='')),
                ('uploaded', models.DateTimeField(auto_now=True)),
                ('request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocations.allocationrequest')),
            ],
        ),
        migrations.CreateModel(
            name='AllocationRequestReview',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('approve', models.BooleanField()),
                ('public_comments', models.TextField(blank=True, max_length=1600, null=True)),
                ('private_comments', models.TextField(blank=True, max_length=1600, null=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='allocations.allocationrequest')),
            ],
            bases=(apps.allocations.models.TeamModelInterface, models.Model),
        ),
    ]
