# Generated by Django 5.0.4 on 2024-06-11 14:41

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import apps.notifications.models


def default_alloc_thresholds() -> list[int]:  # pragma: nocover
    """The default allocating usage thresholds at which to issue a user notification.

    Returned values are defined in units of percent usage.
    """

    return [90]


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('read', models.BooleanField(default=False)),
                ('message', models.TextField()),
                ('metadata', models.JSONField(null=True)),
                ('notification_type', models.CharField(choices=[('RU', 'Resource Usage'), ('SU', 'Status Update'), ('GM', 'General Message')], default='GM', max_length=2)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Preference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alloc_thresholds', models.JSONField(default=default_alloc_thresholds)),
                ('notify_status_update', models.BooleanField(default=True)),
                ('expiry_thresholds', models.JSONField(default=apps.notifications.models.default_expiry_thresholds)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
