"""Used to configure datasinks for sensor streams.

This service is used to configure datasink endpoints for frames and 
telemetry post-processing. It maintains an internal consumer list of 
datasinks that the kernel broadcasts frames and telemetry to. RPC 
methods within this service allow for manipulation of this list.

Attributes:
    STUB (compute_service_pb2_grpc.ComputeStub): stub that is automatically set at runtime so that actions
        for this service can connect to gRPC
"""

###############################################################
# NOTE: THIS FILE IS GENERATED BY GENERATE_API.PY. DO NOT EDIT!
###############################################################
from typing import Optional, List
from google.protobuf.timestamp_pb2 import Timestamp
from google.protobuf.duration_pb2 import Duration
from google.protobuf.json_format import ParseDict
from enum import Enum
# API imports
from ...base import Action, Datatype
from ....dsl.compiler.registry import register_action
from ..native import run_unary, run_streaming, payload_from_action
# Protobuf imports
from ....protocol.services import compute_service_pb2
from ....protocol.services import compute_service_pb2_grpc
# Type imports
from ...datatypes.common import Response
from ...datatypes import compute as params
from ...datatypes import common as common

STUB: compute_service_pb2_grpc.ComputeStub = None

@register_action
class AddDatasinks(Action):
    """Add datasinks to consumer list.

    Takes a list of datasinks and adds them to the current consumer list.

    Attributes:
        datasinks (List[params.DatasinkInfo]): name of target datasinks
    """
    datasinks: List[params.DatasinkInfo]

    async def execute(self) -> Response:
        """Execute the AddDatasinks action.

        Returns:
            Response: response generated by the RPC call.
        """
        req = compute_service_pb2.AddDatasinksRequest()
        ParseDict(payload_from_action(self), req)
        return await run_unary(STUB.AddDatasinks, req)

@register_action
class SetDatasinks(Action):
    """Set the datasink consumer list.

    Takes a list of datasinks and replaces the current consumer list with them.

    Attributes:
        datasinks (List[params.DatasinkInfo]): name of target datasinks
    """
    datasinks: List[params.DatasinkInfo]

    async def execute(self) -> Response:
        """Execute the SetDatasinks action.

        Returns:
            Response: response generated by the RPC call.
        """
        req = compute_service_pb2.SetDatasinksRequest()
        ParseDict(payload_from_action(self), req)
        return await run_unary(STUB.SetDatasinks, req)

@register_action
class RemoveDatasinks(Action):
    """Remove datasinks from consumer list.

    Takes a list of datasinks and removes them from the current consumer list.

    Attributes:
        datasinks (List[params.DatasinkInfo]): name of target datasinks
    """
    datasinks: List[params.DatasinkInfo]

    async def execute(self) -> Response:
        """Execute the RemoveDatasinks action.

        Returns:
            Response: response generated by the RPC call.
        """
        req = compute_service_pb2.RemoveDatasinksRequest()
        ParseDict(payload_from_action(self), req)
        return await run_unary(STUB.RemoveDatasinks, req)

