"""Used to report messages to the Swarm Controller server.

Attributes:
    STUB (report_service_pb2_grpc.ReportStub): stub that is automatically set at runtime so that actions
        for this service can connect to gRPC
"""

###############################################################
# NOTE: THIS FILE IS GENERATED BY GENERATE_API.PY. DO NOT EDIT!
###############################################################
from typing import Optional, List
from google.protobuf.timestamp_pb2 import Timestamp
from google.protobuf.duration_pb2 import Duration
from google.protobuf.json_format import ParseDict
from enum import Enum
# API imports
from ...base import Action, Datatype
from ....dsl.compiler.registry import register_action
from ..native import run_unary, run_streaming, payload_from_action
# Protobuf imports
from ....protocol.services import report_service_pb2
from ....protocol.services import report_service_pb2_grpc
# Type imports
from ...datatypes.common import Response
from ...datatypes import report as params
from ...datatypes import common as common

STUB: report_service_pb2_grpc.ReportStub = None

@register_action
class SendReport(Action):
    """Send a report to the server.

    Attributes:
        report (params.ReportMessage): report data
    """
    report: params.ReportMessage

    async def execute(self) -> Response:
        """Execute the SendReport action.

        Returns:
            Response: response generated by the RPC call.
        """
        req = report_service_pb2.SendReportRequest()
        ParseDict(payload_from_action(self), req)
        return await run_unary(STUB.SendReport, req)

