#####################################################################
# NOTE: THIS FILE IS AUTOGENERATED BY GENERATE_TYPES.PY. DO NOT EDIT!
#####################################################################
from typing import Optional, List
from google.protobuf.timestamp_pb2 import Timestamp
from google.protobuf.duration_pb2 import Duration
from enum import Enum
# API imports
from ..base import Datatype
from ...dsl.compiler.registry import register_data 
# Type imports
from ..datatypes import common as common

@register_data
class BoundingBox(Datatype):
    """Bounding box associated with an object detection.

    Defines the upper left and lower right corners of a detected object
    in an image frame. Origin (0,0) is the top left corner of the input image.
    (image_height, image_width) is the bottom right corner.
    Also the class and confidence threshold associated with the box.    
    
    Attributes:
        y_min (float): minimum y offset percentage with respect to image size [0.0-1.0]    
        x_min (float): minimum x offset percentage with respect to image size [0.0-1.0]    
        y_max (float): maximum y offset percentage with respect to image size [0.0-1.0]    
        x_max (float): maximum x offset percentage with respect to image size [0.0-1.0]    
    """
    y_min: float
    x_min: float
    y_max: float
    x_max: float

@register_data
class HSV(Datatype):
    """HSV values generated by a color filter.

    Color filter represented by hue, saturation, and value Uses OpenCV ranges defined [here](https://opencv.org/blog/color-spaces-in-opencv/).    
    
    Attributes:
        h (int): hue range is [0,179]    
        s (int): saturation range is [0,255]    
        v (int): value range is [0,255]    
    """
    h: int
    s: int
    v: int

@register_data
class Detection(Datatype):
    """Object detection generated by a model.    
    
    Attributes:
        detection_id (int): can be multiple objects per frame    
        class_name (str): class name of detection    
        score (float): confidence score    
        bbox (BoundingBox): bounding box    
    """
    detection_id: int
    class_name: str
    score: float
    bbox: BoundingBox

@register_data
class DetectionResult(Datatype):
    """List of object detections.    
    
    Attributes:
        detections (List[Detection]): list of detections    
        frame_id (int): frame corresponding to these detections    
    """
    detections: List[Detection]
    frame_id: int

@register_data
class AvoidanceResult(Datatype):
    """Avoidance result generated by an avoidance model.    
    
    Attributes:
        actuation_vector (float): actuation vector towards safe area    
    """
    actuation_vector: float

@register_data
class SLAMResult(Datatype):
    """SLAM result generated by a SLAM model.    
    
    Attributes:
        relative_position (common.Position): relative position estimate relative to SLAM initialization    
        global_position (common.Location): global position estimate    
    """
    relative_position: common.Position
    global_position: common.Location

@register_data
class ComputeResult(Datatype):
    """Compute result generated by a compute server.    
    
    Attributes:
        timestamp (Timestamp): inference timestamp    
        engine_name (str): engine that generated the result    
        detection_result (DetectionResult): object detection    
        avoidance_result (AvoidanceResult): avoidance directive    
        slam_result (SLAMResult): SLAM position estimate    
        generic_result (str): JSON result    
    """
    timestamp: Timestamp
    engine_name: str
    detection_result: DetectionResult
    avoidance_result: AvoidanceResult
    slam_result: SLAMResult
    generic_result: str

@register_data
class FrameResult(Datatype):
    """Compute results generated by datasink modules    
    
    Attributes:
        type (str): result type(s)    
        frame_id (int): for correlation    
        result (List[ComputeResult]): list of generated results    
    """
    type: str
    frame_id: int
    result: List[ComputeResult]

