"""{{ comment }}

Attributes:
    STUB ({{ filename }}_pb2_grpc.{{ service_name }}Stub): stub that is automatically set at runtime so that actions
        for this service can connect to gRPC
"""

###############################################################
# NOTE: THIS FILE IS GENERATED BY GENERATE_API.PY. DO NOT EDIT!
###############################################################
from typing import Optional, List
from google.protobuf.timestamp_pb2 import Timestamp
from google.protobuf.duration_pb2 import Duration
from google.protobuf.json_format import ParseDict
from enum import Enum
# API imports
from ...base import Action, Datatype
from ....dsl.compiler.registry import register_action
from ..native import run_unary, run_streaming, payload_from_action
# Protobuf imports
from ....protocol.services import {{ filename }}_pb2
from ....protocol.services import {{ filename }}_pb2_grpc
# Type imports
from ...datatypes.common import Response
{% if imports | length > 0 %}
from ...datatypes import {{ param_file }} as params
{% for _import in imports %}
{{ _import }}
{% endfor %}
{% endif %}

STUB: {{ filename }}_pb2_grpc.{{ service_name }}Stub = None

{% for stub in stubs %}
@register_action
class {{ stub.name }}(Action):
    """{% if stub.comment != None %}{{ stub.comment | indent(width=4, first=False) }}{% else %}{{ stub.name }} Action.{% endif %}

    {% if stub.fields | length > 0 %}

    Attributes:
    {% for field in stub.fields %}
        {{ field.name }} ({{ field.type }}){% if field.comment != '' %}: {{ field.comment }}
        {% endif %}
    {% endfor %}
    {% endif %}
    """
    {% for field in stub.fields %}
    {{ field.name }}: {{ field.type }}
    {% endfor %}

    async def execute(self) -> Response:
        """Execute the {{ stub.name }} action.

        Returns:
            Response: response generated by the RPC call.
        """
        req = {{ filename }}_pb2.{{ stub.name }}Request()
        ParseDict(payload_from_action(self), req)
        {% if stub.streaming %}
        return await run_streaming(STUB.{{ stub.name }}, req)

        {% else %}
        return await run_unary(STUB.{{ stub.name }}, req)

        {% endif %}
{% endfor %}
