#####################################################################
# NOTE: THIS FILE IS AUTOGENERATED BY GENERATE_TYPES.PY. DO NOT EDIT!
#####################################################################
from typing import Optional, List
from google.protobuf.timestamp_pb2 import Timestamp
from google.protobuf.duration_pb2 import Duration
from enum import Enum
# API imports
from ..base import Datatype
from ...dsl.compiler.registry import register_data 

class ResponseStatus(int, Enum):
    """Response types for RPC functions.

        Values 0-2 (`OK`, `IN_PROGRESS`, `COMPLETED`) are specific to the SteelEagle protocol.
        They determine what phase an RPC call is in:
        - `OK` -> ack
        - `IN_PROGRESS` -> in progress
        - `COMPLETED` -> completed

        These intermediate phases are generally not exposed to user-facing code and are only used 
        for streaming methods. In contrast to normal gRPC procedure, a call is only considered complete
        on a response of `COMPLETED` instead of `OK`. If an error occurs, SteelEagle defers to gRPC error 
        codes, 3-18. More details on these codes can be found [here](https://grpc.github.io/grpc/core/md_doc_statuscodes.html).
        Note that the value of these codes is offset by 2 from their original form (e.g. `CANCELLED` = 3 vs = 1).
        Therefore, for error codes, the transformation from gRPC to SteelEagle response code is to add
        2 to the code. The only codes that differ from their gRPC meaning are codes 9 and 18.

    Attributes:
        OK (0): command acknowledged
        IN_PROGRESS (1): command in progress
        COMPLETED (2): command finished without error
        CANCELLED (3): the operation was cancelled, typically by the caller
        UNKNOWN (4): unknown error
        INVALID_ARGUMENT (5): the client specified an invalid argument
        DEADLINE_EXCEEDED (6): the deadline expired before the operation could complete
        NOT_FOUND (7): some requested entity was not found
        ALREADY_EXISTS (8): an entity the client attempted to create already exists
        PERMISSION_DENIED (9): the provided identity is not permitted to execute this operation by the current law (unique to SteelEagle)
        RESOURCE_EXHAUSTED (10): some resource has been exhausted
        FAILED_PRECONDITION (11): the operation was rejected because the system is not in a state required for the operation's execution
        ABORTED (12): the operation was aborted, typically due to a concurrency issue such as a sequencer check failure or transaction abort
        OUT_OF_RANGE (13): the operation was attempted past the valid range
        UNIMPLEMENTED (14): the operation is not implemented/supported by the service
        INTERNAL (15): an internal error occured while executing the operation
        UNAVAILABLE (16): the service is currently unavailable
        DATA_LOSS (17): unrecoverable data loss or corruption
        UNAUTHENTICATED (18): the client failed to provide an identity (unique to SteelEagle)
    """
    OK = 0 
    IN_PROGRESS = 1 
    COMPLETED = 2 
    CANCELLED = 3 
    UNKNOWN = 4 
    INVALID_ARGUMENT = 5 
    DEADLINE_EXCEEDED = 6 
    NOT_FOUND = 7 
    ALREADY_EXISTS = 8 
    PERMISSION_DENIED = 9 
    RESOURCE_EXHAUSTED = 10 
    FAILED_PRECONDITION = 11 
    ABORTED = 12 
    OUT_OF_RANGE = 13 
    UNIMPLEMENTED = 14 
    INTERNAL = 15 
    UNAVAILABLE = 16 
    DATA_LOSS = 17 
    UNAUTHENTICATED = 18 

@register_data
class Response(Datatype):
    """Global response message returned by all core services.    
    
    Attributes:
        status (ResponseStatus): response status    
        response_string (Optional[str]): detailed message on reason for response    
        timestamp (Timestamp): response timestamp    
    """
    status: ResponseStatus
    response_string: Optional[str]
    timestamp: Timestamp

@register_data
class Pose(Datatype):
    """Angular offsets or poses in 3 dimensions.    
    
    Attributes:
        pitch (Optional[float]): pitch [degrees]    
        roll (Optional[float]): roll [degrees]    
        yaw (Optional[float]): yaw [degrees]    
    """
    pitch: Optional[float]
    roll: Optional[float]
    yaw: Optional[float]

@register_data
class Velocity(Datatype):
    """Representation of velocity in 3-dimensions.    
    
    Attributes:
        x_vel (Optional[float]): forward/north velocity [meters/s]    
        y_vel (Optional[float]): right/east velocity [meters/s]    
        z_vel (Optional[float]): up velocity [meters/s]    
        angular_vel (Optional[float]): angular velocity [degrees/s]    
    """
    x_vel: Optional[float]
    y_vel: Optional[float]
    z_vel: Optional[float]
    angular_vel: Optional[float]

@register_data
class Position(Datatype):
    """Position offset relative to home or current location.    
    
    Attributes:
        x (Optional[float]): forward/north offset [meters]    
        y (Optional[float]): right/east offset [meters]    
        z (Optional[float]): up offset [meters]    
        angle (Optional[float]): angular offset [degrees]    
    """
    x: Optional[float]
    y: Optional[float]
    z: Optional[float]
    angle: Optional[float]

@register_data
class Location(Datatype):
    """Location in global coordinates.    
    
    Attributes:
        latitude (Optional[float]): global latitude [degrees]    
        longitude (Optional[float]): global longitude [degrees]    
        altitude (Optional[float]): altitude above MSL or takeoff [meters]    
        heading (Optional[float]): global heading [degrees]    
    """
    latitude: Optional[float]
    longitude: Optional[float]
    altitude: Optional[float]
    heading: Optional[float]

