# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2019-01-28 14:41
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tinymce.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text=b'Used to reference notification, shown in title for some looks', max_length=250, unique=True)),
                ('message', tinymce.models.HTMLField(help_text=b'Full message as shown to user')),
                ('expires', models.DateTimeField(blank=True, default=None, help_text=b'Notification will not be shown after this time.', null=True)),
                ('attachment', models.FileField(blank=True, default=None, null=True, upload_to=b'')),
                ('active_from', models.DateTimeField(blank=True, default=None, null=True)),
                ('needs_approval', models.BooleanField(default=False, help_text=b'Set this field if approval is necessary, see snooze time.')),
                ('snooze_lock', models.IntegerField(blank=True, default=None, null=True)),
                ('snooze_time', models.IntegerField(blank=True, default=None, help_text=b'If user dismisses message (when relevant), message is shown again after this many days.', null=True)),
                ('send_email', models.BooleanField(default=False)),
                ('look', models.CharField(choices=[(b'SIGN_COMPANY', b'SIGN_COMPANY'), (b'SIMPLE_OK', b'SIMPLE_OK')], default=b'SIMPLE_OK', help_text=b'This controls the appearance of the notification.', max_length=50)),
                ('groups', models.ManyToManyField(blank=True, default=None, to='auth.Group')),
            ],
        ),
        migrations.CreateModel(
            name='UserNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('seen', models.BooleanField(default=False)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('next_display', models.DateTimeField(blank=True, default=None, null=True)),
                ('answer', models.NullBooleanField(default=None)),
                ('answer_string', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.Notification')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='notification',
            name='recipients',
            field=models.ManyToManyField(blank=True, default=None, through='notifications.UserNotification', to=settings.AUTH_USER_MODEL),
        ),
    ]
