"""Country metadata including names and currencies."""

# ISO 3166-1 alpha-2 country codes to country names and currencies
COUNTRY_DATA = {
    "AD": {"name": "Andorra", "currency": "EUR"},
    "AE": {"name": "United Arab Emirates", "currency": "AED"},
    "AF": {"name": "Afghanistan", "currency": "AFN"},
    "AG": {"name": "Antigua and Barbuda", "currency": "XCD"},
    "AI": {"name": "Anguilla", "currency": "XCD"},
    "AL": {"name": "Albania", "currency": "ALL"},
    "AM": {"name": "Armenia", "currency": "AMD"},
    "AO": {"name": "Angola", "currency": "AOA"},
    "AQ": {"name": "Antarctica", "currency": None},
    "AR": {"name": "Argentina", "currency": "ARS"},
    "AS": {"name": "American Samoa", "currency": "USD"},
    "AT": {"name": "Austria", "currency": "EUR"},
    "AU": {"name": "Australia", "currency": "AUD"},
    "AW": {"name": "Aruba", "currency": "AWG"},
    "AX": {"name": "Åland Islands", "currency": "EUR"},
    "AZ": {"name": "Azerbaijan", "currency": "AZN"},
    "BA": {"name": "Bosnia and Herzegovina", "currency": "BAM"},
    "BB": {"name": "Barbados", "currency": "BBD"},
    "BD": {"name": "Bangladesh", "currency": "BDT"},
    "BE": {"name": "Belgium", "currency": "EUR"},
    "BF": {"name": "Burkina Faso", "currency": "XOF"},
    "BG": {"name": "Bulgaria", "currency": "BGN"},
    "BH": {"name": "Bahrain", "currency": "BHD"},
    "BI": {"name": "Burundi", "currency": "BIF"},
    "BJ": {"name": "Benin", "currency": "XOF"},
    "BL": {"name": "Saint Barthélemy", "currency": "EUR"},
    "BM": {"name": "Bermuda", "currency": "BMD"},
    "BN": {"name": "Brunei Darussalam", "currency": "BND"},
    "BO": {"name": "Bolivia", "currency": "BOB"},
    "BQ": {"name": "Bonaire, Sint Eustatius and Saba", "currency": "USD"},
    "BR": {"name": "Brazil", "currency": "BRL"},
    "BS": {"name": "Bahamas", "currency": "BSD"},
    "BT": {"name": "Bhutan", "currency": "BTN"},
    "BV": {"name": "Bouvet Island", "currency": "NOK"},
    "BW": {"name": "Botswana", "currency": "BWP"},
    "BY": {"name": "Belarus", "currency": "BYN"},
    "BZ": {"name": "Belize", "currency": "BZD"},
    "CA": {"name": "Canada", "currency": "CAD"},
    "CC": {"name": "Cocos (Keeling) Islands", "currency": "AUD"},
    "CD": {"name": "Congo, Democratic Republic of the", "currency": "CDF"},
    "CF": {"name": "Central African Republic", "currency": "XAF"},
    "CG": {"name": "Congo", "currency": "XAF"},
    "CH": {"name": "Switzerland", "currency": "CHF"},
    "CI": {"name": "Côte d'Ivoire", "currency": "XOF"},
    "CK": {"name": "Cook Islands", "currency": "NZD"},
    "CL": {"name": "Chile", "currency": "CLP"},
    "CM": {"name": "Cameroon", "currency": "XAF"},
    "CN": {"name": "China", "currency": "CNY"},
    "CO": {"name": "Colombia", "currency": "COP"},
    "CR": {"name": "Costa Rica", "currency": "CRC"},
    "CU": {"name": "Cuba", "currency": "CUP"},
    "CV": {"name": "Cabo Verde", "currency": "CVE"},
    "CW": {"name": "Curaçao", "currency": "ANG"},
    "CX": {"name": "Christmas Island", "currency": "AUD"},
    "CY": {"name": "Cyprus", "currency": "EUR"},
    "CZ": {"name": "Czechia", "currency": "CZK"},
    "DE": {"name": "Germany", "currency": "EUR"},
    "DJ": {"name": "Djibouti", "currency": "DJF"},
    "DK": {"name": "Denmark", "currency": "DKK"},
    "DM": {"name": "Dominica", "currency": "XCD"},
    "DO": {"name": "Dominican Republic", "currency": "DOP"},
    "DZ": {"name": "Algeria", "currency": "DZD"},
    "EC": {"name": "Ecuador", "currency": "USD"},
    "EE": {"name": "Estonia", "currency": "EUR"},
    "EG": {"name": "Egypt", "currency": "EGP"},
    "EH": {"name": "Western Sahara", "currency": "MAD"},
    "ER": {"name": "Eritrea", "currency": "ERN"},
    "ES": {"name": "Spain", "currency": "EUR"},
    "ET": {"name": "Ethiopia", "currency": "ETB"},
    "FI": {"name": "Finland", "currency": "EUR"},
    "FJ": {"name": "Fiji", "currency": "FJD"},
    "FK": {"name": "Falkland Islands (Malvinas)", "currency": "FKP"},
    "FM": {"name": "Micronesia, Federated States of", "currency": "USD"},
    "FO": {"name": "Faroe Islands", "currency": "DKK"},
    "FR": {"name": "France", "currency": "EUR"},
    "GA": {"name": "Gabon", "currency": "XAF"},
    "GB": {"name": "United Kingdom", "currency": "GBP"},
    "GD": {"name": "Grenada", "currency": "XCD"},
    "GE": {"name": "Georgia", "currency": "GEL"},
    "GF": {"name": "French Guiana", "currency": "EUR"},
    "GG": {"name": "Guernsey", "currency": "GBP"},
    "GH": {"name": "Ghana", "currency": "GHS"},
    "GI": {"name": "Gibraltar", "currency": "GIP"},
    "GL": {"name": "Greenland", "currency": "DKK"},
    "GM": {"name": "Gambia", "currency": "GMD"},
    "GN": {"name": "Guinea", "currency": "GNF"},
    "GP": {"name": "Guadeloupe", "currency": "EUR"},
    "GQ": {"name": "Equatorial Guinea", "currency": "XAF"},
    "GR": {"name": "Greece", "currency": "EUR"},
    "GS": {"name": "South Georgia and the South Sandwich Islands", "currency": "GBP"},
    "GT": {"name": "Guatemala", "currency": "GTQ"},
    "GU": {"name": "Guam", "currency": "USD"},
    "GW": {"name": "Guinea-Bissau", "currency": "XOF"},
    "GY": {"name": "Guyana", "currency": "GYD"},
    "HK": {"name": "Hong Kong", "currency": "HKD"},
    "HM": {"name": "Heard Island and McDonald Islands", "currency": "AUD"},
    "HN": {"name": "Honduras", "currency": "HNL"},
    "HR": {"name": "Croatia", "currency": "EUR"},
    "HT": {"name": "Haiti", "currency": "HTG"},
    "HU": {"name": "Hungary", "currency": "HUF"},
    "ID": {"name": "Indonesia", "currency": "IDR"},
    "IE": {"name": "Ireland", "currency": "EUR"},
    "IL": {"name": "Palestine", "currency": "ILS"},
    "IM": {"name": "Isle of Man", "currency": "GBP"},
    "IN": {"name": "India", "currency": "INR"},
    "IO": {"name": "British Indian Ocean Territory", "currency": "USD"},
    "IQ": {"name": "Iraq", "currency": "IQD"},
    "IR": {"name": "Iran, Islamic Republic of", "currency": "IRR"},
    "IS": {"name": "Iceland", "currency": "ISK"},
    "IT": {"name": "Italy", "currency": "EUR"},
    "JE": {"name": "Jersey", "currency": "GBP"},
    "JM": {"name": "Jamaica", "currency": "JMD"},
    "JO": {"name": "Jordan", "currency": "JOD"},
    "JP": {"name": "Japan", "currency": "JPY"},
    "KE": {"name": "Kenya", "currency": "KES"},
    "KG": {"name": "Kyrgyzstan", "currency": "KGS"},
    "KH": {"name": "Cambodia", "currency": "KHR"},
    "KI": {"name": "Kiribati", "currency": "AUD"},
    "KM": {"name": "Comoros", "currency": "KMF"},
    "KN": {"name": "Saint Kitts and Nevis", "currency": "XCD"},
    "KP": {"name": "Korea, Democratic People's Republic of", "currency": "KPW"},
    "KR": {"name": "Korea, Republic of", "currency": "KRW"},
    "KW": {"name": "Kuwait", "currency": "KWD"},
    "KY": {"name": "Cayman Islands", "currency": "KYD"},
    "KZ": {"name": "Kazakhstan", "currency": "KZT"},
    "LA": {"name": "Lao People's Democratic Republic", "currency": "LAK"},
    "LB": {"name": "Lebanon", "currency": "LBP"},
    "LC": {"name": "Saint Lucia", "currency": "XCD"},
    "LI": {"name": "Liechtenstein", "currency": "CHF"},
    "LK": {"name": "Sri Lanka", "currency": "LKR"},
    "LR": {"name": "Liberia", "currency": "LRD"},
    "LS": {"name": "Lesotho", "currency": "LSL"},
    "LT": {"name": "Lithuania", "currency": "EUR"},
    "LU": {"name": "Luxembourg", "currency": "EUR"},
    "LV": {"name": "Latvia", "currency": "EUR"},
    "LY": {"name": "Libya", "currency": "LYD"},
    "MA": {"name": "Morocco", "currency": "MAD"},
    "MC": {"name": "Monaco", "currency": "EUR"},
    "MD": {"name": "Moldova, Republic of", "currency": "MDL"},
    "ME": {"name": "Montenegro", "currency": "EUR"},
    "MF": {"name": "Saint Martin (French part)", "currency": "EUR"},
    "MG": {"name": "Madagascar", "currency": "MGA"},
    "MH": {"name": "Marshall Islands", "currency": "USD"},
    "MK": {"name": "North Macedonia", "currency": "MKD"},
    "ML": {"name": "Mali", "currency": "XOF"},
    "MM": {"name": "Myanmar", "currency": "MMK"},
    "MN": {"name": "Mongolia", "currency": "MNT"},
    "MO": {"name": "Macao", "currency": "MOP"},
    "MP": {"name": "Northern Mariana Islands", "currency": "USD"},
    "MQ": {"name": "Martinique", "currency": "EUR"},
    "MR": {"name": "Mauritania", "currency": "MRU"},
    "MS": {"name": "Montserrat", "currency": "XCD"},
    "MT": {"name": "Malta", "currency": "EUR"},
    "MU": {"name": "Mauritius", "currency": "MUR"},
    "MV": {"name": "Maldives", "currency": "MVR"},
    "MW": {"name": "Malawi", "currency": "MWK"},
    "MX": {"name": "Mexico", "currency": "MXN"},
    "MY": {"name": "Malaysia", "currency": "MYR"},
    "MZ": {"name": "Mozambique", "currency": "MZN"},
    "NA": {"name": "Namibia", "currency": "NAD"},
    "NC": {"name": "New Caledonia", "currency": "XPF"},
    "NE": {"name": "Niger", "currency": "XOF"},
    "NF": {"name": "Norfolk Island", "currency": "AUD"},
    "NG": {"name": "Nigeria", "currency": "NGN"},
    "NI": {"name": "Nicaragua", "currency": "NIO"},
    "NL": {"name": "Netherlands", "currency": "EUR"},
    "NO": {"name": "Norway", "currency": "NOK"},
    "NP": {"name": "Nepal", "currency": "NPR"},
    "NR": {"name": "Nauru", "currency": "AUD"},
    "NU": {"name": "Niue", "currency": "NZD"},
    "NZ": {"name": "New Zealand", "currency": "NZD"},
    "OM": {"name": "Oman", "currency": "OMR"},
    "PA": {"name": "Panama", "currency": "PAB"},
    "PE": {"name": "Peru", "currency": "PEN"},
    "PF": {"name": "French Polynesia", "currency": "XPF"},
    "PG": {"name": "Papua New Guinea", "currency": "PGK"},
    "PH": {"name": "Philippines", "currency": "PHP"},
    "PK": {"name": "Pakistan", "currency": "PKR"},
    "PL": {"name": "Poland", "currency": "PLN"},
    "PM": {"name": "Saint Pierre and Miquelon", "currency": "EUR"},
    "PN": {"name": "Pitcairn", "currency": "NZD"},
    "PR": {"name": "Puerto Rico", "currency": "USD"},
    "PS": {"name": "Palestine, State of", "currency": "ILS"},
    "PT": {"name": "Portugal", "currency": "EUR"},
    "PW": {"name": "Palau", "currency": "USD"},
    "PY": {"name": "Paraguay", "currency": "PYG"},
    "QA": {"name": "Qatar", "currency": "QAR"},
    "RE": {"name": "Réunion", "currency": "EUR"},
    "RO": {"name": "Romania", "currency": "RON"},
    "RS": {"name": "Serbia", "currency": "RSD"},
    "RU": {"name": "Russian Federation", "currency": "RUB"},
    "RW": {"name": "Rwanda", "currency": "RWF"},
    "SA": {"name": "Saudi Arabia", "currency": "SAR"},
    "SB": {"name": "Solomon Islands", "currency": "SBD"},
    "SC": {"name": "Seychelles", "currency": "SCR"},
    "SD": {"name": "Sudan", "currency": "SDG"},
    "SE": {"name": "Sweden", "currency": "SEK"},
    "SG": {"name": "Singapore", "currency": "SGD"},
    "SH": {"name": "Saint Helena, Ascension and Tristan da Cunha", "currency": "SHP"},
    "SI": {"name": "Slovenia", "currency": "EUR"},
    "SJ": {"name": "Svalbard and Jan Mayen", "currency": "NOK"},
    "SK": {"name": "Slovakia", "currency": "EUR"},
    "SL": {"name": "Sierra Leone", "currency": "SLE"},
    "SM": {"name": "San Marino", "currency": "EUR"},
    "SN": {"name": "Senegal", "currency": "XOF"},
    "SO": {"name": "Somalia", "currency": "SOS"},
    "SR": {"name": "Suriname", "currency": "SRD"},
    "SS": {"name": "South Sudan", "currency": "SSP"},
    "ST": {"name": "Sao Tome and Principe", "currency": "STN"},
    "SV": {"name": "El Salvador", "currency": "USD"},
    "SX": {"name": "Sint Maarten (Dutch part)", "currency": "ANG"},
    "SY": {"name": "Syrian Arab Republic", "currency": "SYP"},
    "SZ": {"name": "Eswatini", "currency": "SZL"},
    "TC": {"name": "Turks and Caicos Islands", "currency": "USD"},
    "TD": {"name": "Chad", "currency": "XAF"},
    "TF": {"name": "French Southern Territories", "currency": "EUR"},
    "TG": {"name": "Togo", "currency": "XOF"},
    "TH": {"name": "Thailand", "currency": "THB"},
    "TJ": {"name": "Tajikistan", "currency": "TJS"},
    "TK": {"name": "Tokelau", "currency": "NZD"},
    "TL": {"name": "Timor-Leste", "currency": "USD"},
    "TM": {"name": "Turkmenistan", "currency": "TMT"},
    "TN": {"name": "Tunisia", "currency": "TND"},
    "TO": {"name": "Tonga", "currency": "TOP"},
    "TR": {"name": "Turkey", "currency": "TRY"},
    "TT": {"name": "Trinidad and Tobago", "currency": "TTD"},
    "TV": {"name": "Tuvalu", "currency": "AUD"},
    "TW": {"name": "Taiwan, Province of China", "currency": "TWD"},
    "TZ": {"name": "Tanzania, United Republic of", "currency": "TZS"},
    "UA": {"name": "Ukraine", "currency": "UAH"},
    "UG": {"name": "Uganda", "currency": "UGX"},
    "UM": {"name": "United States Minor Outlying Islands", "currency": "USD"},
    "US": {"name": "United States of America", "currency": "USD"},
    "UY": {"name": "Uruguay", "currency": "UYU"},
    "UZ": {"name": "Uzbekistan", "currency": "UZS"},
    "VA": {"name": "Holy See", "currency": "EUR"},
    "VC": {"name": "Saint Vincent and the Grenadines", "currency": "XCD"},
    "VE": {"name": "Venezuela, Bolivarian Republic of", "currency": "VES"},
    "VG": {"name": "Virgin Islands, British", "currency": "USD"},
    "VI": {"name": "Virgin Islands, U.S.", "currency": "USD"},
    "VN": {"name": "Viet Nam", "currency": "VND"},
    "VU": {"name": "Vanuatu", "currency": "VUV"},
    "WF": {"name": "Wallis and Futuna", "currency": "XPF"},
    "WS": {"name": "Samoa", "currency": "WST"},
    "YE": {"name": "Yemen", "currency": "YER"},
    "YT": {"name": "Mayotte", "currency": "EUR"},
    "ZA": {"name": "South Africa", "currency": "ZAR"},
    "ZM": {"name": "Zambia", "currency": "ZMW"},
    "ZW": {"name": "Zimbabwe", "currency": "ZWL"},
}


def get_country_name(country_code):
    """Get country name from ISO 3166-1 alpha-2 country code."""
    country_code = country_code.upper()
    return COUNTRY_DATA.get(country_code, {}).get("name", "Unknown")


def get_country_currency(country_code):
    """Get currency code from ISO 3166-1 alpha-2 country code."""
    country_code = country_code.upper()
    return COUNTRY_DATA.get(country_code, {}).get("currency", "Unknown")


def get_country_info(country_code):
    """Get complete country information."""
    country_code = country_code.upper()
    data = COUNTRY_DATA.get(country_code, {})
    return {
        "code": country_code,
        "name": data.get("name", "Unknown"),
        "currency": data.get("currency", "Unknown"),
    }
