"""
enums
"""

from enum import StrEnum


class View(StrEnum):
    GAME = "game"
    DRAFT = "draft"
    CARD = "card"


class ColType(StrEnum):
    FILTER_ONLY = "filter_only"
    GROUP_BY = "group_by"
    PICK_SUM = "pick_sum"
    GAME_SUM = "game_sum"
    NAME_SUM = "name_sum"
    AGG = "agg"
    CARD_ATTR = "card_attr"


class ColName(StrEnum):
    """
    A list of all available columns, including built-in extensions.

    "Name-mapped" columns like "deck_<card name>" are identified by the prefix only.
    Those columns can be referenced simply as e.g. "deck" in formulas for the post-agg stage.

    The definitions of the columns and how they may be used is defined in `column_defs`
    """

    # shared
    NAME = "name"  # special column for card name index
    EXPANSION = "expansion"
    EVENT_TYPE = "event_type"
    DRAFT_ID = "draft_id"
    DRAFT_TIME = "draft_time"  # modified, cast to time
    DRAFT_DATE = "draft_date"
    FORMAT_DAY = "format_day"
    DRAFT_DAY_OF_WEEK = "draft_day_of_week"
    DRAFT_HOUR = "draft_hour"
    DRAFT_WEEK = "draft_week"
    FORMAT_WEEK = "format_week"
    RANK = "rank"
    USER_N_GAMES_BUCKET = "user_n_games_bucket"
    USER_GAME_WIN_RATE_BUCKET = "user_game_win_rate_bucket"
    PLAYER_COHORT = "player_cohort"
    # draft
    EVENT_MATCH_WINS = "event_match_wins"
    EVENT_MATCH_WINS_SUM = "event_match_wins_sum"
    EVENT_MATCH_LOSSES = "event_match_losses"
    EVENT_MATCH_LOSSES_SUM = "event_match_losses_sum"
    EVENT_MATCHES = "event_matches"
    EVENT_MATCHES_SUM = "event_matches_sum"
    IS_TROPHY = "is_trophy"
    IS_TROPHY_SUM = "is_trophy_sum"
    PACK_NUMBER = "pack_number"
    PACK_NUM = "pack_num"  # pack_number plus 1
    PICK_NUMBER = "pick_number"
    PICK_NUM = "pick_num"  # pick_number plus 1
    TAKEN_AT = "taken_at"
    NUM_TAKEN = "num_taken"
    NUM_DRAFTS = "num_drafts"
    PICK = "pick"
    PICK_MAINDECK_RATE = "pick_maindeck_rate"
    PICK_SIDEBOARD_IN_RATE = "pick_sideboard_in_rate"
    PACK_CARD = "pack_card"
    LAST_SEEN = "last_seen"
    NUM_SEEN = "num_seen"
    POOL = "pool"
    # game
    GAME_TIME = "game_time"
    GAME_DATE = "game_date"
    GAME_DAY_OF_WEEK = "game_day_of_week"
    GAME_HOUR = "game_hour"
    GAME_WEEK = "game_week"
    BUILD_INDEX = "build_index"
    MATCH_NUMBER = "match_number"
    GAME_NUMBER = "game_number"
    NUM_EVENTS = "num_events"
    NUM_MATCHES = "num_matches"
    NUM_GAMES = "num_games"
    OPP_RANK = "opp_rank"  # not populated for recent sets
    MAIN_COLORS = "main_colors"
    NUM_COLORS = "num_colors"
    SPLASH_COLORS = "splash_colors"
    HAS_SPLASH = "has_splash"
    ON_PLAY = "on_play"
    NUM_ON_PLAY = "num_on_play"
    NUM_MULLIGANS = "num_mulligans"
    NUM_MULLIGANS_SUM = "num_mulligans_sum"
    OPP_NUM_MULLIGANS = "opp_num_mulligans"
    OPP_NUM_MULLIGANS_SUM = "opp_num_mulligans_sum"
    OPP_COLORS = "opp_colors"
    NUM_TURNS = "num_turns"
    NUM_TURNS_SUM = "num_turns_sum"
    WON = "won"
    NUM_WON = "num_won"
    OPENING_HAND = "opening_hand"
    WON_OPENING_HAND = "won_opening_hand"
    DRAWN = "drawn"
    WON_DRAWN = "won_drawn"
    TUTORED = "tutored"
    WON_TUTORED = "won_tutored"
    DECK = "deck"
    WON_DECK = "won_deck"
    SIDEBOARD = "sideboard"
    WON_SIDEBOARD = "won_sideboard"
    NUM_GNS = "num_gns"
    WON_NUM_GNS = "won_num_gns"
    # card
    SET_CODE = "set_code"
    COLOR = "color"
    RARITY = "rarity"
    COLOR_IDENTITY = "color_identity"
    CARD_TYPE = "card_type"
    SUBTYPE = "subtype"
    MANA_VALUE = "mana_value"
    DECK_MANA_VALUE = "deck_mana_value"
    DECK_LANDS = "deck_lands"
    DECK_SPELLS = "deck_spells"
    MANA_COST = "mana_cost"
    POWER = "power"
    TOUGHNESS = "toughness"
    IS_BONUS_SHEET = "is_bonus_sheet"
    IS_DFC = "is_dfc"
    ORACLE_TEXT = "oracle_text"
    CARD_JSON = "card_json"
    # agg extensions
    PICKED_MATCH_WR = "picked_match_wr"
    TROPHY_RATE = "trophy_rate"
    GAME_WR = "game_wr"
    ALSA = "alsa"
    ATA = "ata"
    NUM_GP = "num_gp"
    PCT_GP = "pct_gp"
    GP_WR = "gp_wr"
    NUM_OH = "num_oh"
    OH_WR = "oh_wr"
    NUM_GIH = "num_gih"
    NUM_GIH_WON = "num_gih_won"
    GIH_WR = "gih_wr"
    GNS_WR = "gns_wr"
    IWD = "iwd"
    NUM_IN_POOL = "num_in_pool"
    NUM_IN_POOL_TOTAL = "num_in_pool_total"
    IN_POOL_WR = "in_pool_wr"
    DECK_TOTAL = "deck_total"
    WON_DECK_TOTAL = "won_deck_total"
    GP_WR_MEAN = "gp_wr_mean"
    GP_WR_EXCESS = "gp_wr_excess"
    GP_WR_VAR = "gp_wr_var"
    GP_WR_STDEV = "gp_wr_stdev"
    GP_WR_Z = "gp_wr_z"
    GIH_TOTAL = "gih_total"
    WON_GIH_TOTAL = "won_gih_total"
    GIH_WR_MEAN = "gih_wr_mean"
    GIH_WR_EXCESS = "gih_wr_excess"
    GIH_WR_VAR = "gih_wr_var"
    GIH_WR_STDEV = "gh_wr_stdev"
    GIH_WR_Z = "gih_wr_z"
    DECK_MANA_VALUE_AVG = "deck_mana_value_avg"
    DECK_LANDS_AVG = "deck_lands_avg"
    DECK_SPELLS_AVG = "deck_spells_avg"
