import enum


# Source: https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes
class CountryEnum(str, enum.Enum):
    AF = "Afghanistan"
    AX = "land Islands"
    AL = "Albania"
    DZ = "Algeria"
    AS = "American Samoa"
    AD = "AndorrA"
    AO = "Angola"
    AI = "Anguilla"
    AQ = "Antarctica"
    AG = "Antigua and Barbuda"
    AR = "Argentina"
    AM = "Armenia"
    AW = "Aruba"
    AU = "Australia"
    AT = "Austria"
    AZ = "Azerbaijan"
    BS = "Bahamas"
    BH = "Bahrain"
    BD = "Bangladesh"
    BB = "Barbados"
    BY = "Belarus"
    BE = "Belgium"
    BZ = "Belize"
    BJ = "Benin"
    BM = "Bermuda"
    BT = "Bhutan"
    BO = "Bolivia"
    BA = "Bosnia and Herzegovina"
    BW = "Botswana"
    BV = "Bouvet Island"
    BR = "Brazil"
    IO = "British Indian Ocean Territory"
    BN = "Brunei Darussalam"
    BG = "Bulgaria"
    BF = "Burkina Faso"
    BI = "Burundi"
    KH = "Cambodia"
    CM = "Cameroon"
    CA = "Canada"
    CV = "Cape Verde"
    KY = "Cayman Islands"
    CF = "Central African Republic"
    TD = "Chad"
    CL = "Chile"
    CN = "China"
    CX = "Christmas Island"
    CC = "Cocos (Keeling) Islands"
    CO = "Colombia"
    KM = "Comoros"
    CG = "Congo"
    CD = "Congo, The Democratic Republic of the"
    CK = "Cook Islands"
    CR = "Costa Rica"
    CI = 'Cote D"Ivoire'
    HR = "Croatia"
    CU = "Cuba"
    CY = "Cyprus"
    CZ = "Czech Republic"
    DK = "Denmark"
    DJ = "Djibouti"
    DM = "Dominica"
    DO = "Dominican Republic"
    EC = "Ecuador"
    EG = "Egypt"
    SV = "El Salvador"
    GQ = "Equatorial Guinea"
    ER = "Eritrea"
    EE = "Estonia"
    ET = "Ethiopia"
    FK = "Falkland Islands (Malvinas)"
    FO = "Faroe Islands"
    FJ = "Fiji"
    FI = "Finland"
    FR = "France"
    GF = "French Guiana"
    PF = "French Polynesia"
    TF = "French Southern Territories"
    GA = "Gabon"
    GM = "Gambia"
    GE = "Georgia"
    DE = "Germany"
    GH = "Ghana"
    GI = "Gibraltar"
    GR = "Greece"
    GL = "Greenland"
    GD = "Grenada"
    GP = "Guadeloupe"
    GU = "Guam"
    GT = "Guatemala"
    GG = "Guernsey"
    GN = "Guinea"
    GW = "Guinea-Bissau"
    GY = "Guyana"
    HT = "Haiti"
    HM = "Heard Island and Mcdonald Islands"
    VA = "Holy See (Vatican City State)"
    HN = "Honduras"
    HK = "Hong Kong"
    HU = "Hungary"
    IS = "Iceland"
    IN = "India"
    ID = "Indonesia"
    IR = "Iran, Islamic Republic Of"
    IQ = "Iraq"
    IE = "Ireland"
    IM = "Isle of Man"
    IL = "Israel"
    IT = "Italy"
    JM = "Jamaica"
    JP = "Japan"
    JE = "Jersey"
    JO = "Jordan"
    KZ = "Kazakhstan"
    KE = "Kenya"
    KI = "Kiribati"
    KP = 'Korea, Democratic People"S Republic of'
    KR = "Korea, Republic of"
    KW = "Kuwait"
    KG = "Kyrgyzstan"
    LA = 'Lao People"S Democratic Republic'
    LV = "Latvia"
    LB = "Lebanon"
    LS = "Lesotho"
    LR = "Liberia"
    LY = "Libyan Arab Jamahiriya"
    LI = "Liechtenstein"
    LT = "Lithuania"
    LU = "Luxembourg"
    MO = "Macao"
    MK = "Macedonia, The Former Yugoslav Republic of"
    MG = "Madagascar"
    MW = "Malawi"
    MY = "Malaysia"
    MV = "Maldives"
    ML = "Mali"
    MT = "Malta"
    MH = "Marshall Islands"
    MQ = "Martinique"
    MR = "Mauritania"
    MU = "Mauritius"
    YT = "Mayotte"
    MX = "Mexico"
    FM = "Micronesia, Federated States of"
    MD = "Moldova, Republic of"
    MC = "Monaco"
    MN = "Mongolia"
    ME = "Montenegro"
    MS = "Montserrat"
    MA = "Morocco"
    MZ = "Mozambique"
    MM = "Myanmar"
    NA = "Namibia"
    NR = "Nauru"
    NP = "Nepal"
    NL = "Netherlands"
    AN = "Netherlands Antilles"
    NC = "New Caledonia"
    NZ = "New Zealand"
    NI = "Nicaragua"
    NE = "Niger"
    NG = "Nigeria"
    NU = "Niue"
    NF = "Norfolk Island"
    MP = "Northern Mariana Islands"
    NO = "Norway"
    OM = "Oman"
    PK = "Pakistan"
    PW = "Palau"
    PS = "Palestinian Territory, Occupied"
    PA = "Panama"
    PG = "Papua New Guinea"
    PY = "Paraguay"
    PE = "Peru"
    PH = "Philippines"
    PN = "Pitcairn"
    PL = "Poland"
    PT = "Portugal"
    PR = "Puerto Rico"
    QA = "Qatar"
    RE = "Reunion"
    RO = "Romania"
    RU = "Russian Federation"
    RW = "RWANDA"
    SH = "Saint Helena"
    KN = "Saint Kitts and Nevis"
    LC = "Saint Lucia"
    PM = "Saint Pierre and Miquelon"
    VC = "Saint Vincent and the Grenadines"
    WS = "Samoa"
    SM = "San Marino"
    ST = "Sao Tome and Principe"
    SA = "Saudi Arabia"
    SN = "Senegal"
    RS = "Serbia"
    SC = "Seychelles"
    SL = "Sierra Leone"
    SG = "Singapore"
    SK = "Slovakia"
    SI = "Slovenia"
    SB = "Solomon Islands"
    SO = "Somalia"
    ZA = "South Africa"
    GS = "South Georgia and the South Sandwich Islands"
    ES = "Spain"
    LK = "Sri Lanka"
    SD = "Sudan"
    SR = "Suriname"
    SJ = "Svalbard and Jan Mayen"
    SZ = "Swaziland"
    SE = "Sweden"
    CH = "Switzerland"
    SY = "Syrian Arab Republic"
    TW = "Taiwan, Province of China"
    TJ = "Tajikistan"
    TZ = "Tanzania, United Republic of"
    TH = "Thailand"
    TL = "Timor-Leste"
    TG = "Togo"
    TK = "Tokelau"
    TO = "Tonga"
    TT = "Trinidad and Tobago"
    TN = "Tunisia"
    TR = "Turkey"
    TM = "Turkmenistan"
    TC = "Turks and Caicos Islands"
    TV = "Tuvalu"
    UG = "Uganda"
    UA = "Ukraine"
    AE = "United Arab Emirates"
    GB = "United Kingdom"
    US = "United States"
    UM = "United States Minor Outlying Islands"
    UY = "Uruguay"
    UZ = "Uzbekistan"
    VU = "Vanuatu"
    VE = "Venezuela"
    VN = "Viet Nam"
    VG = "Virgin Islands, British"
    VI = "Virgin Islands, U.S."
    WF = "Wallis and Futuna"
    EH = "Western Sahara"
    YE = "Yemen"
    ZM = "Zambia"
    ZW = "Zimbabwe"


# :: https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes
class LanguageEnum(str, enum.Enum):
    AA = "Afar"
    AB = "Abkhazian"
    AF = "Afrikaans"
    AK = "Akan"
    AM = "Amharic"
    AN = "Aragonese"
    AR = "Arabic"
    AS = "Assamese"
    AV = "Avar"
    AY = "Aymara"
    AZ = "Azerbaijani"
    BA = "Bashkir"
    BE = "Belarusian"
    BG = "Bulgarian"
    BH = "Bihari"
    BI = "Bislama"
    BM = "Bambara"
    BN = "Bengali"
    BO = "Tibetan"
    BR = "Breton"
    BS = "Bosnian"
    CA = "Catalan"
    CE = "Chechen"
    CH = "Chamorro"
    CO = "Corsican"
    CR = "Cree"
    CS = "Czech"
    CU = "Old Church Slavonic / Old Bulgarian"
    CV = "Chuvash"
    CY = "Welsh"
    DA = "Danish"
    DE = "Deutsch"
    DV = "Divehi"
    DZ = "Dzongkha"
    EE = "Ewe"
    EL = "Greek"
    EN = "English"
    EO = "Esperanto"
    ES = "Spanish"
    ET = "Estonian"
    EU = "Basque"
    FA = "Persian"
    FF = "Peul"
    FI = "Finnish"
    FJ = "Fijian"
    FO = "Faroese"
    FR = "French"
    FY = "West Frisian"
    GA = "Irish"
    GD = "Scottish Gaelic"
    GL = "Galician"
    GN = "Guarani"
    GU = "Gujarati"
    GV = "Manx"
    HA = "Hausa"
    HE = "Hebrew"
    HI = "Hindi"
    HO = "Hiri Motu"
    HR = "Croatian"
    HT = "Haitian"
    HU = "Hungarian"
    HY = "Armenian"
    HZ = "Herero"
    IA = "Interlingua"
    ID = "Indonesian"
    IE = "Interlingue"
    IG = "Igbo"
    II = "Sichuan Yi"
    IK = "Inupiak"
    IO = "Ido"
    IS = "Icelandic"
    IT = "Italian"
    IU = "Inuktitut"
    JA = "Japanese"
    JV = "Javanese"
    KA = "Georgian"
    KG = "Kongo"
    KI = "Kikuyu"
    KJ = "Kuanyama"
    KK = "Kazakh"
    KL = "Greenlandic"
    KM = "Cambodian"
    KN = "Kannada"
    KO = "Korean"
    KR = "Kanuri"
    KS = "Kashmiri"
    KU = "Kurdish"
    KV = "Komi"
    KW = "Cornish"
    KY = "Kirghiz"
    LA = "Latin"
    LB = "Luxembourgish"
    LG = "Ganda"
    LI = "Limburgian"
    LN = "Lingala"
    LO = "Laotian"
    LT = "Lithuanian"
    LU = "Luba-Katanga"
    LV = "Latvian"
    MG = "Malagasy"
    MH = "Marshallese"
    MI = "Maori"
    MK = "Macedonian"
    ML = "Malayalam"
    MN = "Mongolian"
    MO = "Moldovan"
    MR = "Marathi"
    MS = "Malay"
    MT = "Maltese"
    MY = "Burmese"
    NA = "Nauruan"
    NB = "Norwegian Bokmål"
    ND = "North Ndebele"
    NE = "Nepali"
    NG = "Ndonga"
    NL = "Dutch"
    NN = "Norwegian Nynorsk"
    NO = "Norwegian"
    NR = "South Ndebele"
    NV = "Navajo"
    NY = "Chichewa"
    OC = "Occitan"
    OJ = "Ojibwa"
    OM = "Oromo"
    OR = "Oriya"
    OS = "Ossetian / Ossetic"
    PA = "Panjabi / Punjabi"
    PI = "Pali"
    PL = "Polish"
    PS = "Pashto"
    PT = "Portuguese"
    QU = "Quechua"
    RM = "Raeto Romance"
    RN = "Kirundi"
    RO = "Romanian"
    RU = "Russian"
    RW = "Rwandi"
    SA = "Sanskrit"
    SC = "Sardinian"
    SD = "Sindhi"
    SE = "Northern Sami"
    SG = "Sango"
    SH = "Serbo-Croatian"
    SI = "Sinhalese"
    SK = "Slovak"
    SL = "Slovenian"
    SM = "Samoan"
    SN = "Shona"
    SO = "Somalia"
    SQ = "Albanian"
    SR = "Serbian"
    SS = "Swati"
    ST = "Southern Sotho"
    SU = "Sundanese"
    SV = "Swedish"
    SW = "Swahili"
    TA = "Tamil"
    TE = "Telugu"
    TG = "Tajik"
    TH = "Thai"
    TI = "Tigrinya"
    TK = "Turkmen"
    TL = "Tagalog / Filipino"
    TN = "Tswana"
    TO = "Tonga"
    TR = "Turkish"
    TS = "Tsonga"
    TT = "Tatar"
    TW = "Twi"
    TY = "Tahitian"
    UG = "Uyghur"
    UK = "Ukrainian"
    UR = "Urdu"
    UZ = "Uzbek"
    VE = "Venda"
    VI = "Vietnamese"
    VO = "Volapük"
    WA = "Walloon"
    WO = "Wolof"
    XH = "Xhosa"
    YI = "Yiddish"
    YO = "Yoruba"
    ZA = "Zhuang"
    ZH = "Chinese"
    ZU = "Zulu"
