import enum


# Supported currencies for Stripe https://stripe.com/docs/currencies?presentment-currency=DE
# Commented out are the Zero-decimal currencies, to avoid custom implementation
class CurrencyEnum(str, enum.Enum):
    USD = "United States Dollar"
    AED = "United Arab Emirates Dirham"
    AFN = "Afghan Afghani"
    ALL = "Albanian Lek"
    AMD = "Armenian Dram"
    ANG = "Netherlands Antillean Guilder"
    AOA = "Angolan Kwanza"
    ARS = "Argentine Peso"
    AUD = "Australian Dollar"
    AWG = "Aruban Florin"
    AZN = "Azerbaijani Manat"
    BAM = "Bosnia-Herzegovina Convertible Mark"
    BBD = "Barbadian Dollar"
    BDT = "Bangladeshi Taka"
    BGN = "Bulgarian Lev"
    # BIF = "Burundian Franc"
    BMD = "Bermudan Dollar"
    BND = "Brunei Dollar"
    BOB = "Bolivian Boliviano"
    BRL = "Brazilian Real"
    BSD = "Bahamian Dollar"
    BWP = "Botswanan Pula"
    BYN = "Belarusian Ruble"
    BZD = "Belize Dollar"
    CAD = "Canadian Dollar"
    CDF = "Congolese Franc"
    CHF = "Swiss Franc"
    # CLP = "Chilean Peso"
    CNY = "Chinese Yuan"
    COP = "Colombian Peso"
    CRC = "Costa Rican Colón"
    CVE = "Cape Verdean Escudo"
    CZK = "Czech Republic Koruna"
    # DJF = "Djiboutian Franc"
    DKK = "Danish Krone"
    DOP = "Dominican Peso"
    DZD = "Algerian Dinar"
    EGP = "Egyptian Pound"
    ETB = "Ethiopian Birr"
    EUR = "Euro"
    FJD = "Fijian Dollar"
    FKP = "Falkland Islands Pound"
    GBP = "British Pound Sterling"
    GEL = "Georgian Lari"
    GIP = "Gibraltar Pound"
    GMD = "Gambian Dalasi"
    # GNF = "Guinean Franc"
    GTQ = "Guatemalan Quetzal"
    GYD = "Guyanaese Dollar"
    HKD = "Hong Kong Dollar"
    HNL = "Honduran Lempira"
    HTG = "Haitian Gourde"
    HUF = "Hungarian Forint"
    IDR = "Indonesian Rupiah"
    ILS = "Israeli New Sheqel"
    INR = "Indian Rupee"
    ISK = "Icelandic Króna"
    JMD = "Jamaican Dollar"
    # JPY = "Japanese Yen"
    KES = "Kenyan Shilling"
    KGS = "Kyrgystani Som"
    KHR = "Cambodian Riel"
    # KMF = "Comorian Franc"
    # KRW = "South Korean Won"
    KYD = "Cayman Islands Dollar"
    KZT = "Kazakhstani Tenge"
    LAK = "Laotian Kip"
    LBP = "Lebanese Pound"
    LKR = "Sri Lankan Rupee"
    LRD = "Liberian Dollar"
    LSL = "Lesotho Loti"
    MAD = "Moroccan Dirham"
    MDL = "Moldovan Leu"
    # MGA = "Malagasy Ariary"
    MKD = "Macedonian Denar"
    MMK = "Myanma Kyat"
    MNT = "Mongolian Tugrik"
    MOP = "Macanese Pataca"
    MUR = "Mauritian Rupee"
    MVR = "Maldivian Rufiyaa"
    MWK = "Malawian Kwacha"
    MXN = "Mexican Peso"
    MYR = "Malaysian Ringgit"
    MZN = "Mozambican Metical"
    NAD = "Namibian Dollar"
    NGN = "Nigerian Naira"
    NIO = "Nicaraguan Córdoba"
    NOK = "Norwegian Krone"
    NPR = "Nepalese Rupee"
    NZD = "New Zealand Dollar"
    PAB = "Panamanian Balboa"
    PEN = "Peruvian Nuevo Sol"
    PGK = "Papua New Guinean Kina"
    PHP = "Philippine Peso"
    PKR = "Pakistani Rupee"
    PLN = "Polish Zloty"
    # PYG = "Paraguayan Guarani"
    QAR = "Qatari Rial"
    RON = "Romanian Leu"
    RSD = "Serbian Dinar"
    RUB = "Russian Ruble"
    # RWF = "Rwandan Franc"
    SAR = "Saudi Riyal"
    SBD = "Solomon Islands Dollar"
    SCR = "Seychellois Rupee"
    SEK = "Swedish Krona"
    SGD = "Singapore Dollar"
    SHP = "Saint Helena Pound"
    SLE = "Sierra Leonean Leone"
    SOS = "Somali Shilling"
    SRD = "Surinamese Dollar"
    STD = "São Tomé and Príncipe Dobra"
    SZL = "Swazi Lilangeni"
    THB = "Thai Baht"
    TJS = "Tajikistani Somoni"
    TOP = "Tongan Pa`anga"
    TRY = "Turkish Lira"
    TTD = "Trinidad and Tobago Dollar"
    TWD = "New Taiwan Dollar"
    TZS = "Tanzanian Shilling"
    UAH = "Ukrainian Hryvnia"
    # UGX = "Ugandan Shilling"
    UYU = "Uruguayan Peso"
    UZS = "Uzbekistan Som"
    # VND = "Vietnamese Dong"
    # VUV = "Vanuatu Vatu"
    WST = "Samoan Tala"
    # XAF = "CFA Franc BEAC"
    XCD = "East Caribbean Dollar"
    # XOF = "CFA Franc BCEAO"
    # XPF = "CFP Franc"
    YER = "Yemeni Rial"
    ZAR = "South African Rand"
    ZMW = "Zambian Kwacha"


class StripeStatus(str, enum.Enum):
    active = "active"
    all = "all"
    canceled = "canceled"
    ended = "ended"
    incomplete = "incomplete"
    incomplete_expired = "incomplete_expired"
    past_due = "past_due"
    paused = "paused"
    trialing = "trialing"
    unpaid = "unpaid"
