# generated by datamodel-codegen:
#   filename:  AgentOS-Send-Request-2501.json
#   timestamp: 2025-07-15T14:07:45+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, confloat, constr, conint


class Name(Enum):
    GetMousePosition = 'GetMousePosition'


class Command(BaseModel):
    name: Name
    parameters: Optional[List] = None


class Name1(Enum):
    SetMousePosition = 'SetMousePosition'


class Command1(BaseModel):
    name: Name1
    parameters: List = Field(..., max_length=1, min_length=1)


class Name2(Enum):
    AddRenderObject = 'AddRenderObject'


class Command2(BaseModel):
    name: Name2
    parameters: List


class Name3(Enum):
    UpdateRenderObject = 'UpdateRenderObject'


class Command3(BaseModel):
    name: Name3
    parameters: List


class Name4(Enum):
    DeleteRenderObject = 'DeleteRenderObject'


class Command4(BaseModel):
    name: Name4
    parameters: List


class Name5(Enum):
    ClearRenderObjects = 'ClearRenderObjects'


class Command5(BaseModel):
    name: Name5
    parameters: Optional[List] = None


class Guid(
    RootModel[
        constr(
            pattern=r'^\{[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\}$'
        )
    ]
):
    root: constr(
        pattern=r'^\{[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\}$'
    )


class Length(RootModel[Union[constr(pattern=r'^(\d+(\.\d+)?(px|%)|auto)$'), int, float]]):
    root: Union[constr(pattern=r'^(\d+(\.\d+)?(px|%)|auto)$'), int, float]


class Color(
    RootModel[
        Union[
            constr(pattern=r'^#([0-9a-fA-F]{6})$'),
            constr(pattern=r'^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$'),
        ]
    ]
):
    root: Union[
        constr(pattern=r'^#([0-9a-fA-F]{6})$'),
        constr(pattern=r'^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$'),
    ]


class Location2(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    x: Length
    y: Length


class RenderObjectType(Enum):
    Quad = 'Quad'
    Line = 'Line'
    Texture = 'Texture'
    Image = 'Image'


class RenderObjectId(RootModel[conint(ge=0, le=18446744073709551615)]):
    root: conint(ge=0, le=18446744073709551615)


class RenderObjectStyle(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    top: Optional[Length] = None
    left: Optional[Length] = None
    bottom: Optional[Length] = None
    right: Optional[Length] = None
    width: Optional[Length] = None
    height: Optional[Length] = None
    color: Optional[Color] = None
    font_size: Optional[Length] = Field(None, alias='font-size')
    opacity: Optional[confloat(ge=0.0, le=1.0)] = None
    visible: Optional[bool] = None
    line_width: Optional[Length] = Field(None, alias='line-width')


class RenderLinePoints(RootModel[List[Location2]]):
    root: List[Location2] = Field(..., max_length=64, min_length=2)


class RenderImage(
    RootModel[
        constr(
            pattern=r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$'
        )
    ]
):
    root: constr(
        pattern=r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$'
    ) = Field(..., description='A Base64-encoded image')


class RenderText(RootModel[constr(pattern=r'^[\u0020-\u007F]*$')]):
    root: constr(pattern=r'^[\u0020-\u007F]*$')


class Header(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    authentication: Guid


class Message(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    header: Header
    command: Union[Command, Command1, Command2, Command3, Command4, Command5]


class AskuiAgentosSendRequestSchema(BaseModel):
    message: Message
