from copy import deepcopy
from typing import Callable
from uuid import UUID
from maleo.schemas.resource import ResourceIdentifier
from ..enums.record import IdentifierType
from ..types.record import IdentifierValueType
from . import XRAY_RESOURCE


IDENTIFIER_TYPE_VALUE_TYPE_MAP: dict[
    IdentifierType,
    Callable[..., IdentifierValueType],
] = {
    IdentifierType.ID: int,
    IdentifierType.UUID: UUID,
}


RECORD_INFERENCE_RESOURCE = deepcopy(XRAY_RESOURCE)
RECORD_INFERENCE_RESOURCE.identifiers.append(
    ResourceIdentifier(
        key="record_inference", name="Record Inference", slug="records-inferences"
    )
)
