from dataclasses import dataclass
from steelsnakes.base import BaseSection

@dataclass
class Angle(BaseSection):
    designation: str
    section_type: str # read as 'type' in database # TODO: change to section_type in database
    EDI_Std_Nomenclature: str = ""

    W: float = 0.0 # Nominal weight (lb/ft)
    A: float = 0.0 # Area (in²)
    d: float = 0.0 # Depth (in)
    t: float = 0.0 # Thickness (in)
    kdes: float = 0.0 #
    kdet: float = 0.0 #
    x: float = 0.0 #
    y: float = 0.0 #
    xp: float = 0.0 #
    yp: float = 0.0 #
    # TODO: add more properties... after double checking & reparsing...
    # TODO: check with UK/EU/IS...

@dataclass
class DoubleAngle(BaseSection):
    pass

@dataclass
class EqualAngle(Angle):
    pass

@dataclass
class UnequalAngle(Angle):
    pass


@dataclass
class L(EqualAngle):
    pass

@dataclass
class L2L(DoubleAngle):
    pass



