from dataclasses import dataclass
from steelsnakes.base import BaseSection

@dataclass
class Beam(BaseSection):
    # Identification
    designation: str
    section_type: str # read as 'type' in database # TODO: change to section_type in database
    EDI_Std_Nomenclature: str = ""
    T_F: str = ""

    # 
    W: float = 0.0 # Nominal weight (lb/ft)
    A: float = 0.0 # Area (in²)
    d: float = 0.0 # Depth (in)
    ddet: float = 0.0 #
    bf: float = 0.0 # Flange width (in)
    bfdet: float = 0.0 # 
    tw: float = 0.0 # Web thickness (in)
    twdet: float = 0.0 #
    twdet_2: float = 0.0 #
    tf: float = 0.0 # Flange thickness (in)
    tfdet: float = 0.0
    kdes: float = 0.0 #
    kdet: float = 0.0 
    k1: float = 0.0 #

    # Compact section criteria
    bf_2tf: float = 0.0 #
    h_tw: float = 0.0

    I_xx: float = 0.0 # Moment of inertia, major axis (in^4)
    Z_xx: float = 0.0 # Plastic section modulus, major axis (in^3)
    S_xx: float = 0.0 # Elastic section modulus, major axis (in^3)
    r_xx: float = 0.0 # Radius of gyration

    I_yy: float = 0.0 # Moment of inertia, minor axis (in^4)
    Z_yy: float = 0.0 # Plastic section modulus, minor axis (in^3)
    S_yy: float = 0.0 # Elastic section modulus, minor axis (in^3)
    r_yy: float = 0.0 # Radius of gyration

    J: float = 0.0 # Torsional constant (in^4)
    Cw: float = 0.0 # Warping constant (in^6)
    Wno: float = 0.0
    Sw1: float = 0.0
    Qf: float = 0.0
    Qw: float = 0.0
    rts: float = 0.0
    h0: float = 0.0
    PA: float = 0.0
    PB: float = 0.0
    PC: float = 0.0
    PD: float = 0.0
    T: float = 0.0
    WGi: float = 0.0
    WGo: float = 0.0
    

@dataclass
class WideFlangeBeam(Beam):
    pass

@dataclass
class StandardBeam(Beam):
    pass

@dataclass
class MiscellaneousBeam(Beam):
    pass

@dataclass
class BearingPile(Beam):
    pass