# SECTIONS

## Table of Contents
- [SECTIONS](#sections)
  - [Table of Contents](#table-of-contents)
  - [Beams - `W`, `S`, `M`, `HP`](#beams---w-s-m-hp)
  - [Channels - `C`, `MC`](#channels---c-mc)
  - [Double Channels - `C2C`, `MC2MC`](#double-channels---c2c-mc2mc)
  - [Angles - `L`](#angles---l)
  - [Double Angles - `L2L`](#double-angles---l2l)
  - [Structural Tees - `WT`, `ST`, `MT`](#structural-tees---wt-st-mt)
  - [Hollow Structural Sections - `HSS`](#hollow-structural-sections---hss)
  - [Pipes - `PIPE`](#pipes---pipe)

## Beams - `W`, `S`, `M`, `HP`

- `W` - Wide-Flange Beams, with parallel inner and outer flanges
- `S` - Standard Beams, with sloped inner flanges
- `M` - Miscellaneous Beams, not classified as W, S or HP; may have sloped inside flange faces; don't meet criteria for W, S, or HP shapes
- `HP` - Bearing Piles, like W shapes but webs and flanges are of equal thickness and depth and flange width are equal for given designation <!-- TODO: check this out -->

## Channels - `C`, `MC`
- `C` - Standard Channels, with sloped inner flange surfaces
- `MC` - Miscellaneous Channels, not classified as C shapes; have slopes other than 16 2/3% on inner flange surfaces; 

## Double Channels - `C2C`, `MC2MC`
- Double channels (also known as 2C- and 2MC-shapes) are made with two channels that are interconnected through their back-to-back webs along the length of the member, either in contact for the fulllength or separated by spacers at the points of interconnection.

## Angles - `L`
- `L` - Equal and Unequal Leg Angles; legs of equal thickness and either equal or unequal leg sizes

## Double Angles - `L2L`
- `L2L` - Double angles (also known as 2L-shapes) are made with two angles that are interconnected through their back-to-back legs along the length of the member, either in contact for the full length or separated by spacers at the points of interconnection.

## Structural Tees - `WT`, `ST`, `MT`
- `WT` - cut from `W` shapes
- `ST` - cut from `S` shapes
- `MT` - cut from `M` shapes

## Hollow Structural Sections - `HSS`
- `HSS`, with:
  - Rectangular which have an essentially rectangular cross-section, except for rounded corners, and uniform wall thickness, except at the weld seam(s).
  - Square, which have an essentially square cross-section, except for rounded corners, and uniform wall thickness, except at the weld seam(s)
  - Round which have an essentially round cross-section and uniform wall thickness, except at the weld seam(s).

## Pipes - `PIPE`
- `PIPE` - Pipes have an essentially round cross-section and uniform thickness, except at the weld seam(s) for welded pipe.
