from dataclasses import dataclass
from steelsnakes.base import BaseSection

@dataclass
class HollowStructuralSection(BaseSection):
    designation: str
    section_type: str # read as 'type' in database # TODO: change to section_type in database
    EDI_Std_Nomenclature: str = ""

    W: float = 0.0 # Nominal weight (lb/ft)
    A: float = 0.0 # Area (in²)
    
    # TODO: IMPORTANT: really analyse metric vs imperial sections
    # TODO: the HSS table is not unique/tabular, i.e square, rect. & circular are together
    # TODO: parse HSS sections, separate, and add to new database/new json
    # TODO: go over sqlite/database/tabular feature for US before deployment.


@dataclass
class RectangularHSS(HollowStructuralSection):
    pass

@dataclass
class SquareHSS(HollowStructuralSection):
    pass

@dataclass
class RoundHSS(HollowStructuralSection):
    pass