from dataclasses import dataclass
from steelsnakes.base import BaseSection

@dataclass
class Tee(BaseSection):
    designation: str
    section_type: str # read as 'type' in database # TODO: change to section_type in database
    EDI_Std_Nomenclature: str = ""
    
    W: float = 0.0 # Nominal weight (lb/ft)
    A: float = 0.0 # Area (in²)
    

@dataclass
class StandardTee(Tee):
    pass

@dataclass
class MiscellaneousTee(Tee):
    pass

@dataclass
class WideFlangeTee(Tee):
    pass

@dataclass
class ST(StandardTee):
    pass

@dataclass
class MT(MiscellaneousTee):
    pass

@dataclass
class WT(WideFlangeTee):
    pass