# Generated by Django 4.2.3 on 2023-07-10 18:54

import django.core.validators
from django.db import migrations
import django_crypto_fields.fields.encrypted_char_field


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_consent", "0010_alter_subjectreconsent_options"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="subjectconsent",
            unique_together={
                ("subject_identifier", "screening_identifier"),
                ("subject_identifier", "version"),
            },
        ),
        migrations.AlterField(
            model_name="historicalsubjectconsent",
            name="legal_name",
            field=django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                blank=True,
                help_text=" (Encryption: RSA local)",
                max_length=71,
                validators=[
                    django.core.validators.RegexValidator(
                        message="Ensure full name consists of letters only in upper case separated by single spaces",
                        regex="^(([A-Z]+ )*[A-Z]+)?$",
                    )
                ],
                verbose_name="Full name",
            ),
        ),
        migrations.AlterField(
            model_name="subjectconsent",
            name="legal_name",
            field=django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                blank=True,
                help_text=" (Encryption: RSA local)",
                max_length=71,
                validators=[
                    django.core.validators.RegexValidator(
                        message="Ensure full name consists of letters only in upper case separated by single spaces",
                        regex="^(([A-Z]+ )*[A-Z]+)?$",
                    )
                ],
                verbose_name="Full name",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="subjectconsent",
            unique_together={
                ("legal_name", "initials", "version"),
                ("subject_identifier", "screening_identifier"),
                ("subject_identifier", "version"),
            },
        ),
    ]
