from edc_constants.constants import (
    CLINICAL_WITHDRAWAL,
    COMMUNITY,
    DEAD,
    DM,
    DONT_KNOW,
    DWTA,
    ESTIMATED,
    FREE_OF_CHARGE,
    HIV,
    HTN,
    INSURANCE,
    NONE,
    NOT_APPLICABLE,
    OTHER,
    OWN_CASH,
    PATIENT,
    PATIENT_CLUB,
    PATIENT_REPRESENTATIVE,
    PREGNANCY,
    PRIVATE,
    RELATIVE,
)
from edc_dx_review.constants import DIET_LIFESTYLE, DRUGS, INSULIN
from edc_he.constants import CHF, NHIF
from edc_list_data.row import Row
from edc_ltfu.constants import LOST_TO_FOLLOWUP
from edc_offstudy.constants import COMPLETED_FOLLOWUP, CONSENT_WITHDRAWAL
from edc_transfer.constants import TRANSFERRED

from intecomm_lists.constants import HEALTH_RECORDS
from intecomm_subject.constants import VIT_B_FOLIC_ACID

list_data = {
    "intecomm_lists.drugpaysources": [
        (OWN_CASH, "Own cash"),
        (INSURANCE, "Insurance"),
        (PATIENT_CLUB, "Patient support group / club"),
        (RELATIVE, "Relative or others paying"),
        (FREE_OF_CHARGE, "Free drugs from the pharmacy"),
        (OTHER, "Other pay source (specify below)"),
    ],
    "intecomm_lists.offstudyreasons": [
        (COMPLETED_FOLLOWUP, "Patient completed 12 months of follow-up"),
        (CONSENT_WITHDRAWAL, "Patient withdrew consent to participate further"),
        (CLINICAL_WITHDRAWAL, "Patient is withdrawn on CLINICAL grounds ..."),
        (LOST_TO_FOLLOWUP, "Patient lost to follow-up (at 12m only)"),
        (
            TRANSFERRED,
            "Patient has been transferred to another health centre/ area (at 12m only)",
        ),
        (DEAD, "Patient reported/known to have died"),
        (
            OTHER,
            "Other reason (specify below)",
        ),
    ],
    "intecomm_lists.subjectvisitmissedreasons": [
        ("forgot", "Forgot / Can’t remember being told about appointment"),
        ("family_emergency", "Family emergency (e.g. funeral) and was away"),
        ("travelling", "Away travelling/visiting"),
        ("working_schooling", "Away working/schooling"),
        ("too_sick", "Too sick or weak to come to the centre"),
        ("lack_of_transport", "Transportation difficulty"),
        (OTHER, "Other reason (specify below)"),
    ],
    "intecomm_lists.clinicalwithdrawalreasons": [
        (PREGNANCY, "Pregnancy"),
        ("kidney_disease", "Development of chronic kidney disease"),
        ("liver_disease", "Development of chronic liver disease"),
        ("intercurrent_illness", "Intercurrent illness which prevents further treatment"),
        ("investigator_decision", "Investigator decision"),
        (NOT_APPLICABLE, "Not applicable"),
        (
            OTHER,
            (
                "Other condition that justifies the discontinuation of "
                "treatment in the clinician’s opinion (specify below)"
            ),
        ),
    ],
    "intecomm_lists.healthtalktypes": [
        ("study_intro_talk", "INTECOMM study introduction"),
        ("sensitisation_talk", "INTECOMM Sensitisation"),
        (OTHER, "Other (specify below)"),
    ],
    "intecomm_lists.conditions": [
        (HIV, "HIV"),
        (DM, "Diabetes"),
        (HTN, "Hypertension"),
    ],
    "intecomm_lists.locationtypes": [
        ("school", "School"),
        (OTHER, "Other (specify below)"),
    ],
    "intecomm_lists.dmmanagement": [
        (INSULIN, "Insulin injections"),
        (DRUGS, "Oral drugs"),
        (DIET_LIFESTYLE, "Diet and lifestyle"),
        (OTHER, "Other, please specify below ..."),
    ],
    "intecomm_lists.htnmanagement": [
        (DRUGS, "Oral drugs"),
        (DIET_LIFESTYLE, "Diet and lifestyle"),
        (OTHER, "Other, please specify below ..."),
    ],
    "intecomm_lists.htntreatments": [
        ("aldactone", "Aldactone (Spironolactone)"),
        ("amlodipine", "Amlodipine"),
        ("atenolol", "Atenolol"),
        ("atorvastatin", "Atorvastatin"),
        ("bendroflumethiazide", "Bendroflumethiazide"),
        ("bisoprolol", "Bisoprolol"),
        ("candesartan", "Candesartan"),
        ("captopril", "Captopril"),
        ("carvedilol", "Carvedilol"),
        ("clopidogrel", "Clopidogrel"),
        ("enalapril", "Enalapril"),
        ("frusemide", "Frusemide"),
        ("hydralazine", "Hydralazine"),
        ("hydrochlorothiazide", "Hydrochlorothiazide"),
        ("irbesartan", "Irbesartan"),
        ("irbesartan_hydrochlorothiazide", "Irbesartan Hydrochlorothiazide"),
        ("junior_aspirin", "Junior Aspirin"),
        ("lisinopril", "Lisinopril"),
        ("losartan_h", "losartan Hydrochlorothiazide (Losartan H/Repace H)"),
        ("losartan", "losartan"),
        ("methyldopa", "Methyldopa"),
        ("metoprolol", "Metoprolol"),
        ("nifedipine", "Nifedipine"),
        ("olmesartan", "Olmesartan"),
        ("propanolol", "Propanolol"),
        ("ramipril", "Ramipril"),
        ("rosuvastatin", "Rosuvastatin"),
        ("s-amlodipine", "S-Amlodipine"),
        ("simvastatin", "Simvastatin"),
        ("telmisartan", "Telmisartan"),
        ("valsartan", "Valsartan"),
        (VIT_B_FOLIC_ACID, "Vitamin Bs + Folic Acid"),
        (OTHER, "Other treatment (specify below)"),
    ],
    "intecomm_lists.arvregimens": [
        ("ABC_3TC_ATV_r", "ABC + 3TC + ATV/r"),
        ("ABC_3TC_DTG", "ABC + 3TC + DTG"),
        ("ABC_3TC_EFV", "ABC + 3TC + EFV"),
        ("ABC_3TC_LPV_r", "ABC + 3TC + LPV/r"),
        ("AZT_3TC_ATV_r", "AZT + 3TC + ATV/r"),
        ("AZT_3TC_DTG", "AZT + 3TC + DTG"),
        ("AZT_3TC_EFV", "AZT + 3TC + EFV"),
        ("AZT_3TC_LPV_r", "AZT + 3TC + LPV/r"),
        ("AZT_3TC_NVP", "AZT + 3TC + NVP"),
        ("DTG_ABC/3TC_ATV_r", "DTG + (ABC/3TC) + ATV/r"),
        ("TDF_3TC_ATV_r", "TDF + 3TC + ATV/r"),
        ("TDF_3TC_DTG", "TDF + 3TC + DTG"),
        ("TDF_3TC_EFV", "TDF + 3TC + EFV"),
        ("TDF_3TC_LPV_r", "TDF + 3TC + LPV/r"),
        ("TDF_3TC_NVP", "TDF + 3TC + NVP"),
        ("TDF_FTC_ATV_r", "TDF + FTC + ATV/r"),
        ("TDF_FTC_DTG", "TDF + FTC + DTG"),
        ("TDF_FTC_EFV", "TDF + FTC + EFV"),
        ("TDF_FTC_LPV_r", "TDF + FTC + LPV/r"),
        ("TDF_FTC_NVP", "TDF + FTC + NVP"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.arvdrugs": [
        ("3TC", "3TC"),
        ("ABC", "ABC"),
        ("ATV_r", "ATV/r"),
        ("AZT", "AZT"),
        ("DTG", "DTG"),
        ("EFV", "EFV"),
        ("FTC", "FTC"),
        ("LPV_r", "LPV/r"),
        ("NVP", "NVP"),
        ("TDF", "TDF"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.dmtreatments": [
        ("glibenclamide_metformin", "Glibenclamide + Metformin combo"),
        ("glibenclamide_s", "Glibenclamide (S)"),
        ("gliclazide_s", "Gliclazide (S)"),
        ("glimepiride_1mg_metformin", "Glimepiride (1mg) + Metformin combo"),
        ("glimepiride_2mg_metformin", "Glimepiride (2mg) + Metformin combo"),
        ("glimepiride_s", "Glimepiride (S)"),
        ("glipizide_s", "Glipizide (S)"),
        (INSULIN, "Insulin"),
        ("metformin_b", "Metformin (B)"),
        ("pioglitazone", "Pioglitazone"),
        ("pregabalin", "Pregabalin (diabetic neuropathy)"),
        (VIT_B_FOLIC_ACID, "Vitamin Bs + Folic Acid (Neuroton- diabetic neuropathy)"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.rxmodifications": [
        ("dose_changes", "Dose changes"),
        ("drugs_substitution", "Drugs substitution"),
        ("drug_additions", "Additional drugs added to existing regimen"),
        ("some_stopped", "Some drugs stopped"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.rxmodificationreasons": [
        ("availability", "Limited availability of drugs"),
        ("side_effects", "Had side-effects"),
        ("feel_better", "Felt well and stopped/reduced drug prescription"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.screeningrefusalreasons": [
        ("dont_have_time", "I don't have time"),
        ("must_consult_spouse", "I need to consult my spouse"),
        ("dont_want_to_join", "I don't want to take part"),
        ("need_to_think_about_it", "I haven't had a chance to think about it"),
        (NOT_APPLICABLE, "Not applicable"),
        (OTHER, "Other, specify"),
    ],
    "intecomm_lists.consentrefusalreasons": [
        ("dont_have_time", "I don't have time"),
        ("must_consult_spouse", "I need to consult my spouse"),
        ("dont_want_to_join", "I don't want to take part"),
        ("need_to_think_about_it", "I haven't had a chance to think about it"),
        (OTHER, "Other, please specify"),
    ],
    "intecomm_lists.nonadherencereasons": [
        ("forgot_to_take", "I simply forgot to take my medication"),
        ("travelled", "I travelled and forgot my medication"),
        ("feel_better", "I felt better and stopped taking my medication"),
        (
            "insufficient_supply",
            "I did not get enough medication from hospital/clinic, could not buy more",
        ),
        ("feel_ill", "The medications were making me feel sick"),
        ("too_many_pills", "Too many pills so I stopped / reduced"),
        (OTHER, "Other, please specify ..."),
    ],
    "intecomm_lists.transferreasons": [
        ("moved", "Moved away from the area"),
        ("unhappy_with_care", "Was unhappy with the care they are receiving"),
        ("need_specialized_treatment", "Needed more specialist treatment"),
        ("drug_supply", "Due to drug supply "),
        ("stigma", "Concerned about stigma"),
        (DWTA, "No reason provided"),
        (OTHER, "Other reason (specify below)"),
    ],
    "edc_he.insurancetypes": [
        (PRIVATE, "Private/work-place/voluntary health insurance"),
        Row((NHIF, "NHIF (National Health Insurance Fund)"), extra="tanzania"),
        Row((CHF, "CHF (Community Health Insurance Fund)"), extra="tanzania"),
        Row((COMMUNITY, "Community-based health insurance"), extra="uganda"),
        Row(("club", "Patient support group / club"), extra="uganda"),
        (NONE, "None"),
        (DONT_KNOW, "Don’t know"),
        (OTHER, "Other, specify"),
        (NOT_APPLICABLE, "Not applicable"),
    ],
    "edc_he.nationalities": [
        ("tanzania", "Tanzanian"),
        ("uganda", "Ugandan"),
        (NONE, "None of the above"),
    ],
    "edc_he.religions": [
        Row(("african_inland_church", "African Inland Church"), extra="tanzania"),
        ("catholic", "Catholic"),
        Row(("lutheran", "Lutheran"), extra="tanzania"),
        Row(("moravian", "Moravian"), extra="tanzania"),
        ("muslim", "Muslim"),
        ("pentecostal", "Pentecostal"),
        Row(("protestant", "Protestant"), extra="uganda"),
        ("seventh_day_adventist", "Seventh day Adventist"),
        Row(("tz_assemblies_of_god", "Tanzanian Assemblies of God"), extra="tanzania"),
        ("no_religion", "No religion"),
        (OTHER, "Other, specify"),
        (NOT_APPLICABLE, "Not applicable"),
    ],
    "edc_he.ethnicities": [
        Row(("acholi", "Acholi"), extra="uganda"),
        Row(("alur", "Alur"), extra="uganda"),
        Row(("baganda", "Baganda"), extra="uganda"),
        Row(("bagisu", "Bagisu"), extra="uganda"),
        Row(("bakhonzo", "Bakhonzo"), extra="uganda"),
        Row(("bakiga", "Bakiga"), extra="uganda"),
        Row(("banyakole", "Banyakole"), extra="uganda"),
        Row(("banyoro", "Banyoro"), extra="uganda"),
        Row(("basoga", "Basoga"), extra="uganda"),
        Row(("batoro", "Batoro"), extra="uganda"),
        Row(("iteso", "Iteso"), extra="uganda"),
        Row(("langi", "Langi"), extra="uganda"),
        Row(("lugbara", "Lugbara"), extra="uganda"),
        Row(("mchaga", "Mchaga"), extra="tanzania"),
        Row(("mhaya", "Mhaya"), extra="tanzania"),
        Row(("mhindi", "Mhindi"), extra="tanzania"),
        Row(("mjaluo", "Mjaluo"), extra="tanzania"),
        Row(("mjita", "Mjita"), extra="tanzania"),
        Row(("mkara_mkerewe", "Mkara/Mkerewe"), extra="tanzania"),
        Row(("mkuria_mshashi", "Mkuria/Mshashi"), extra="tanzania"),
        Row(("msukuma", "Msukuma"), extra="tanzania"),
        Row(("mwarabu", "Mwarabu"), extra="tanzania"),
        Row(("myiramba", "Myiramba"), extra="tanzania"),
        Row(("mzinza", "Mzinza"), extra="tanzania"),
        (OTHER, "Other, specify"),
        (NOT_APPLICABLE, "Not applicable"),
    ],
    "edc_next_appointment.infosources": [
        (COMMUNITY, "Community group"),
        (PATIENT, "Patient"),
        (
            PATIENT_REPRESENTATIVE,
            "Patient representative (e.g., next of kin, relative, guardian)",
        ),
        (HEALTH_RECORDS, "Health records"),
        (ESTIMATED, "Estimated by research staff"),
        (OTHER, "Other"),
    ],
}
