# Generated by Django 4.1.2 on 2022-11-20 21:08

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django.db.models.functions.text
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_crypto_fields.fields.encrypted_char_field
import django_crypto_fields.fields.encrypted_text_field
import django_revision.revision_field
import edc_model.models.fields.duration
import edc_model.validators.phone
import edc_model_fields.fields.initials_field
import edc_model_fields.fields.other_charfield
import edc_screening.model_mixins.screening_fields_model_mixin
import edc_sites.models
import edc_utils.date
import edc_vitals.models.fields.blood_pressure
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import intecomm_screening.models.health_talk_log
import intecomm_screening.models.old_health_facility
import intecomm_screening.models.patient_call
import intecomm_screening.models.patient_log


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("intecomm_group", "0001_initial"),
        ("intecomm_lists", "0001_initial"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HealthFacility",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                ("name", models.CharField(max_length=25, unique=True)),
                (
                    "health_facility_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "distance",
                    models.IntegerField(
                        help_text="In km. If within the health center type '0'",
                        verbose_name="Approximate distance from health center",
                    ),
                ),
                (
                    "gps",
                    models.CharField(
                        blank=True,
                        help_text="copy and paste directly from google maps",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "latitude",
                    models.FloatField(
                        blank=True,
                        help_text="in degrees. copy and paste directly from google maps",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-90),
                            django.core.validators.MaxValueValidator(90),
                        ],
                    ),
                ),
                (
                    "longitude",
                    models.FloatField(
                        blank=True,
                        help_text="in degrees. copy and paste directly from google maps",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-180),
                            django.core.validators.MaxValueValidator(180),
                        ],
                    ),
                ),
                ("notes", models.TextField(blank=True, null=True)),
                (
                    "health_facility_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.healthfacilitytypes",
                        verbose_name="Health facility type",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health Facility",
                "verbose_name_plural": "Health Facilities",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                ("objects", intecomm_screening.models.old_health_facility.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="PatientLog",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "patient_log_identifier",
                    models.CharField(default=uuid.uuid4, max_length=36, unique=True),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        help_text="Auto populated when screening form is complete",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "screening_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="Auto populated when screening form is complete",
                        null=True,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        blank=True,
                        help_text="Auto populated when consent form is complete",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "consent_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="Auto populated when consent form is complete",
                        null=True,
                    ),
                ),
                (
                    "name",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        unique=True,
                    ),
                ),
                (
                    "initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                (
                    "hf_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Must be unique (Encryption: RSA local)",
                        max_length=71,
                        unique=True,
                        verbose_name="Health facility identifier",
                    ),
                ),
                (
                    "contact_number",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="If unknown, type 'UNKNOWN' (Encryption: RSA local)",
                        max_length=71,
                        validators=[edc_model.validators.phone.phone_number],
                    ),
                ),
                (
                    "alt_contact_number",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        null=True,
                        validators=[edc_model.validators.phone.phone_number],
                    ),
                ),
                (
                    "may_contact",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Has the patient agreed to be contacted prior to consent?",
                    ),
                ),
                (
                    "location_description",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text="Street, landmarks near home, etc (Encryption: AES local)",
                        max_length=71,
                        null=True,
                    ),
                ),
                (
                    "stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="Refer to the SOP for the definition of 'stable'.",
                        max_length=15,
                        verbose_name="Do the facility health care staff consider the patient stable in care",
                    ),
                ),
                (
                    "last_routine_appt_date",
                    models.DateField(
                        blank=True,
                        help_text="If known, the last appointment may help to estimate the next appointment or the expected frequency of routine appointments",
                        null=True,
                        verbose_name="When was the patient last seen at this health facility",
                    ),
                ),
                (
                    "next_routine_appt_date",
                    models.DateField(
                        help_text="This date will help prioritize efforts to contact the patient",
                        verbose_name="Next scheduled routine appointment at this health facility",
                    ),
                ),
                (
                    "first_health_talk",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Attended general health talk",
                    ),
                ),
                (
                    "first_health_talk_date",
                    models.DateField(blank=True, null=True, verbose_name="General talk date"),
                ),
                (
                    "second_health_talk",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Attended sensitisation session",
                    ),
                ),
                (
                    "second_health_talk_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Sensitisation session date"
                    ),
                ),
                (
                    "call_attempts",
                    models.IntegerField(blank=True, default=0, help_text="auto-updated"),
                ),
                (
                    "conditions",
                    models.ManyToManyField(
                        to="intecomm_lists.conditions", verbose_name="Diagnoses"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                ("objects", intecomm_screening.models.patient_log.PatientLogManager()),
            ],
        ),
        migrations.CreateModel(
            name="PatientGroup",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("intecomm_group.patientgroup",),
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined relative to report_datetime",
                        null=True,
                    ),
                ),
                (
                    "real_eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined relative to now",
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        unique=True,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not suitable for the study",
                    ),
                ),
                (
                    "unsuitable_agreed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="Does the study coordinator agree that the patient is not suitable for the study?",
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                ("refused", models.BooleanField(default=False, editable=False)),
                (
                    "sys_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: systolic (average)",
                    ),
                ),
                (
                    "dia_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: diastolic (average)",
                    ),
                ),
                (
                    "severe_htn",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have severe hypertension?",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        unique=True,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "selection_method",
                    models.CharField(
                        choices=[
                            ("random_sampling", "Random sampling"),
                            ("purposively_selected", "Purposively selected"),
                        ],
                        default="purposively_selected",
                        max_length=25,
                        verbose_name="How was the patient selected for screening?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        unique=True,
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does the patient live within the catchment population of the health facility",
                    ),
                ),
                (
                    "staying_nearby_6",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in this catchment area for at least 6 months",
                    ),
                ),
                (
                    "in_care_6m",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for 6m or more at the health facility from which they are being recruited",
                        max_length=15,
                        verbose_name="Has the patient been in regular care at this health facility for 6 months or more",
                    ),
                ),
                (
                    "in_care_duration",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with HIV",
                    ),
                ),
                (
                    "hiv_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "hiv_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "art_unchanged_3m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Meaning no modifications to the type of medication and dose for at least 3 months",
                        max_length=15,
                        verbose_name="Has the patient been on the same anti-retroviral therapy for at least 3 months",
                    ),
                ),
                (
                    "art_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="considered by the clinical team not to have any complications/co-infections or that these are well managed.",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "art_adherent",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be adherent to treatment over the last 6 months",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with Diabetes",
                    ),
                ),
                (
                    "dm_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "dm_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_complications",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does the patient suffer from any complications of diabetes that are unmanaged or uncontrolled.",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with Hypertension",
                    ),
                ),
                (
                    "htn_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "htn_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_complications",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does the patient suffer from any complications of hypertension that are unmanaged or uncontrolled.",
                    ),
                ),
                (
                    "excluded_by_bp_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient's blood pressure exceeded 180/110 mmHg on more than one occasion any time in the last 6 months.",
                    ),
                ),
                (
                    "excluded_by_gluc_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient's blood glucose exceeded 13 mmol/L any time in the last 6 months.",
                    ),
                ),
                (
                    "requires_acute_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does the patient have any clinical condition that requires health facility management",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male or post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "patient_log",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_screening.patientlog",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Screening",
                "verbose_name_plural": "Subject Screening",
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                (
                    "objects",
                    edc_screening.model_mixins.screening_model_mixin.ScreeningManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "screening_identifier",
                    models.CharField(editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            (
                                "dont_want_blood_drawn",
                                "I don't want to have the blood drawn",
                            ),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_screening.subjectscreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Refusal",
                "verbose_name_plural": "Subject Refusals",
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name="patientlog",
            name="patient_group",
            field=models.ForeignKey(
                blank=True,
                help_text="This can be changed at anytime until the group is flagged as COMPLETE. It is recommended to choose a group early in the process.",
                limit_choices_to={
                    "randomized": False,
                    "status__in": ["New", "recruiting"],
                },
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="intecomm_screening.patientgroup",
                verbose_name="Choose a group (RECOMMENDED)",
            ),
        ),
        migrations.AddField(
            model_name="patientlog",
            name="site",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
                verbose_name="Health facility",
            ),
        ),
        migrations.CreateModel(
            name="PatientCall",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                (
                    "answered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                (
                    "respondent",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            ("family", "Family"),
                            ("friend", "friend"),
                            ("other", "other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                    ),
                ),
                (
                    "willing_to_attend",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_sure", "Not sure"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                    ),
                ),
                (
                    "attend_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When can the patient come to the clinic",
                    ),
                ),
                (
                    "call_again",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Call again?",
                    ),
                ),
                (
                    "comment",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text=" (Encryption: AES local)",
                        max_length=71,
                        null=True,
                        verbose_name="Note",
                    ),
                ),
                (
                    "patient_log",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_screening.patientlog",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Patient Call",
                "verbose_name_plural": "Patient Calls",
                "ordering": ["report_datetime"],
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                (
                    "objects",
                    intecomm_screening.model_mixins.patient_call_model_mixin.Manager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalSubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined relative to report_datetime",
                        null=True,
                    ),
                ),
                (
                    "real_eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined relative to now",
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not suitable for the study",
                    ),
                ),
                (
                    "unsuitable_agreed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="Does the study coordinator agree that the patient is not suitable for the study?",
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                ("refused", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "sys_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: systolic (average)",
                    ),
                ),
                (
                    "dia_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: diastolic (average)",
                    ),
                ),
                (
                    "severe_htn",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have severe hypertension?",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "selection_method",
                    models.CharField(
                        choices=[
                            ("random_sampling", "Random sampling"),
                            ("purposively_selected", "Purposively selected"),
                        ],
                        default="purposively_selected",
                        max_length=25,
                        verbose_name="How was the patient selected for screening?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does the patient live within the catchment population of the health facility",
                    ),
                ),
                (
                    "staying_nearby_6",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in this catchment area for at least 6 months",
                    ),
                ),
                (
                    "in_care_6m",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for 6m or more at the health facility from which they are being recruited",
                        max_length=15,
                        verbose_name="Has the patient been in regular care at this health facility for 6 months or more",
                    ),
                ),
                (
                    "in_care_duration",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with HIV",
                    ),
                ),
                (
                    "hiv_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "hiv_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "art_unchanged_3m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Meaning no modifications to the type of medication and dose for at least 3 months",
                        max_length=15,
                        verbose_name="Has the patient been on the same anti-retroviral therapy for at least 3 months",
                    ),
                ),
                (
                    "art_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="considered by the clinical team not to have any complications/co-infections or that these are well managed.",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "art_adherent",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be adherent to treatment over the last 6 months",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with Diabetes",
                    ),
                ),
                (
                    "dm_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "dm_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_complications",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does the patient suffer from any complications of diabetes that are unmanaged or uncontrolled.",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient previously been diagnosed with Hypertension",
                    ),
                ),
                (
                    "htn_dx_6m",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was the initial diagnosis made more than 6 months ago",
                    ),
                ),
                (
                    "htn_dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_complications",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does the patient suffer from any complications of hypertension that are unmanaged or uncontrolled.",
                    ),
                ),
                (
                    "excluded_by_bp_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient's blood pressure exceeded 180/110 mmHg on more than one occasion any time in the last 6 months.",
                    ),
                ),
                (
                    "excluded_by_gluc_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient's blood glucose exceeded 13 mmol/L any time in the last 6 months.",
                    ),
                ),
                (
                    "requires_acute_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does the patient have any clinical condition that requires health facility management",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male or post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "patient_log",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_screening.patientlog",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening",
                "verbose_name_plural": "historical Subject Screening",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "screening_identifier",
                    models.CharField(editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            (
                                "dont_want_blood_drawn",
                                "I don't want to have the blood drawn",
                            ),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_screening.subjectscreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Refusal",
                "verbose_name_plural": "historical Subject Refusals",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPatientLog",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "patient_log_identifier",
                    models.CharField(db_index=True, default=uuid.uuid4, max_length=36),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        help_text="Auto populated when screening form is complete",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "screening_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="Auto populated when screening form is complete",
                        null=True,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        blank=True,
                        help_text="Auto populated when consent form is complete",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "consent_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="Auto populated when consent form is complete",
                        null=True,
                    ),
                ),
                (
                    "name",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                (
                    "hf_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text="Must be unique (Encryption: RSA local)",
                        max_length=71,
                        verbose_name="Health facility identifier",
                    ),
                ),
                (
                    "contact_number",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="If unknown, type 'UNKNOWN' (Encryption: RSA local)",
                        max_length=71,
                        validators=[edc_model.validators.phone.phone_number],
                    ),
                ),
                (
                    "alt_contact_number",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        null=True,
                        validators=[edc_model.validators.phone.phone_number],
                    ),
                ),
                (
                    "may_contact",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Has the patient agreed to be contacted prior to consent?",
                    ),
                ),
                (
                    "location_description",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text="Street, landmarks near home, etc (Encryption: AES local)",
                        max_length=71,
                        null=True,
                    ),
                ),
                (
                    "stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="Refer to the SOP for the definition of 'stable'.",
                        max_length=15,
                        verbose_name="Do the facility health care staff consider the patient stable in care",
                    ),
                ),
                (
                    "last_routine_appt_date",
                    models.DateField(
                        blank=True,
                        help_text="If known, the last appointment may help to estimate the next appointment or the expected frequency of routine appointments",
                        null=True,
                        verbose_name="When was the patient last seen at this health facility",
                    ),
                ),
                (
                    "next_routine_appt_date",
                    models.DateField(
                        help_text="This date will help prioritize efforts to contact the patient",
                        verbose_name="Next scheduled routine appointment at this health facility",
                    ),
                ),
                (
                    "first_health_talk",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Attended general health talk",
                    ),
                ),
                (
                    "first_health_talk_date",
                    models.DateField(blank=True, null=True, verbose_name="General talk date"),
                ),
                (
                    "second_health_talk",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        max_length=15,
                        verbose_name="Attended sensitisation session",
                    ),
                ),
                (
                    "second_health_talk_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Sensitisation session date"
                    ),
                ),
                (
                    "call_attempts",
                    models.IntegerField(blank=True, default=0, help_text="auto-updated"),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "patient_group",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="This can be changed at anytime until the group is flagged as COMPLETE. It is recommended to choose a group early in the process.",
                        limit_choices_to={
                            "randomized": False,
                            "status__in": ["New", "recruiting"],
                        },
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_screening.patientgroup",
                        verbose_name="Choose a group (RECOMMENDED)",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                        verbose_name="Health facility",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical patient log",
                "verbose_name_plural": "historical patient logs",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPatientCall",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                (
                    "answered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                (
                    "respondent",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            ("family", "Family"),
                            ("friend", "friend"),
                            ("other", "other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                    ),
                ),
                (
                    "willing_to_attend",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_sure", "Not sure"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                    ),
                ),
                (
                    "attend_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When can the patient come to the clinic",
                    ),
                ),
                (
                    "call_again",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Call again?",
                    ),
                ),
                (
                    "comment",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text=" (Encryption: AES local)",
                        max_length=71,
                        null=True,
                        verbose_name="Note",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "patient_log",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_screening.patientlog",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Patient Call",
                "verbose_name_plural": "historical Patient Calls",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthTalkLog",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "health_facility_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "health_talk_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("report_date", models.DateField()),
                (
                    "number_attended",
                    models.IntegerField(verbose_name="Approximate number attended"),
                ),
                ("notes", models.TextField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "health_facility",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_screening.healthfacility",
                        verbose_name="Health facility",
                    ),
                ),
                (
                    "health_facility_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_lists.healthfacilitytypes",
                        verbose_name="Health facility type",
                    ),
                ),
                (
                    "health_talk_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_lists.healthtalktypes",
                        verbose_name="Type of talk",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Health talk log",
                "verbose_name_plural": "historical Health talk logs",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthFacility",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                ("name", models.CharField(db_index=True, max_length=25)),
                (
                    "health_facility_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "distance",
                    models.IntegerField(
                        help_text="In km. If within the health center type '0'",
                        verbose_name="Approximate distance from health center",
                    ),
                ),
                (
                    "gps",
                    models.CharField(
                        blank=True,
                        help_text="copy and paste directly from google maps",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "latitude",
                    models.FloatField(
                        blank=True,
                        help_text="in degrees. copy and paste directly from google maps",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-90),
                            django.core.validators.MaxValueValidator(90),
                        ],
                    ),
                ),
                (
                    "longitude",
                    models.FloatField(
                        blank=True,
                        help_text="in degrees. copy and paste directly from google maps",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-180),
                            django.core.validators.MaxValueValidator(180),
                        ],
                    ),
                ),
                ("notes", models.TextField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "health_facility_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_lists.healthfacilitytypes",
                        verbose_name="Health facility type",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Health Facility",
                "verbose_name_plural": "historical Health Facilities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HealthTalkLog",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "health_facility_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "health_talk_type_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("report_date", models.DateField()),
                (
                    "number_attended",
                    models.IntegerField(verbose_name="Approximate number attended"),
                ),
                ("notes", models.TextField(blank=True, null=True)),
                (
                    "health_facility",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_screening.healthfacility",
                        verbose_name="Health facility",
                    ),
                ),
                (
                    "health_facility_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.healthfacilitytypes",
                        verbose_name="Health facility type",
                    ),
                ),
                (
                    "health_talk_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.healthtalktypes",
                        verbose_name="Type of talk",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health talk log",
                "verbose_name_plural": "Health talk logs",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                ("objects", intecomm_screening.models.health_talk_log.Manager()),
            ],
        ),
        migrations.AddConstraint(
            model_name="healthtalklog",
            constraint=models.UniqueConstraint(
                models.OrderBy(
                    django.db.models.functions.text.Lower("health_facility"),
                    descending=True,
                ),
                name="unique_lower_name_report_date",
            ),
        ),
    ]
