# Generated by Django 4.2.1 on 2023-07-05 02:29
from django.db import migrations
from django.db.migrations import RunPython
from tqdm import tqdm


def update_patient_log_identifier(apps, schema_editor):
    subjectscreening_cls = apps.get_model("intecomm_screening.subjectscreening")
    historical_cls = apps.get_model("intecomm_screening.historicalsubjectscreening")
    qs = subjectscreening_cls.objects.all()
    for subjectscreening in tqdm(qs, total=qs.count()):
        for obj in historical_cls.objects.filter(
            screening_identifier=subjectscreening.screening_identifier
        ):
            obj.patient_log_identifier = subjectscreening.patient_log.patient_log_identifier
            obj.save_base(update_fields="patient_log_identifier")


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_screening", "0042_alter_healthfacility_options_and_more"),
    ]

    operations = [RunPython(update_patient_log_identifier)]
