from edc_constants.constants import NO, NOT_APPLICABLE, YES
from edc_he.rule_groups import HealthEconomicsRuleGroup as BaseHealthEconomicsRuleGroup
from edc_metadata import NOT_REQUIRED, REQUIRED
from edc_metadata.metadata_rules import CrfRule, CrfRuleGroup, P, register

from .predicates import HealthEconomicsPredicates


@register()
class ClinicalReviewBaselineRuleGroup(CrfRuleGroup):
    hiv = CrfRule(
        predicate=P("hiv_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["hivinitialreview"],
    )

    diabetes = CrfRule(
        predicate=P("dm_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["dminitialreview"],
    )

    hypertension = CrfRule(
        predicate=P("htn_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["htninitialreview"],
    )

    class Meta:
        app_label = "intecomm_subject"
        source_model = "intecomm_subject.clinicalreviewbaseline"


@register()
class ClinicalReviewRuleGroup(CrfRuleGroup):
    hiv_initial = CrfRule(
        predicate=P("hiv_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["hivinitialreview"],
    )

    dm_initial = CrfRule(
        predicate=P("dm_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["dminitialreview"],
    )

    htn_initial = CrfRule(
        predicate=P("htn_dx", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["htninitialreview"],
    )

    hiv_review = CrfRule(
        predicate=P("hiv_test", "eq", NOT_APPLICABLE),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["hivreview"],
    )

    dm_review = CrfRule(
        predicate=P("dm_test", "eq", NOT_APPLICABLE),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["dmreview"],
    )

    htn_review = CrfRule(
        predicate=P("htn_test", "eq", NOT_APPLICABLE),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["htnreview"],
    )

    complications = CrfRule(
        predicate=P("complications", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["complicationsfollowup"],
    )

    class Meta:
        app_label = "intecomm_subject"
        source_model = "intecomm_subject.clinicalreview"


@register()
class MedicationsRuleGroup(CrfRuleGroup):
    refill_hiv = CrfRule(
        predicate=P("refill_hiv", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["drugrefillhiv"],
    )

    refill_dm = CrfRule(
        predicate=P("refill_dm", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["drugrefilldm"],
    )

    refill_htn = CrfRule(
        predicate=P("refill_htn", "eq", YES),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["drugrefillhtn"],
    )

    adherence_hiv = CrfRule(
        predicate=P("refill_hiv", "in", [YES, NO]),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["hivmedicationadherence"],
    )

    adherence_dm = CrfRule(
        predicate=P("refill_dm", "in", [YES, NO]),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["dmmedicationadherence"],
    )

    adherence_htn = CrfRule(
        predicate=P("refill_htn", "in", [YES, NO]),
        consequence=REQUIRED,
        alternative=NOT_REQUIRED,
        target_models=["htnmedicationadherence"],
    )

    class Meta:
        app_label = "intecomm_subject"
        source_model = "intecomm_subject.medications"


@register()
class HealthEconomicsRuleGroup(BaseHealthEconomicsRuleGroup):
    class Meta:
        app_label = "intecomm_subject"
        source_model = "intecomm_subject.subjectvisit"
        predicates = HealthEconomicsPredicates()
