# Generated by Django 4.2.1 on 2023-05-23 21:52

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("edc_he", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("intecomm_subject", "0040_alter_historicalhivmedicationadherence_options_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalHealthEconomicsProperty",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        db_index=True,
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "land_owner",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Do you own any land or other property.",
                    ),
                ),
                (
                    "land_value_known",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Use cash equivalent in local currency",
                        max_length=25,
                        null=True,
                        verbose_name="Do you know about how much is this worth in total?",
                    ),
                ),
                (
                    "land_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Use cash equivalent in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is this worth in total?",
                    ),
                ),
                (
                    "land_additional",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Do you own any other property other than your primary dwelling?",
                    ),
                ),
                (
                    "land_additional_known",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Use cash equivalent in local currency",
                        max_length=25,
                        null=True,
                        verbose_name="Do you know about how much is this worth in total?",
                    ),
                ),
                (
                    "land_additional_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Use cash equivalent in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is this worth in total?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HE Baseline: Property",
                "verbose_name_plural": "historical HE Baseline: Property",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomicsPatient",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        db_index=True,
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "pat_citizen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the household head a Ugandan national?",
                    ),
                ),
                (
                    "pat_religion",
                    models.CharField(
                        choices=[
                            ("Catholic", "Catholic"),
                            ("Protestant", "Protestant"),
                            ("Muslim", "Muslim"),
                            ("Pentecostal", "Pentecostal"),
                            ("Seventh day Adventist", "Seventh day Adventist"),
                            ("No religion", "No religion"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="How would you describe your religious orientation?",
                    ),
                ),
                (
                    "pat_ethnicity",
                    models.CharField(
                        choices=[
                            ("baganda", "Baganda"),
                            ("banyakole", "Banyakole"),
                            ("basoga", "Basoga"),
                            ("bakiga", "Bakiga"),
                            ("iteso", "Iteso"),
                            ("langi", "Langi"),
                            ("acholi", "Acholi"),
                            ("bagisu", "Bagisu"),
                            ("lugbara", "Lugbara"),
                            ("banyoro", "Banyoro"),
                            ("bakhonzo", "Bakhonzo"),
                            ("batoro", "Batoro"),
                            ("alur", "Alur"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is your ethnic background?",
                    ),
                ),
                (
                    "pat_education",
                    models.CharField(
                        choices=[
                            ("illiterate", "Illiterate"),
                            ("primary_incomplete", "Primary incomplete"),
                            ("primary_complete", "Primary complete"),
                            ("secondary_incomplete", "Secondary incomplete"),
                            ("secondary_complete", "Secondary complete"),
                            (
                                "tertiary",
                                "University/college/post-secondary (diploma or certificate)/ technical training",
                            ),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Highest level of education completed?",
                    ),
                ),
                (
                    "pat_employment",
                    models.CharField(
                        choices=[
                            ("1", "1. Full time employed"),
                            ("2", "2. Regular part time employed "),
                            ("3", "3. Irregular/ occasional/ day worker employment"),
                            ("4", "4. Non-paid/ voluntary role "),
                            ("5", "5. Student"),
                            ("6", "6. Homemaker"),
                            ("7", "7. Unemployed (able to work)"),
                            ("8", "8. Unemployed (unable to work)"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="What is your employment status?",
                    ),
                ),
                (
                    "pat_employment_type",
                    models.CharField(
                        choices=[
                            ("1", "1. Legislators, administrators, and managers"),
                            ("2", "2. Professionals"),
                            ("3", "3. Technicians and associate professionals"),
                            ("4", "4. Clerks"),
                            ("5", "5. Service workers and shop sale workers"),
                            ("6", "6. Skilled agricultural and fishery workers"),
                            ("7", "7. Unskilled agricultural and fishery workers"),
                            ("8", "8. Craft and related workers"),
                            ("9", "9. Plant and machine operators and assemblers"),
                            ("10", "10. Elementary occupations"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="What is your type of employment?",
                    ),
                ),
                (
                    "pat_marital_status",
                    models.CharField(
                        choices=[
                            ("1", "1. Never Married (but not co-habiting)"),
                            ("2", "2. Co-habiting"),
                            ("3", "3. Currently Married"),
                            ("4", "4. Separated/Divorced"),
                            ("5", "5. Widowed"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="What is your marital status?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HE Baseline: Patient",
                "verbose_name_plural": "historical HE Baseline: Patient",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomicsIncome",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        db_index=True,
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "wages",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Wages, salary from job",
                    ),
                ),
                (
                    "wages_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "wages_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Wages, salary from job",
                    ),
                ),
                (
                    "selling",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Earnings from selling, trading or hawking products?",
                    ),
                ),
                (
                    "selling_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "selling_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Earnings from selling, trading or hawking products?",
                    ),
                ),
                (
                    "rental_income",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Income from rental of property?",
                    ),
                ),
                (
                    "rental_income_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "rental_income_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Income from rental of property?",
                    ),
                ),
                (
                    "pension",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Pensions by work",
                        max_length=15,
                        verbose_name="State old-age (veteran's/civil service) pension*, contributory pension fund, provident fund or social security benefit?",
                    ),
                ),
                (
                    "pension_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "pension_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="State old-age (veteran's/civil service) pension*, contributory pension fund, provident fund or social security benefit?",
                    ),
                ),
                (
                    "ngo_assistance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Assistance from nongovernmental organization",
                    ),
                ),
                (
                    "ngo_assistance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "ngo_assistance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Assistance from nongovernmental organization",
                    ),
                ),
                (
                    "interest",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="(for example, from savings account or fixed deposits)?",
                        max_length=15,
                        verbose_name="Interest, dividends",
                    ),
                ),
                (
                    "interest_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "interest_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Interest, dividends",
                    ),
                ),
                (
                    "internal_remittance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Money transfers from family members or friends residing inside the country",
                    ),
                ),
                (
                    "internal_remittance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "internal_remittance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Money transfers from family members or friends residing inside the country",
                    ),
                ),
                (
                    "external_remittance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Money transfers from family members or friends residing outside the country",
                    ),
                ),
                (
                    "external_remittance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "external_remittance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Money transfers from family members or friends residing outside the country",
                    ),
                ),
                (
                    "more_sources",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Other sources ...",
                    ),
                ),
                (
                    "more_sources_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "more_sources_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Other sources ...",
                    ),
                ),
                (
                    "external_remittance_currency",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="In what currency do you receive remittances?",
                    ),
                ),
                (
                    "external_remittance_currency_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER currency, specify ...",
                    ),
                ),
                (
                    "more_sources_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER sources, specify ...",
                    ),
                ),
                (
                    "external_dependents",
                    models.IntegerField(
                        help_text="Insert '0' if no dependents other than the members in the household roster",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(15),
                        ],
                        verbose_name="Outside of this household, how many other people depend on this household’s income?",
                    ),
                ),
                (
                    "income_enough",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("Dont_know", "Do not know")],
                        max_length=15,
                        verbose_name="Thinking about the income for this household, do you believe that it is enough money to cover your daily living needs and obligations?",
                    ),
                ),
                (
                    "financial_status",
                    models.CharField(
                        choices=[
                            ("1", "Very good"),
                            ("2", "Good"),
                            ("3", "Moderate"),
                            ("4", "Bad"),
                            ("5", "Very bad"),
                        ],
                        max_length=25,
                        verbose_name="Would you say your household's financial situation is?",
                    ),
                ),
                (
                    "financial_status_compare",
                    models.CharField(
                        choices=[
                            ("1", "Among most wealthy"),
                            ("2", "Above average "),
                            ("3", "Average wealth"),
                            ("4", "Below average"),
                            ("5", "Among least wealthy"),
                        ],
                        max_length=25,
                        verbose_name="How would you rate your household’s financial situation compared with others in your community?",
                    ),
                ),
                (
                    "household_debt",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Does your household or any members of the household have current debt or outstanding loans?",
                    ),
                ),
                (
                    "household_debt_value",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="What is the approximate total amount of this debt or loan(s)?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HE Baseline: Income",
                "verbose_name_plural": "historical HE Baseline: Income",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomicsHouseholdHead",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        db_index=True,
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "hoh",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Note: By head of the household we mean the main decision maker in the household. The head can be either male or female. If two people are equal decision-makers, take the older person. [Q1]",
                        max_length=15,
                        verbose_name="Are you the household head?",
                    ),
                ),
                (
                    "relationship_to_hoh",
                    models.CharField(
                        choices=[
                            ("WIFE_HUSBAND", "Wife/Husband"),
                            ("SON_DAUGHTER", "Son/Daughter"),
                            ("SON_DAUGHTERINLAW", "Son/Daughter-in-law"),
                            ("GRANDCHILD", "Grandchild"),
                            ("PARENT", "Parent"),
                            ("PARENTINLAW", "Parent-in-law"),
                            ("BROTHER_SISTER", "Brother/Sister"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="[Q1A]",
                        max_length=25,
                        verbose_name="What is your relationship to the household head?",
                    ),
                ),
                (
                    "hoh_gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female")],
                        help_text="[Q1B]",
                        max_length=15,
                        verbose_name="Is the household head female or male?",
                    ),
                ),
                (
                    "hoh_age",
                    models.IntegerField(
                        help_text="In years. [Q1C]",
                        validators=[
                            django.core.validators.MinValueValidator(18),
                            django.core.validators.MaxValueValidator(110),
                        ],
                        verbose_name="How old is the household head?",
                    ),
                ),
                (
                    "hoh_citizen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the household head a Ugandan national?",
                    ),
                ),
                (
                    "hoh_religion",
                    models.CharField(
                        choices=[
                            ("Catholic", "Catholic"),
                            ("Protestant", "Protestant"),
                            ("Muslim", "Muslim"),
                            ("Pentecostal", "Pentecostal"),
                            ("Seventh day Adventist", "Seventh day Adventist"),
                            ("No religion", "No religion"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="How would you describe the household head’s religious orientation?",
                    ),
                ),
                (
                    "hoh_ethnicity",
                    models.CharField(
                        choices=[
                            ("baganda", "Baganda"),
                            ("banyakole", "Banyakole"),
                            ("basoga", "Basoga"),
                            ("bakiga", "Bakiga"),
                            ("iteso", "Iteso"),
                            ("langi", "Langi"),
                            ("acholi", "Acholi"),
                            ("bagisu", "Bagisu"),
                            ("lugbara", "Lugbara"),
                            ("banyoro", "Banyoro"),
                            ("bakhonzo", "Bakhonzo"),
                            ("batoro", "Batoro"),
                            ("alur", "Alur"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the household head’s ethnic background?",
                    ),
                ),
                (
                    "hoh_education",
                    models.CharField(
                        choices=[
                            ("illiterate", "Illiterate"),
                            ("primary_incomplete", "Primary incomplete"),
                            ("primary_complete", "Primary complete"),
                            ("secondary_incomplete", "Secondary incomplete"),
                            ("secondary_complete", "Secondary complete"),
                            (
                                "tertiary",
                                "University/college/post-secondary (diploma or certificate)/ technical training",
                            ),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Highest level of education completed by the household head?",
                    ),
                ),
                (
                    "hoh_employment",
                    models.CharField(
                        choices=[
                            ("1", "1. Full time employed"),
                            ("2", "2. Regular part time employed "),
                            ("3", "3. Irregular/ occasional/ day worker employment"),
                            ("4", "4. Non-paid/ voluntary role "),
                            ("5", "5. Student"),
                            ("6", "6. Homemaker"),
                            ("7", "7. Unemployed (able to work)"),
                            ("8", "8. Unemployed (unable to work)"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s employment status",
                    ),
                ),
                (
                    "hoh_employment_type",
                    models.CharField(
                        choices=[
                            ("1", "1. Legislators, administrators, and managers"),
                            ("2", "2. Professionals"),
                            ("3", "3. Technicians and associate professionals"),
                            ("4", "4. Clerks"),
                            ("5", "5. Service workers and shop sale workers"),
                            ("6", "6. Skilled agricultural and fishery workers"),
                            ("7", "7. Unskilled agricultural and fishery workers"),
                            ("8", "8. Craft and related workers"),
                            ("9", "9. Plant and machine operators and assemblers"),
                            ("10", "10. Elementary occupations"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s type of employment",
                    ),
                ),
                (
                    "hoh_marital_status",
                    models.CharField(
                        choices=[
                            ("1", "1. Never Married (but not co-habiting)"),
                            ("2", "2. Co-habiting"),
                            ("3", "3. Currently Married"),
                            ("4", "4. Separated/Divorced"),
                            ("5", "5. Widowed"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s marital status",
                    ),
                ),
                (
                    "hh_count",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="What is the total number of people who live in your household?",
                    ),
                ),
                (
                    "hh_minors_count",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="What is the total number of people 14 years or under who live in your household?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HE Baseline: Household head",
                "verbose_name_plural": "historical HE Baseline: Household head",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomicsAssets",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        db_index=True,
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "residence_ownership",
                    models.CharField(
                        choices=[
                            ("renter", "1. Rent"),
                            ("owner", "2. Own themselves"),
                            ("family_owned", "3. Owned by someone else in family"),
                            (
                                "nonfamily_owned",
                                "4. Owned by someone else other than family member",
                            ),
                            ("joint_owned", "5. Owned together with someone"),
                        ],
                        max_length=25,
                        verbose_name="Is the house you live in rented, owned by you (either on your own, or with someone else), or owned by someone else in your family?",
                    ),
                ),
                (
                    "dwelling_value_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="in local currency",
                        max_length=25,
                        verbose_name="If the owner [you] were to sell this dwelling today, do you know the approximate value?",
                    ),
                ),
                (
                    "dwelling_value",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is it worth?",
                    ),
                ),
                (
                    "rooms",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(20),
                        ],
                        verbose_name="How many rooms does your dwelling have in total, without counting the bathrooms/ toilets or hallways/passageways?",
                    ),
                ),
                (
                    "bedrooms",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How many rooms are used for sleeping in your dwelling?",
                    ),
                ),
                (
                    "beds",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How many beds does your dwelling have in total?",
                    ),
                ),
                (
                    "water_source",
                    models.CharField(
                        choices=[
                            ("piped_into_plot", "Piped into dwelling/yard plot"),
                            ("piped_to_neighbour", "Piped to neighbour"),
                            ("standpipe", "Public tap/standpipe"),
                            ("borehole", "Tube well or borehole"),
                            ("protected_well", "Protected dug well"),
                            ("protected_spring", "Protected spring"),
                            ("rainwater", "Rainwater"),
                            (
                                "bottled_water_improved",
                                "Bottled water, improved source for cooking/hand washing (1-7)",
                            ),
                            ("unprotected_well", "Unprotected dug well"),
                            ("unprotected_spring", "Unprotected spring"),
                            ("tanker", "Tanker truck/cart with small tank"),
                            ("surface_water", "Surface water (river etc.)"),
                            (
                                "bottled_water_unimproved",
                                "Bottle water, unimproved source for cooking/hand washing (9-12)",
                            ),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="in local currency",
                        max_length=25,
                        verbose_name="What is the main source of drinking water for the household?",
                    ),
                ),
                (
                    "water_obtain_time",
                    models.CharField(
                        choices=[
                            (
                                "on_premises",
                                "Water on premises (includes water piped to a neighbour)",
                            ),
                            ("less_30min", "Less than 30 minutes"),
                            ("greater_30min", "30 minutes or longer"),
                            ("dont_know", "Don’t know"),
                        ],
                        max_length=25,
                        verbose_name="How long does it take to obtain drinking water?",
                    ),
                ),
                (
                    "toilet",
                    models.CharField(
                        choices=[
                            ("1", "1. Flush/pour flush to piped sewer system – private"),
                            ("2", "2. Flush/pour flush to septic tank – private "),
                            ("3", "3. Flush/pour flush to pit latrine – private"),
                            ("4", "4. Ventilated improved pit (VIP) latrine – private "),
                            ("5", "5. Pit latrine with slab – private"),
                            ("6", "6. Composting toilet – private"),
                            ("7", "7. EcoSan – private"),
                            ("8", "8. Flush/pour flush to piped sewer system – shared"),
                            ("9", "9. Flush/pour flush to septic tank – shared"),
                            ("10", "10. Flush/pour flush to pit latrine – shared"),
                            ("11", "11. Ventilated improved pit (VIP) latrine – shared"),
                            ("12", "12. Pit latrine with slab – shared"),
                            ("13", "13. Composting toilet – shared"),
                            ("14", "14. EcoSan – shared"),
                            (
                                "15",
                                "15. Flush/pour flush not to sewer/septic tank/pit latrine",
                            ),
                            ("16", "16. Pit latrine with slab (non-washable)"),
                            ("17", "17. Pit latrine without slab/open pit"),
                            ("18", "18. Bucket"),
                            ("19", "19. Hanging toilet/hanging latrine"),
                            ("20", "20. Open defecation (no facility/bush/field)"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="Note: 'private' (1-7) is a toilet solely used by the household and 'shared' (8-14) is a toilet shared by two or more households.",
                        max_length=25,
                        verbose_name="What type of toilet is mainly used in your household?",
                    ),
                ),
                (
                    "roof_material",
                    models.CharField(
                        choices=[
                            ("1", "Thatch, Straw"),
                            ("2", "Mud and poles"),
                            ("3", "Tin"),
                            ("4", "Wood"),
                            ("5", "Iron sheet"),
                            ("6", "Tiles "),
                            ("7", "Cement"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the major construction material of the roof?",
                    ),
                ),
                (
                    "eaves",
                    models.CharField(
                        choices=[
                            ("1", "All eaves closed"),
                            ("2", "All eaves open"),
                            ("3", "Partially closed"),
                        ],
                        max_length=25,
                        verbose_name="Are the eaves open, partially or fully closed?",
                    ),
                ),
                (
                    "external_wall_material",
                    models.CharField(
                        choices=[
                            ("1", "Thatch, Straw"),
                            ("2", "Mud and poles"),
                            ("3", "Timber"),
                            ("4", "Un-burnt bricks"),
                            ("5", "Burnt bricks with mud"),
                            ("6", "Burnt bricks with cement"),
                            ("7", "Cement blocks"),
                            ("8", "Stone"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the major construction material of the external wall?",
                    ),
                ),
                (
                    "external_wall_material_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER construction material, specify",
                    ),
                ),
                (
                    "external_window_material",
                    models.CharField(
                        choices=[
                            ("1", "Glass"),
                            ("2", "Bags"),
                            ("3", "Wood"),
                            ("4", "Iron/metal"),
                            ("5", "Screens"),
                            ("6", "No windows"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the main material on external windows?",
                    ),
                ),
                (
                    "external_window_material_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER main material, specify",
                    ),
                ),
                (
                    "window_screens",
                    models.CharField(
                        choices=[
                            ("1", "All windows screened"),
                            ("2", "No windows screened"),
                            ("3", "Some windows screened"),
                        ],
                        max_length=25,
                        verbose_name="What is the main screening material of external windows?",
                    ),
                ),
                (
                    "window_screen_type",
                    models.CharField(
                        choices=[
                            ("1", "Wire mesh"),
                            ("2", "Old bednet"),
                            ("3", "No windows screened"),
                            ("4", "No windows"),
                        ],
                        max_length=25,
                        verbose_name="Type of screening on external windows",
                    ),
                ),
                (
                    "floor_material",
                    models.CharField(
                        choices=[
                            ("6", "Earth, sand"),
                            ("7", "Dung, wood, planks, palm, bamboo"),
                            ("8", "Parquet, polished wood, vinyl, asphalt strips"),
                            ("9", "Ceramic tiles"),
                            ("10", "Cement"),
                            ("11", "Carpet"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="If there are similar amounts of more than one type of flooring, select the multiple types that apply. Otherwise select the main type of flooring",
                        max_length=25,
                        verbose_name="What is the major construction material of the floor?",
                    ),
                ),
                (
                    "electricity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does your household have electricity?",
                    ),
                ),
                (
                    "lighting_source",
                    models.CharField(
                        choices=[
                            ("1", "Electricity (e.g., hydroelectric or solar)"),
                            ("2", "Paraffin, kerosene or gas lantern "),
                            ("3", "Firewood"),
                            ("4", "Candle"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of lighting?",
                    ),
                ),
                (
                    "cooking_fuel",
                    models.CharField(
                        choices=[
                            ("1", "Electricity"),
                            ("2", "LPG/natural gas/biogas"),
                            ("3", "Kerosene"),
                            ("4", "Charcoal"),
                            ("5", "Wood"),
                            (
                                "6",
                                "Coal/lignite, straw/shrubs/grass. agricultural crop, animal dung",
                            ),
                            ("7", "No food cooked in the household"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What type of fuel do you primarily use for cooking?",
                    ),
                ),
                (
                    "radio",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Radio",
                    ),
                ),
                (
                    "television",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Television",
                    ),
                ),
                (
                    "mobile_phone",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Mobile phone",
                    ),
                ),
                (
                    "computer",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Computer",
                    ),
                ),
                (
                    "telephone",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Non-mobile telephone",
                    ),
                ),
                (
                    "fridge",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Fridge",
                    ),
                ),
                (
                    "generator",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Generator",
                    ),
                ),
                (
                    "iron",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Iron",
                    ),
                ),
                (
                    "bicycle",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Bicycle",
                    ),
                ),
                (
                    "motorcycle",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Motorcycle/scooter (PikiPiki/Boda Boda)",
                    ),
                ),
                (
                    "dala_dala",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Dala Dala",
                    ),
                ),
                (
                    "car",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Car",
                    ),
                ),
                (
                    "motorboat",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Boat with a motor",
                    ),
                ),
                (
                    "large_livestock",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Large Livestock (e.g. cows, bulls, other cattle, horses, donkeys)",
                    ),
                ),
                (
                    "small_animals",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Small animals (goats, sheep, chickens or other poultry, etc)",
                    ),
                ),
                (
                    "shop",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="A business or shop",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HE Baseline: Assets",
                "verbose_name_plural": "historical HE Baseline: Assets",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HealthEconomicsProperty",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        unique=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "land_owner",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Do you own any land or other property.",
                    ),
                ),
                (
                    "land_value_known",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Use cash equivalent in local currency",
                        max_length=25,
                        null=True,
                        verbose_name="Do you know about how much is this worth in total?",
                    ),
                ),
                (
                    "land_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Use cash equivalent in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is this worth in total?",
                    ),
                ),
                (
                    "land_additional",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Do you own any other property other than your primary dwelling?",
                    ),
                ),
                (
                    "land_additional_known",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Use cash equivalent in local currency",
                        max_length=25,
                        null=True,
                        verbose_name="Do you know about how much is this worth in total?",
                    ),
                ),
                (
                    "land_additional_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Use cash equivalent in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is this worth in total?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HE Baseline: Property",
                "verbose_name_plural": "HE Baseline: Property",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="intecomm_su_subject_46df27_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="intecomm_su_subject_084dec_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HealthEconomicsPatient",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        unique=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "pat_citizen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the household head a Ugandan national?",
                    ),
                ),
                (
                    "pat_religion",
                    models.CharField(
                        choices=[
                            ("Catholic", "Catholic"),
                            ("Protestant", "Protestant"),
                            ("Muslim", "Muslim"),
                            ("Pentecostal", "Pentecostal"),
                            ("Seventh day Adventist", "Seventh day Adventist"),
                            ("No religion", "No religion"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="How would you describe your religious orientation?",
                    ),
                ),
                (
                    "pat_ethnicity",
                    models.CharField(
                        choices=[
                            ("baganda", "Baganda"),
                            ("banyakole", "Banyakole"),
                            ("basoga", "Basoga"),
                            ("bakiga", "Bakiga"),
                            ("iteso", "Iteso"),
                            ("langi", "Langi"),
                            ("acholi", "Acholi"),
                            ("bagisu", "Bagisu"),
                            ("lugbara", "Lugbara"),
                            ("banyoro", "Banyoro"),
                            ("bakhonzo", "Bakhonzo"),
                            ("batoro", "Batoro"),
                            ("alur", "Alur"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is your ethnic background?",
                    ),
                ),
                (
                    "pat_education",
                    models.CharField(
                        choices=[
                            ("illiterate", "Illiterate"),
                            ("primary_incomplete", "Primary incomplete"),
                            ("primary_complete", "Primary complete"),
                            ("secondary_incomplete", "Secondary incomplete"),
                            ("secondary_complete", "Secondary complete"),
                            (
                                "tertiary",
                                "University/college/post-secondary (diploma or certificate)/ technical training",
                            ),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Highest level of education completed?",
                    ),
                ),
                (
                    "pat_employment",
                    models.CharField(
                        choices=[
                            ("1", "1. Full time employed"),
                            ("2", "2. Regular part time employed "),
                            ("3", "3. Irregular/ occasional/ day worker employment"),
                            ("4", "4. Non-paid/ voluntary role "),
                            ("5", "5. Student"),
                            ("6", "6. Homemaker"),
                            ("7", "7. Unemployed (able to work)"),
                            ("8", "8. Unemployed (unable to work)"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="What is your employment status?",
                    ),
                ),
                (
                    "pat_employment_type",
                    models.CharField(
                        choices=[
                            ("1", "1. Legislators, administrators, and managers"),
                            ("2", "2. Professionals"),
                            ("3", "3. Technicians and associate professionals"),
                            ("4", "4. Clerks"),
                            ("5", "5. Service workers and shop sale workers"),
                            ("6", "6. Skilled agricultural and fishery workers"),
                            ("7", "7. Unskilled agricultural and fishery workers"),
                            ("8", "8. Craft and related workers"),
                            ("9", "9. Plant and machine operators and assemblers"),
                            ("10", "10. Elementary occupations"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="What is your type of employment?",
                    ),
                ),
                (
                    "pat_marital_status",
                    models.CharField(
                        choices=[
                            ("1", "1. Never Married (but not co-habiting)"),
                            ("2", "2. Co-habiting"),
                            ("3", "3. Currently Married"),
                            ("4", "4. Separated/Divorced"),
                            ("5", "5. Widowed"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="What is your marital status?",
                    ),
                ),
                (
                    "pat_insurance",
                    models.ManyToManyField(
                        related_name="patinsurancetypes",
                        to="edc_he.insurancetypes",
                        verbose_name="What is your health insurance status?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HE Baseline: Patient",
                "verbose_name_plural": "HE Baseline: Patient",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="intecomm_su_subject_9f534c_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="intecomm_su_subject_a96e28_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HealthEconomicsIncome",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        unique=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "wages",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Wages, salary from job",
                    ),
                ),
                (
                    "wages_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "wages_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Wages, salary from job",
                    ),
                ),
                (
                    "selling",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Earnings from selling, trading or hawking products?",
                    ),
                ),
                (
                    "selling_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "selling_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Earnings from selling, trading or hawking products?",
                    ),
                ),
                (
                    "rental_income",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Income from rental of property?",
                    ),
                ),
                (
                    "rental_income_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "rental_income_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Income from rental of property?",
                    ),
                ),
                (
                    "pension",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="Pensions by work",
                        max_length=15,
                        verbose_name="State old-age (veteran's/civil service) pension*, contributory pension fund, provident fund or social security benefit?",
                    ),
                ),
                (
                    "pension_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "pension_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="State old-age (veteran's/civil service) pension*, contributory pension fund, provident fund or social security benefit?",
                    ),
                ),
                (
                    "ngo_assistance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Assistance from nongovernmental organization",
                    ),
                ),
                (
                    "ngo_assistance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "ngo_assistance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Assistance from nongovernmental organization",
                    ),
                ),
                (
                    "interest",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="(for example, from savings account or fixed deposits)?",
                        max_length=15,
                        verbose_name="Interest, dividends",
                    ),
                ),
                (
                    "interest_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "interest_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Interest, dividends",
                    ),
                ),
                (
                    "internal_remittance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Money transfers from family members or friends residing inside the country",
                    ),
                ),
                (
                    "internal_remittance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "internal_remittance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Money transfers from family members or friends residing inside the country",
                    ),
                ),
                (
                    "external_remittance",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Money transfers from family members or friends residing outside the country",
                    ),
                ),
                (
                    "external_remittance_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "external_remittance_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Money transfers from family members or friends residing outside the country",
                    ),
                ),
                (
                    "more_sources",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text=None,
                        max_length=15,
                        verbose_name="Other sources ...",
                    ),
                ),
                (
                    "more_sources_value_known",
                    models.CharField(
                        choices=[
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("yearly", "Yearly"),
                            ("dont_know", "Don’t know"),
                            ("DWTA", "Don’t want to answer"),
                        ],
                        max_length=15,
                        verbose_name="Estimate the total amount of income from this source for the household over the last ...",
                    ),
                ),
                (
                    "more_sources_value",
                    models.IntegerField(
                        blank=True,
                        help_text="Estimate the total amount of income from this source for the household over the time period indicated above",
                        null=True,
                        verbose_name="Other sources ...",
                    ),
                ),
                (
                    "external_remittance_currency",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="In what currency do you receive remittances?",
                    ),
                ),
                (
                    "external_remittance_currency_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER currency, specify ...",
                    ),
                ),
                (
                    "more_sources_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER sources, specify ...",
                    ),
                ),
                (
                    "external_dependents",
                    models.IntegerField(
                        help_text="Insert '0' if no dependents other than the members in the household roster",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(15),
                        ],
                        verbose_name="Outside of this household, how many other people depend on this household’s income?",
                    ),
                ),
                (
                    "income_enough",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("Dont_know", "Do not know")],
                        max_length=15,
                        verbose_name="Thinking about the income for this household, do you believe that it is enough money to cover your daily living needs and obligations?",
                    ),
                ),
                (
                    "financial_status",
                    models.CharField(
                        choices=[
                            ("1", "Very good"),
                            ("2", "Good"),
                            ("3", "Moderate"),
                            ("4", "Bad"),
                            ("5", "Very bad"),
                        ],
                        max_length=25,
                        verbose_name="Would you say your household's financial situation is?",
                    ),
                ),
                (
                    "financial_status_compare",
                    models.CharField(
                        choices=[
                            ("1", "Among most wealthy"),
                            ("2", "Above average "),
                            ("3", "Average wealth"),
                            ("4", "Below average"),
                            ("5", "Among least wealthy"),
                        ],
                        max_length=25,
                        verbose_name="How would you rate your household’s financial situation compared with others in your community?",
                    ),
                ),
                (
                    "household_debt",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        max_length=25,
                        verbose_name="Does your household or any members of the household have current debt or outstanding loans?",
                    ),
                ),
                (
                    "household_debt_value",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="What is the approximate total amount of this debt or loan(s)?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HE Baseline: Income",
                "verbose_name_plural": "HE Baseline: Income",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="intecomm_su_subject_cd28df_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="intecomm_su_subject_af3996_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HealthEconomicsHouseholdHead",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        unique=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "hoh",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Note: By head of the household we mean the main decision maker in the household. The head can be either male or female. If two people are equal decision-makers, take the older person. [Q1]",
                        max_length=15,
                        verbose_name="Are you the household head?",
                    ),
                ),
                (
                    "relationship_to_hoh",
                    models.CharField(
                        choices=[
                            ("WIFE_HUSBAND", "Wife/Husband"),
                            ("SON_DAUGHTER", "Son/Daughter"),
                            ("SON_DAUGHTERINLAW", "Son/Daughter-in-law"),
                            ("GRANDCHILD", "Grandchild"),
                            ("PARENT", "Parent"),
                            ("PARENTINLAW", "Parent-in-law"),
                            ("BROTHER_SISTER", "Brother/Sister"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="[Q1A]",
                        max_length=25,
                        verbose_name="What is your relationship to the household head?",
                    ),
                ),
                (
                    "hoh_gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female")],
                        help_text="[Q1B]",
                        max_length=15,
                        verbose_name="Is the household head female or male?",
                    ),
                ),
                (
                    "hoh_age",
                    models.IntegerField(
                        help_text="In years. [Q1C]",
                        validators=[
                            django.core.validators.MinValueValidator(18),
                            django.core.validators.MaxValueValidator(110),
                        ],
                        verbose_name="How old is the household head?",
                    ),
                ),
                (
                    "hoh_citizen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the household head a Ugandan national?",
                    ),
                ),
                (
                    "hoh_religion",
                    models.CharField(
                        choices=[
                            ("Catholic", "Catholic"),
                            ("Protestant", "Protestant"),
                            ("Muslim", "Muslim"),
                            ("Pentecostal", "Pentecostal"),
                            ("Seventh day Adventist", "Seventh day Adventist"),
                            ("No religion", "No religion"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="How would you describe the household head’s religious orientation?",
                    ),
                ),
                (
                    "hoh_ethnicity",
                    models.CharField(
                        choices=[
                            ("baganda", "Baganda"),
                            ("banyakole", "Banyakole"),
                            ("basoga", "Basoga"),
                            ("bakiga", "Bakiga"),
                            ("iteso", "Iteso"),
                            ("langi", "Langi"),
                            ("acholi", "Acholi"),
                            ("bagisu", "Bagisu"),
                            ("lugbara", "Lugbara"),
                            ("banyoro", "Banyoro"),
                            ("bakhonzo", "Bakhonzo"),
                            ("batoro", "Batoro"),
                            ("alur", "Alur"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the household head’s ethnic background?",
                    ),
                ),
                (
                    "hoh_education",
                    models.CharField(
                        choices=[
                            ("illiterate", "Illiterate"),
                            ("primary_incomplete", "Primary incomplete"),
                            ("primary_complete", "Primary complete"),
                            ("secondary_incomplete", "Secondary incomplete"),
                            ("secondary_complete", "Secondary complete"),
                            (
                                "tertiary",
                                "University/college/post-secondary (diploma or certificate)/ technical training",
                            ),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Highest level of education completed by the household head?",
                    ),
                ),
                (
                    "hoh_employment",
                    models.CharField(
                        choices=[
                            ("1", "1. Full time employed"),
                            ("2", "2. Regular part time employed "),
                            ("3", "3. Irregular/ occasional/ day worker employment"),
                            ("4", "4. Non-paid/ voluntary role "),
                            ("5", "5. Student"),
                            ("6", "6. Homemaker"),
                            ("7", "7. Unemployed (able to work)"),
                            ("8", "8. Unemployed (unable to work)"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "Not applcable"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s employment status",
                    ),
                ),
                (
                    "hoh_employment_type",
                    models.CharField(
                        choices=[
                            ("1", "1. Legislators, administrators, and managers"),
                            ("2", "2. Professionals"),
                            ("3", "3. Technicians and associate professionals"),
                            ("4", "4. Clerks"),
                            ("5", "5. Service workers and shop sale workers"),
                            ("6", "6. Skilled agricultural and fishery workers"),
                            ("7", "7. Unskilled agricultural and fishery workers"),
                            ("8", "8. Craft and related workers"),
                            ("9", "9. Plant and machine operators and assemblers"),
                            ("10", "10. Elementary occupations"),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s type of employment",
                    ),
                ),
                (
                    "hoh_marital_status",
                    models.CharField(
                        choices=[
                            ("1", "1. Never Married (but not co-habiting)"),
                            ("2", "2. Co-habiting"),
                            ("3", "3. Currently Married"),
                            ("4", "4. Separated/Divorced"),
                            ("5", "5. Widowed"),
                            ("OTHER", "Other, specify ..."),
                            ("dont_know", "Don’t know"),
                            ("N/A", "NA"),
                        ],
                        max_length=25,
                        verbose_name="Household head’s marital status",
                    ),
                ),
                (
                    "hh_count",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="What is the total number of people who live in your household?",
                    ),
                ),
                (
                    "hh_minors_count",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="What is the total number of people 14 years or under who live in your household?",
                    ),
                ),
                (
                    "hoh_insurance",
                    models.ManyToManyField(
                        related_name="hohinsurancetypes",
                        to="edc_he.insurancetypes",
                        verbose_name="Household head’s health insurance and ‘club’ status ",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HE Baseline: Household head",
                "verbose_name_plural": "HE Baseline: Household head",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="intecomm_su_subject_70ec19_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="intecomm_su_subject_135ff3_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HealthEconomicsAssets",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "singleton_field",
                    models.CharField(
                        editable=False,
                        help_text="auto updated for unique constraint",
                        max_length=50,
                        null=True,
                        unique=True,
                        verbose_name="subject identifier",
                    ),
                ),
                (
                    "residence_ownership",
                    models.CharField(
                        choices=[
                            ("renter", "1. Rent"),
                            ("owner", "2. Own themselves"),
                            ("family_owned", "3. Owned by someone else in family"),
                            (
                                "nonfamily_owned",
                                "4. Owned by someone else other than family member",
                            ),
                            ("joint_owned", "5. Owned together with someone"),
                        ],
                        max_length=25,
                        verbose_name="Is the house you live in rented, owned by you (either on your own, or with someone else), or owned by someone else in your family?",
                    ),
                ),
                (
                    "dwelling_value_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("dont_know", "Do not know"),
                            ("DWTA", "Don't want to answer"),
                        ],
                        help_text="in local currency",
                        max_length=25,
                        verbose_name="If the owner [you] were to sell this dwelling today, do you know the approximate value?",
                    ),
                ),
                (
                    "dwelling_value",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999999),
                        ],
                        verbose_name="About how much is it worth?",
                    ),
                ),
                (
                    "rooms",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(20),
                        ],
                        verbose_name="How many rooms does your dwelling have in total, without counting the bathrooms/ toilets or hallways/passageways?",
                    ),
                ),
                (
                    "bedrooms",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How many rooms are used for sleeping in your dwelling?",
                    ),
                ),
                (
                    "beds",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How many beds does your dwelling have in total?",
                    ),
                ),
                (
                    "water_source",
                    models.CharField(
                        choices=[
                            ("piped_into_plot", "Piped into dwelling/yard plot"),
                            ("piped_to_neighbour", "Piped to neighbour"),
                            ("standpipe", "Public tap/standpipe"),
                            ("borehole", "Tube well or borehole"),
                            ("protected_well", "Protected dug well"),
                            ("protected_spring", "Protected spring"),
                            ("rainwater", "Rainwater"),
                            (
                                "bottled_water_improved",
                                "Bottled water, improved source for cooking/hand washing (1-7)",
                            ),
                            ("unprotected_well", "Unprotected dug well"),
                            ("unprotected_spring", "Unprotected spring"),
                            ("tanker", "Tanker truck/cart with small tank"),
                            ("surface_water", "Surface water (river etc.)"),
                            (
                                "bottled_water_unimproved",
                                "Bottle water, unimproved source for cooking/hand washing (9-12)",
                            ),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="in local currency",
                        max_length=25,
                        verbose_name="What is the main source of drinking water for the household?",
                    ),
                ),
                (
                    "water_obtain_time",
                    models.CharField(
                        choices=[
                            (
                                "on_premises",
                                "Water on premises (includes water piped to a neighbour)",
                            ),
                            ("less_30min", "Less than 30 minutes"),
                            ("greater_30min", "30 minutes or longer"),
                            ("dont_know", "Don’t know"),
                        ],
                        max_length=25,
                        verbose_name="How long does it take to obtain drinking water?",
                    ),
                ),
                (
                    "toilet",
                    models.CharField(
                        choices=[
                            ("1", "1. Flush/pour flush to piped sewer system – private"),
                            ("2", "2. Flush/pour flush to septic tank – private "),
                            ("3", "3. Flush/pour flush to pit latrine – private"),
                            ("4", "4. Ventilated improved pit (VIP) latrine – private "),
                            ("5", "5. Pit latrine with slab – private"),
                            ("6", "6. Composting toilet – private"),
                            ("7", "7. EcoSan – private"),
                            ("8", "8. Flush/pour flush to piped sewer system – shared"),
                            ("9", "9. Flush/pour flush to septic tank – shared"),
                            ("10", "10. Flush/pour flush to pit latrine – shared"),
                            ("11", "11. Ventilated improved pit (VIP) latrine – shared"),
                            ("12", "12. Pit latrine with slab – shared"),
                            ("13", "13. Composting toilet – shared"),
                            ("14", "14. EcoSan – shared"),
                            (
                                "15",
                                "15. Flush/pour flush not to sewer/septic tank/pit latrine",
                            ),
                            ("16", "16. Pit latrine with slab (non-washable)"),
                            ("17", "17. Pit latrine without slab/open pit"),
                            ("18", "18. Bucket"),
                            ("19", "19. Hanging toilet/hanging latrine"),
                            ("20", "20. Open defecation (no facility/bush/field)"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="Note: 'private' (1-7) is a toilet solely used by the household and 'shared' (8-14) is a toilet shared by two or more households.",
                        max_length=25,
                        verbose_name="What type of toilet is mainly used in your household?",
                    ),
                ),
                (
                    "roof_material",
                    models.CharField(
                        choices=[
                            ("1", "Thatch, Straw"),
                            ("2", "Mud and poles"),
                            ("3", "Tin"),
                            ("4", "Wood"),
                            ("5", "Iron sheet"),
                            ("6", "Tiles "),
                            ("7", "Cement"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the major construction material of the roof?",
                    ),
                ),
                (
                    "eaves",
                    models.CharField(
                        choices=[
                            ("1", "All eaves closed"),
                            ("2", "All eaves open"),
                            ("3", "Partially closed"),
                        ],
                        max_length=25,
                        verbose_name="Are the eaves open, partially or fully closed?",
                    ),
                ),
                (
                    "external_wall_material",
                    models.CharField(
                        choices=[
                            ("1", "Thatch, Straw"),
                            ("2", "Mud and poles"),
                            ("3", "Timber"),
                            ("4", "Un-burnt bricks"),
                            ("5", "Burnt bricks with mud"),
                            ("6", "Burnt bricks with cement"),
                            ("7", "Cement blocks"),
                            ("8", "Stone"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the major construction material of the external wall?",
                    ),
                ),
                (
                    "external_wall_material_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER construction material, specify",
                    ),
                ),
                (
                    "external_window_material",
                    models.CharField(
                        choices=[
                            ("1", "Glass"),
                            ("2", "Bags"),
                            ("3", "Wood"),
                            ("4", "Iron/metal"),
                            ("5", "Screens"),
                            ("6", "No windows"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the main material on external windows?",
                    ),
                ),
                (
                    "external_window_material_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER main material, specify",
                    ),
                ),
                (
                    "window_screens",
                    models.CharField(
                        choices=[
                            ("1", "All windows screened"),
                            ("2", "No windows screened"),
                            ("3", "Some windows screened"),
                        ],
                        max_length=25,
                        verbose_name="What is the main screening material of external windows?",
                    ),
                ),
                (
                    "window_screen_type",
                    models.CharField(
                        choices=[
                            ("1", "Wire mesh"),
                            ("2", "Old bednet"),
                            ("3", "No windows screened"),
                            ("4", "No windows"),
                        ],
                        max_length=25,
                        verbose_name="Type of screening on external windows",
                    ),
                ),
                (
                    "floor_material",
                    models.CharField(
                        choices=[
                            ("6", "Earth, sand"),
                            ("7", "Dung, wood, planks, palm, bamboo"),
                            ("8", "Parquet, polished wood, vinyl, asphalt strips"),
                            ("9", "Ceramic tiles"),
                            ("10", "Cement"),
                            ("11", "Carpet"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        help_text="If there are similar amounts of more than one type of flooring, select the multiple types that apply. Otherwise select the main type of flooring",
                        max_length=25,
                        verbose_name="What is the major construction material of the floor?",
                    ),
                ),
                (
                    "electricity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does your household have electricity?",
                    ),
                ),
                (
                    "lighting_source",
                    models.CharField(
                        choices=[
                            ("1", "Electricity (e.g., hydroelectric or solar)"),
                            ("2", "Paraffin, kerosene or gas lantern "),
                            ("3", "Firewood"),
                            ("4", "Candle"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of lighting?",
                    ),
                ),
                (
                    "cooking_fuel",
                    models.CharField(
                        choices=[
                            ("1", "Electricity"),
                            ("2", "LPG/natural gas/biogas"),
                            ("3", "Kerosene"),
                            ("4", "Charcoal"),
                            ("5", "Wood"),
                            (
                                "6",
                                "Coal/lignite, straw/shrubs/grass. agricultural crop, animal dung",
                            ),
                            ("7", "No food cooked in the household"),
                            ("OTHER", "Other, specify ..."),
                        ],
                        max_length=25,
                        verbose_name="What type of fuel do you primarily use for cooking?",
                    ),
                ),
                (
                    "radio",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Radio",
                    ),
                ),
                (
                    "television",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Television",
                    ),
                ),
                (
                    "mobile_phone",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Mobile phone",
                    ),
                ),
                (
                    "computer",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Computer",
                    ),
                ),
                (
                    "telephone",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Non-mobile telephone",
                    ),
                ),
                (
                    "fridge",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Fridge",
                    ),
                ),
                (
                    "generator",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Generator",
                    ),
                ),
                (
                    "iron",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Iron",
                    ),
                ),
                (
                    "bicycle",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Bicycle",
                    ),
                ),
                (
                    "motorcycle",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Motorcycle/scooter (PikiPiki/Boda Boda)",
                    ),
                ),
                (
                    "dala_dala",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Dala Dala",
                    ),
                ),
                (
                    "car",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Car",
                    ),
                ),
                (
                    "motorboat",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Boat with a motor",
                    ),
                ),
                (
                    "large_livestock",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Large Livestock (e.g. cows, bulls, other cattle, horses, donkeys)",
                    ),
                ),
                (
                    "small_animals",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Small animals (goats, sheep, chickens or other poultry, etc)",
                    ),
                ),
                (
                    "shop",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="A business or shop",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HE Baseline: Assets",
                "verbose_name_plural": "HE Baseline: Assets",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site", "id"],
                        name="intecomm_su_subject_db2b9f_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="intecomm_su_subject_6c343f_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
    ]
