# Generated by Django 4.2.3 on 2023-07-28 01:01

from django.db import migrations, models
import edc_crf.model_mixins.crf_status_model_mixin


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_subject", "0067_auto_20230726_0008"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="historicalhba1cresult",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalhba1cresult",
            name="site",
        ),
        migrations.RemoveField(
            model_name="historicalhba1cresult",
            name="subject_visit",
        ),
        migrations.RemoveField(
            model_name="historicalinvestigations",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalinvestigations",
            name="site",
        ),
        migrations.RemoveField(
            model_name="historicalinvestigations",
            name="subject_visit",
        ),
        migrations.RemoveField(
            model_name="investigations",
            name="reason",
        ),
        migrations.RemoveField(
            model_name="investigations",
            name="site",
        ),
        migrations.RemoveField(
            model_name="investigations",
            name="subject_visit",
        ),
        migrations.AlterModelOptions(
            name="arvregimens",
            options={"verbose_name": "ARV Regimens", "verbose_name_plural": "ARV Regimens"},
        ),
        migrations.AlterModelOptions(
            name="historicalsubjectrequisition",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Subject requisition",
                "verbose_name_plural": "historical Subject requisitions",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalsubjectvisit",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Subject visit",
                "verbose_name_plural": "historical Subject visits",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalurinedipsticktest",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Urine dipstick test",
                "verbose_name_plural": "historical Urine dipstick tests",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalurinepregnancy",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Urine pregnancy test",
                "verbose_name_plural": "historical Urine pregnancy tests",
            },
        ),
        migrations.AlterModelOptions(
            name="malariatest",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Malaria Test",
                "verbose_name_plural": "Malaria Tests",
            },
        ),
        migrations.AlterModelOptions(
            name="subjectrequisition",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Subject requisition",
                "verbose_name_plural": "Subject requisitions",
            },
        ),
        migrations.AlterModelOptions(
            name="subjectvisit",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "verbose_name": "Subject visit",
                "verbose_name_plural": "Subject visits",
            },
        ),
        migrations.AlterModelOptions(
            name="urinedipsticktest",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Urine dipstick test",
                "verbose_name_plural": "Urine dipstick tests",
            },
        ),
        migrations.AlterModelOptions(
            name="urinepregnancy",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Urine pregnancy test",
                "verbose_name_plural": "Urine pregnancy tests",
            },
        ),
        migrations.AddField(
            model_name="bloodresultsfbc",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultsfbc",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.AddField(
            model_name="cd4result",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="cd4result",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultsfbc",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultsfbc",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.AddField(
            model_name="historicalcd4result",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="historicalcd4result",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectrequisition",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectrequisition",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.AddField(
            model_name="subjectrequisition",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AddField(
            model_name="subjectrequisition",
            name="crf_status_comments",
            field=models.TextField(
                blank=True,
                help_text="for example, why some data is still pending",
                null=True,
                verbose_name="Any comments related to status of this CRF",
            ),
        ),
        migrations.DeleteModel(
            name="Hba1cResult",
        ),
        migrations.DeleteModel(
            name="HistoricalHba1cResult",
        ),
        migrations.DeleteModel(
            name="HistoricalInvestigations",
        ),
        migrations.DeleteModel(
            name="Investigations",
        ),
    ]
