# Generated by Django 4.2.3 on 2023-08-03 00:05
from django.db import migrations
from edc_list_data import PreloadData
from tqdm import tqdm

from intecomm_lists.list_data import list_data


def update_ethnicity_on_he(apps, schema_editor):
    list_model_cls = apps.get_model("edc_he.ethnicities")
    list_model_cls.objects.filter(name="mkuria-mshashi").update(name="mkuria_mshashi")
    list_model_cls.objects.filter(name="mkara-mkerewe").update(name="mkara_mkerewe")
    ld = {"edc_he.ethnicities": list_data.get("edc_he.ethnicities")}
    PreloadData(list_data=ld, apps=apps)
    household_head_cls = apps.get_model("intecomm_subject.healtheconomicshouseholdhead")
    total = household_head_cls.objects.all().count()
    for obj in tqdm(household_head_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.hoh_ethnicity_old)
        obj.hoh_ethnicity_id = list_model_obj.id
        obj.save_base(update_fields="hoh_ethnicity")


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_subject", "0071_healtheconomicshouseholdhead_hoh_ethnicity_and_more"),
    ]

    operations = [migrations.RunPython(update_ethnicity_on_he)]
