# Generated by Django 4.2.3 on 2023-08-03 01:59
from django.db import migrations
from tqdm import tqdm


def update_ethnicity_on_he(apps, schema_editor):
    list_model_cls = apps.get_model("edc_he.ethnicities")
    healtheconomicspatient_cls = apps.get_model("intecomm_subject.healtheconomicspatient")
    total = healtheconomicspatient_cls.objects.all().count()
    for obj in tqdm(healtheconomicspatient_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.pat_ethnicity_old)
        obj.pat_ethnicity_id = list_model_obj.id
        obj.save_base(update_fields="pat_ethnicity")


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_subject", "0074_healtheconomicspatient_pat_ethnicity_and_more"),
    ]

    operations = [migrations.RunPython(update_ethnicity_on_he)]
