# Generated by Django 4.2.3 on 2023-08-03 03:34
from django.db import migrations
from edc_list_data import PreloadData
from tqdm import tqdm

from intecomm_lists.list_data import list_data


def update_religion_on_he(apps, schema_editor):
    list_model_cls = apps.get_model("edc_he.religions")
    list_model_cls.objects.filter(name="seventh-day-adventist").update(
        name="seventh_day_adventist"
    )
    list_model_cls.objects.filter(name="assemblies-of-god").update(name="tz_assemblies_of_god")
    list_model_cls.objects.filter(name="african-inland-church").update(
        name="african_inland_church"
    )
    list_model_cls.objects.filter(name="none").update(name="no_religion")
    ld = {"edc_he.religions": list_data.get("edc_he.religions")}
    PreloadData(list_data=ld, apps=apps)

    householdhead_cls = apps.get_model("intecomm_subject.healtheconomicshouseholdhead")
    total = householdhead_cls.objects.all().count()
    for obj in tqdm(householdhead_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.hoh_religion_old)
        obj.hoh_religion_id = list_model_obj.id
        obj.save_base(update_fields="hoh_religion")

    patient_cls = apps.get_model("intecomm_subject.healtheconomicspatient")
    total = patient_cls.objects.all().count()
    for obj in tqdm(patient_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.pat_religion_old)
        obj.pat_religion_id = list_model_obj.id
        obj.save_base(update_fields="pat_religion")


class Migration(migrations.Migration):
    dependencies = [
        (
            "intecomm_subject",
            "0078_alter_healtheconomicshouseholdhead_hoh_religion_old_and_more",
        ),
    ]

    operations = [migrations.RunPython(update_religion_on_he)]
