# Generated by Django 4.2.3 on 2023-08-03 15:28
from django.db import migrations
from edc_he.list_data import list_data
from edc_list_data import PreloadData
from tqdm import tqdm


def update_employment_type_and_education_on_he(apps, schema_editor):
    ld = {
        "edc_he.employmenttype": list_data.get("edc_he.employmenttype"),
        "edc_he.education": list_data.get("edc_he.education"),
    }
    PreloadData(list_data=ld, apps=apps)

    print("employment healtheconomicshouseholdhead\n")
    # employment
    list_model_cls = apps.get_model("edc_he.employmenttype")
    householdhead_cls = apps.get_model("intecomm_subject.healtheconomicshouseholdhead")
    total = householdhead_cls.objects.all().count()
    for obj in tqdm(householdhead_cls.objects.all(), total=total):
        if obj.hoh_employment_type_old == "3":
            hoh_employment_type_old = "2"
        else:
            hoh_employment_type_old = obj.hoh_employment_type_old
        list_model_obj = list_model_cls.objects.get(name=hoh_employment_type_old)
        obj.hoh_employment_type_id = list_model_obj.id
        obj.save_base(update_fields="hoh_employment_type")

    print("employment healtheconomicspatient\n")
    patient_cls = apps.get_model("intecomm_subject.healtheconomicspatient")
    total = patient_cls.objects.all().count()
    for obj in tqdm(patient_cls.objects.all(), total=total):
        if obj.pat_employment_type_old == "3":
            pat_employment_type_old = "2"
        else:
            pat_employment_type_old = obj.pat_employment_type_old
        list_model_obj = list_model_cls.objects.get(name=pat_employment_type_old)
        obj.pat_employment_type_id = list_model_obj.id
        obj.save_base(update_fields="pat_employment_type")

    # education
    print("education healtheconomicshouseholdhead\n")
    list_model_cls = apps.get_model("edc_he.education")
    householdhead_cls = apps.get_model("intecomm_subject.healtheconomicshouseholdhead")
    total = householdhead_cls.objects.all().count()
    for obj in tqdm(householdhead_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.hoh_education_old)
        obj.hoh_education_id = list_model_obj.id
        obj.save_base(update_fields="hoh_education_id")

    print("education healtheconomicspatient\n")
    patient_cls = apps.get_model("intecomm_subject.healtheconomicspatient")
    total = patient_cls.objects.all().count()
    for obj in tqdm(patient_cls.objects.all(), total=total):
        list_model_obj = list_model_cls.objects.get(name=obj.pat_education_old)
        obj.pat_education_id = list_model_obj.id
        obj.save_base(update_fields="pat_education_id")


class Migration(migrations.Migration):
    dependencies = [
        ("intecomm_subject", "0082_healtheconomicshouseholdhead_hoh_education_and_more"),
    ]

    operations = [migrations.RunPython(update_employment_type_and_education_on_he)]
