# Generated by Django 4.2.3 on 2023-08-05 04:18

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("edc_he", "0007_alter_healtheconomicshouseholdhead_hoh_age_and_more"),
        (
            "intecomm_subject",
            "0089_alter_healtheconomicshouseholdhead_hoh_education_and_more",
        ),
    ]

    operations = [
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_age",
            field=models.IntegerField(
                help_text="In years. Note: if you are the household head, indicate your age as of today",
                validators=[
                    django.core.validators.MinValueValidator(18),
                    django.core.validators.MaxValueValidator(110),
                ],
                verbose_name="How old is the household head?",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_education",
            field=models.ForeignKey(
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_he.education",
                verbose_name="Highest level of education completed by the household head?",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_employment_status",
            field=models.CharField(
                choices=[
                    ("1", "Full time employed"),
                    ("2", "Regular part time employed "),
                    ("3", "Irregular/ occasional/ day worker employment"),
                    ("4", "Non-paid/ voluntary role "),
                    ("5", "Student"),
                    ("6", "Homemaker"),
                    ("7", "Unemployed (able to work)"),
                    ("8", "Unemployed (unable to work)"),
                    ("dont_know", "Don’t know"),
                    ("N/A", "Not applcable"),
                ],
                default="N/A",
                help_text="Not applicable if patient is head of household",
                max_length=25,
                verbose_name="Household head’s employment status",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_employment_type",
            field=models.ForeignKey(
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_he.employmenttype",
                verbose_name="Household head’s type of employment",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_ethnicity",
            field=models.ForeignKey(
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_he.ethnicities",
                verbose_name="What is the household head’s ethnic background?",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_gender",
            field=models.CharField(
                choices=[("M", "Male"), ("F", "Female")],
                help_text="Note: if you are the household head, indicate your gender",
                max_length=15,
                verbose_name="Is the household head female or male?",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_insurance",
            field=models.ManyToManyField(
                help_text="Not applicable if patient is head of household",
                related_name="+",
                to="edc_he.insurancetypes",
                verbose_name="Household head’s health insurance and ‘club’ status ",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_marital_status",
            field=models.CharField(
                choices=[
                    ("1", "Never Married (but not co-habiting)"),
                    ("2", "Co-habiting"),
                    ("3", "Currently Married"),
                    ("4", "Separated/Divorced"),
                    ("5", "Widowed"),
                    ("OTHER", "Other, specify ..."),
                    ("dont_know", "Don’t know"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="Not applicable if patient is head of household",
                max_length=25,
                verbose_name="Household head’s marital status",
            ),
        ),
        migrations.AlterField(
            model_name="healtheconomicshouseholdhead",
            name="hoh_religion",
            field=models.ForeignKey(
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_he.religions",
                verbose_name="How would you describe the household head’s religious orientation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_age",
            field=models.IntegerField(
                help_text="In years. Note: if you are the household head, indicate your age as of today",
                validators=[
                    django.core.validators.MinValueValidator(18),
                    django.core.validators.MaxValueValidator(110),
                ],
                verbose_name="How old is the household head?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_education",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_he.education",
                verbose_name="Highest level of education completed by the household head?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_employment_status",
            field=models.CharField(
                choices=[
                    ("1", "Full time employed"),
                    ("2", "Regular part time employed "),
                    ("3", "Irregular/ occasional/ day worker employment"),
                    ("4", "Non-paid/ voluntary role "),
                    ("5", "Student"),
                    ("6", "Homemaker"),
                    ("7", "Unemployed (able to work)"),
                    ("8", "Unemployed (unable to work)"),
                    ("dont_know", "Don’t know"),
                    ("N/A", "Not applcable"),
                ],
                default="N/A",
                help_text="Not applicable if patient is head of household",
                max_length=25,
                verbose_name="Household head’s employment status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_employment_type",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_he.employmenttype",
                verbose_name="Household head’s type of employment",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_ethnicity",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_he.ethnicities",
                verbose_name="What is the household head’s ethnic background?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_gender",
            field=models.CharField(
                choices=[("M", "Male"), ("F", "Female")],
                help_text="Note: if you are the household head, indicate your gender",
                max_length=15,
                verbose_name="Is the household head female or male?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_marital_status",
            field=models.CharField(
                choices=[
                    ("1", "Never Married (but not co-habiting)"),
                    ("2", "Co-habiting"),
                    ("3", "Currently Married"),
                    ("4", "Separated/Divorced"),
                    ("5", "Widowed"),
                    ("OTHER", "Other, specify ..."),
                    ("dont_know", "Don’t know"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="Not applicable if patient is head of household",
                max_length=25,
                verbose_name="Household head’s marital status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhealtheconomicshouseholdhead",
            name="hoh_religion",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Not applicable if patient is head of household",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_he.religions",
                verbose_name="How would you describe the household head’s religious orientation?",
            ),
        ),
    ]
