# Clinical Report Quality Assurance Checklist

## General Quality Standards

### Completeness
- [ ] All required sections present
- [ ] No blank fields or missing information
- [ ] All relevant clinical information included
- [ ] Timeline of events clear and complete
- [ ] All diagnostic tests and results documented
- [ ] All treatments and interventions documented
- [ ] Follow-up plan specified

### Accuracy
- [ ] Patient demographics correct
- [ ] Dates and times accurate
- [ ] Laboratory values with correct units and reference ranges
- [ ] Medication names, doses, and frequencies correct
- [ ] Diagnoses coded correctly (ICD-10)
- [ ] Procedures coded correctly (CPT if applicable)
- [ ] No contradictory information

### Clarity
- [ ] Clear, professional language
- [ ] Medical terminology used appropriately
- [ ] Abbreviations defined or standard only
- [ ] Logical organization and flow
- [ ] Legible (if handwritten)
- [ ] No ambiguous statements
- [ ] Clinical reasoning clearly explained

### Timeliness
- [ ] Documented in real-time or shortly after encounter
- [ ] Discharge summary completed within 24-48 hours
- [ ] Critical results communicated immediately
- [ ] Regulatory reporting deadlines met

---

## Case Report Quality Checklist

### CARE Guidelines Compliance
- [ ] Title includes "case report"
- [ ] Keywords provided (2-5 MeSH terms)
- [ ] Structured abstract with all elements
- [ ] Introduction explains novelty
- [ ] Patient information present and de-identified
- [ ] Clinical findings documented
- [ ] Timeline provided (table or figure)
- [ ] Diagnostic assessment detailed
- [ ] Therapeutic interventions described
- [ ] Follow-up and outcomes reported
- [ ] Discussion with literature review
- [ ] Patient perspective included (if possible)
- [ ] Informed consent statement present

### Privacy and Ethics
- [ ] Informed consent obtained and documented
- [ ] All 18 HIPAA identifiers removed
- [ ] Dates removed or approximated
- [ ] Ages reported appropriately (>89 aggregated)
- [ ] Geographic information limited to state
- [ ] Images de-identified or consented
- [ ] IRB approval if applicable

### Scientific Quality
- [ ] Novelty clearly established
- [ ] Literature search comprehensive
- [ ] Differential diagnosis considered
- [ ] Causality addressed
- [ ] Limitations acknowledged
- [ ] Learning points actionable
- [ ] References current and relevant

---

## Clinical Trial Report Quality Checklist

### SAE Report Checklist
- [ ] All administrative information complete
- [ ] Subject de-identified (ID number only)
- [ ] Event description detailed
- [ ] MedDRA coding applied
- [ ] Seriousness criteria documented
- [ ] Severity assessed
- [ ] Outcome specified
- [ ] Causality assessment completed with rationale
- [ ] Expectedness determined
- [ ] Action taken with study drug documented
- [ ] Treatment for event described
- [ ] Narrative comprehensive and chronological
- [ ] Critical findings communicated if applicable
- [ ] Regulatory timelines met (7-day, 15-day)

### Clinical Study Report (CSR) Checklist
- [ ] ICH-E3 structure followed
- [ ] Synopsis complete and accurate
- [ ] All sections numbered correctly
- [ ] Abbreviations defined
- [ ] Ethics approvals documented
- [ ] Investigator list complete
- [ ] Study design clearly described
- [ ] Sample size justified
- [ ] Statistical methods specified
- [ ] CONSORT diagram included
- [ ] Baseline demographics table
- [ ] Primary endpoint results
- [ ] All secondary endpoints reported
- [ ] Adverse events summarized
- [ ] Individual SAE narratives included
- [ ] Discussion and conclusions present
- [ ] Appendices complete (protocol, CRFs, etc.)

---

## Diagnostic Report Quality Checklist

### Radiology Report
- [ ] Patient demographics complete
- [ ] Clinical indication documented
- [ ] Comparison studies noted
- [ ] Technique described
- [ ] Findings systematic and comprehensive
- [ ] Measurements provided for abnormalities
- [ ] Impression summarizes key findings
- [ ] Answers clinical question
- [ ] Recommendations specified
- [ ] Critical results communicated
- [ ] Structured reporting used if applicable (BI-RADS, Lung-RADS, etc.)
- [ ] Report signed and dated

### Pathology Report
- [ ] Specimen labeled correctly
- [ ] Clinical history provided
- [ ] Gross description detailed
- [ ] Microscopic description comprehensive
- [ ] Diagnosis clear and specific
- [ ] Cancer staging complete (if applicable)
- [ ] Margins documented
- [ ] Lymph nodes quantified
- [ ] Synoptic reporting used for cancer (CAP protocol)
- [ ] Immunohistochemistry results included
- [ ] Molecular results included if applicable
- [ ] Report signed by pathologist

### Laboratory Report
- [ ] Specimen type documented
- [ ] Collection time documented
- [ ] Results with units
- [ ] Reference ranges provided
- [ ] Critical values flagged
- [ ] Critical values communicated
- [ ] Specimen quality noted
- [ ] Methodology specified (if relevant)
- [ ] Interpretation provided (when applicable)
- [ ] LOINC codes assigned (for interoperability)
- [ ] Report signed and dated

---

## Patient Documentation Quality Checklist

### SOAP Note
- [ ] Chief complaint documented
- [ ] HPI comprehensive (≥4 elements)
- [ ] Review of systems performed
- [ ] Vital signs recorded
- [ ] Physical exam documented (relevant systems)
- [ ] Assessment with differential diagnosis
- [ ] Plan specific and actionable
- [ ] Return precautions provided
- [ ] Follow-up arranged
- [ ] Documentation supports billing level
- [ ] Signed, dated, and timed

### History and Physical (H&P)
- [ ] Chief complaint
- [ ] Detailed HPI
- [ ] Past medical history
- [ ] Past surgical history
- [ ] Medications reconciled
- [ ] Allergies documented
- [ ] Family history
- [ ] Social history
- [ ] Review of systems (≥10 systems for comprehensive)
- [ ] Complete physical exam (≥8 systems)
- [ ] Laboratory and imaging results
- [ ] Assessment and plan for each problem
- [ ] Code status documented
- [ ] Completed within 24 hours of admission
- [ ] Signed and cosigned (if required)

### Discharge Summary
- [ ] Admission and discharge dates
- [ ] Length of stay
- [ ] Admission diagnosis
- [ ] Discharge diagnoses (ICD-10 coded)
- [ ] Hospital course narrative
- [ ] Procedures performed
- [ ] Discharge medications reconciled
- [ ] New/changed/discontinued medications clearly marked
- [ ] Discharge condition
- [ ] Discharge disposition
- [ ] Follow-up appointments
- [ ] Patient instructions
- [ ] Return precautions
- [ ] Pending tests documented
- [ ] Code status
- [ ] Completed within 24-48 hours
- [ ] Sent to outpatient providers

---

## Regulatory Compliance Checklist

### HIPAA Compliance
- [ ] Only minimum necessary PHI disclosed
- [ ] PHI secured and protected
- [ ] Patient authorization obtained (if required)
- [ ] Business associate agreement (if applicable)
- [ ] Audit trail maintained (electronic records)
- [ ] Breach notification procedures followed
- [ ] De-identification performed correctly

### FDA/ICH-GCP Compliance (Clinical Trials)
- [ ] GCP principles followed
- [ ] Informed consent documented
- [ ] IRB approval current
- [ ] Protocol adherence documented
- [ ] Source documentation adequate
- [ ] ALCOA-CCEA principles met
- [ ] 21 CFR Part 11 compliance (electronic records)
- [ ] Safety reporting timelines met
- [ ] Essential documents maintained

---

## Writing Quality Checklist

### Grammar and Style
- [ ] Correct spelling
- [ ] Proper grammar
- [ ] Appropriate punctuation
- [ ] Consistent verb tense
- [ ] Professional tone
- [ ] Objective language
- [ ] No personal pronouns in formal reports
- [ ] Active voice used appropriately

### Format and Presentation
- [ ] Consistent formatting
- [ ] Appropriate font and size
- [ ] Adequate margins
- [ ] Page numbers (if applicable)
- [ ] Headers/footers appropriate
- [ ] Tables properly formatted with labels
- [ ] Figures high quality with legends
- [ ] References formatted correctly

### Medical Terminology
- [ ] Terminology accurate
- [ ] Abbreviations standard only
- [ ] Abbreviations defined on first use
- [ ] Units of measurement correct
- [ ] Drug names correct (generic preferred)
- [ ] Anatomical terms correct
- [ ] Coding accurate (ICD-10, CPT, MedDRA)

---

## Documentation Integrity Checklist

### Legal and Ethical Standards
- [ ] Facts documented, not opinions
- [ ] Patient quotes when relevant
- [ ] Non-compliance documented objectively
- [ ] No alterations to original record
- [ ] Addendums used for corrections
- [ ] Addendums clearly labeled
- [ ] All entries signed and dated
- [ ] Authorship clear

### Billing and Coding Support
- [ ] Medical necessity documented
- [ ] Complexity of care documented
- [ ] Time documented (if time-based billing)
- [ ] ICD-10 codes appropriate and specific
- [ ] CPT codes match documented services
- [ ] Modifiers appropriate
- [ ] Documentation supports level of service billed

---

## Final Review Checklist

Before finalizing any clinical report:

- [ ] Read through entire document
- [ ] Check for completeness
- [ ] Verify all data accuracy
- [ ] Ensure logical flow
- [ ] Check spelling and grammar
- [ ] Verify patient identifiers correct (or removed if de-identified)
- [ ] Ensure compliance with regulations
- [ ] Confirm all required signatures
- [ ] Verify proper distribution
- [ ] Archive copy appropriately

---

## Quality Metrics to Track

- [ ] Report turnaround time
- [ ] Amendment/addendum rate
- [ ] Critical value communication time
- [ ] Completeness score
- [ ] Accuracy rate (errors per report)
- [ ] Compliance rate
- [ ] Patient safety events related to documentation
- [ ] Peer review feedback

---

**Quality Assurance Reviewer:**

**Name:** ____________________  
**Date:** ____________________  
**Signature:** ____________________

**Quality Score:** _____ / 100

**Issues Identified:**
1. [Issue and recommendation]
2. [Issue and recommendation]

**Follow-up Required:** [ ] Yes  [ ] No


