# Radiology Report Template

## Patient Information

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age:** [years]  
**Sex:** [M/F]  
**Exam Date:** [MM/DD/YYYY]  
**Exam Time:** [HH:MM]  
**Accession Number:** [Number]

**Referring Physician:** [Name]  
**Ordering Service:** [Service/Department]

---

## Examination

**Exam Type:** [CT/MRI/X-Ray/Ultrasound/PET/Nuclear Medicine scan]  
**Body Part:** [Anatomical region - e.g., Chest, Abdomen and Pelvis, Brain]  
**Contrast:** [Yes - IV/Oral/Both | No]  
**Laterality:** [Right/Left/Bilateral if applicable]

---

## Clinical Indication

[Reason for examination, relevant clinical history, specific question to be answered]

Example: "Rule out pulmonary embolism in patient with acute dyspnea and chest pain. History of recent surgery."

---

## Comparison

**Prior Studies:**  
[Modality] of [body part] from [date]: [Available/Not available for comparison]

Example: "CT chest without contrast from 6 months prior (01/15/2023) available for comparison"

OR: "No prior imaging available for comparison"

---

## Technique

[Detailed description of imaging parameters and protocol]

**For CT:**
```
Multidetector CT of the [body region] was performed [without/with] intravenous 
contrast. [Volume] mL of [iodinated contrast agent name] was administered 
intravenously. Images were acquired in the [arterial/venous/delayed] phase(s).
Multiplanar reconstructions were performed.

Technical quality: [Adequate / Limited by motion artifact / Limited by patient body habitus]
Radiation dose (DLP): [mGy-cm]
```

**For MRI:**
```
MRI of the [body region] was performed [without/with] intravenous contrast
using the following sequences: [list sequences - T1, T2, FLAIR, DWI, etc.]
[Volume] mL of [gadolinium-based contrast agent] was administered intravenously.
Multiplanar imaging was obtained.

Technical quality: [Adequate / Limited by motion artifact]
```

**For X-Ray:**
```
[Number] views of the [body part] were obtained: [AP/PA/Lateral/Oblique]
Technical quality: [Adequate penetration and positioning / Limited by...]
```

**For Ultrasound:**
```
Real-time ultrasound examination of the [body part] was performed using 
[linear/curved] array transducer.
Technical quality: [Adequate / Limited by bowel gas / Limited by body habitus]
```

---

## Findings

[Systematic, comprehensive description of findings organized by anatomical region or organ system]

### [Region/Organ 1]

[Detailed findings - size, density/intensity, enhancement pattern, abnormalities]

**Normal statement:** "[Organ] is normal in size, contour, and [attenuation/signal intensity]. No focal lesions."

**Abnormal statement:** "[Description of abnormality with measurements]"

Example:
```
Lungs:
- Bilateral ground-glass opacities are present, predominant in the lower lobes.
- Right lower lobe consolidation measuring 4.5 x 3.2 cm with air bronchograms.
- No pleural effusion or pneumothorax.
- Airways are patent bilaterally.
```

### [Region/Organ 2]

[Findings]

### [Additional Regions as Applicable]

**For Chest CT:**
- Lungs
- Airways
- Pleura
- Mediastinum and Hila
- Heart and Great Vessels
- Chest Wall
- Upper Abdomen (if included)
- Bones

**For Abdomen/Pelvis CT:**
- Liver
- Gallbladder
- Spleen
- Pancreas
- Kidneys and Adrenals
- Gastrointestinal Tract
- Peritoneum and Mesentery
- Retroperitoneum
- Bladder
- Pelvic Organs
- Vasculature
- Lymph Nodes
- Bones
- Soft Tissues

**For Brain MRI:**
- Brain Parenchyma
- Ventricles and Cisterns
- Extra-axial Spaces
- Vascular Structures
- Orbits (if included)
- Skull Base and Calvarium

### Measurements (if applicable)

| Structure | Measurement | Normal Range |
|-----------|-------------|--------------|
| [Lesion/mass] | [Size in cm, 3 dimensions] | - |
| [Organ] | [Size] | [Normal size] |

---

## Impression

[Concise summary of key findings with clinical interpretation]

**Format as numbered list in order of clinical importance:**

1. **[Most important finding]** - [Diagnosis or differential, clinical significance]
   - [Additional details, comparison to prior if applicable]
   - [Recommendation if any]

2. **[Second finding]** - [Interpretation]

3. **[Additional findings]**

**Alternative format for normal study:**
```
No acute intrathoracic abnormality.
Specifically, no evidence of pulmonary embolism.
```

**Recommendations (if applicable):**
- [Further imaging, follow-up imaging interval, clinical correlation, biopsy, etc.]
- [Timeframe for follow-up]

Example:
```
Recommend follow-up CT in 3 months to assess for interval change.
Clinical correlation with laboratory values recommended.
Consider PET/CT for further characterization if clinically indicated.
```

---

## Communication of Critical Results

[If critical/urgent finding]

**Critical finding:** [Description]

**Communicated to:** [Name and role of person notified]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Method:** [Phone call / Page / In person]  
**Read back verified:** [Yes]

---

## Structured Reporting (if applicable)

### For Lung Nodules (Lung-RADS):
**Category:** [Lung-RADS 0/1/2/3/4A/4B/4X]  
**Recommendation:** [Per Lung-RADS guidelines]

### For Breast Imaging (BI-RADS):
**Category:** [BI-RADS 0/1/2/3/4/5/6]  
**Recommendation:** [Per BI-RADS guidelines]

### For Liver Lesions (LI-RADS):
**Category:** [LI-RADS 1/2/3/4/5/M/TIV]  
**Features:** [Arterial phase hyperenhancement, washout, capsule, size, growth]

### For Prostate (PI-RADS):
**Score:** [PI-RADS 1/2/3/4/5]  
**Location:** [Peripheral zone / Transition zone]

---

## Signature

**Interpreted by:**  
[Radiologist name, MD]  
[Board certification]  
[NPI number if required]

**Electronically signed:** [Date and time]

**Dictated:** [Date and time]  
**Transcribed:** [Date and time]  
**Signed:** [Date and time]

---

## Template Notes

### General Principles

**Be systematic:**
- Use consistent order (head to toe, outside to inside)
- Don't skip regions even if normal
- Include pertinent negatives

**Be specific:**
- Provide measurements (size in 3 dimensions for masses)
- Describe location precisely
- Use standardized terminology (RadLex)
- Quantify when possible

**Be clear:**
- Avoid ambiguous language
- Make impression stand-alone
- Answer the clinical question directly
- State what IS present, not just what isn't

**Communication:**
- Critical findings require immediate verbal notification
- Document communication
- Provide specific recommendations
- Suggest next steps when appropriate

### Measurement Guidelines

**Lesions/Masses:**
- Three dimensions: [length x width x height in cm]
- Use consistent measurement method for follow-up

**Lymph Nodes:**
- Short axis diameter in cm
- Note morphology (round vs. oval)

**Organ Sizes:**
- Use established normal ranges
- Age and sex appropriate

### Comparison Statements

**Improved:**
"Interval decrease in size of right upper lobe mass from 3.5 cm to 2.1 cm."

**Stable:**
"Unchanged 8 mm left lower lobe nodule, stable for 2 years."

**Worsened:**
"Interval increase in bilateral pleural effusions, now moderate on the right."

**New finding:**
"New 1.5 cm right adrenal nodule, not present on prior CT."

### Differential Diagnosis Language

**Definite:** "Consistent with..."  
**Probable:** "Most likely represents..." or "Favors..."  
**Possible:** "Suggestive of..." or "Differential diagnosis includes..."  
**Uncertain:** "Cannot exclude..." or "Consider..."

### Recommendations

**Follow-up imaging:**
- Specify modality, timing, and what to assess
- "Recommend CT chest in 6-12 months to assess stability"

**Further characterization:**
- "Consider MRI for further characterization"
- "Ultrasound correlation recommended"

**Clinical correlation:**
- "Clinical correlation with tumor markers recommended"
- "Correlate with patient symptoms and physical examination"

**Biopsy/Intervention:**
- "Consider biopsy for definitive diagnosis"
- "Amenable to image-guided biopsy if clinically indicated"


